/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.NamedParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;

public class BindParseNode
extends NamedParseNode {
    private final int index;

    BindParseNode(String name) {
        super(name);
        this.index = Integer.parseInt(name);
    }

    public int getIndex() {
        return this.index - 1;
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        return visitor.visit(this);
    }

    @Override
    public boolean isStateless() {
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.index;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BindParseNode other = (BindParseNode)obj;
        return this.index == other.index;
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        buf.append(':');
        buf.append(this.index);
    }
}

