/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.phoenix.monitoring.AtomicMetric;
import org.apache.phoenix.monitoring.GlobalMetric;
import org.apache.phoenix.monitoring.Metric;
import org.apache.phoenix.monitoring.MetricType;

public class GlobalMetricImpl
implements GlobalMetric {
    private AtomicLong numberOfSamples = new AtomicLong(0L);
    private Metric metric;

    public GlobalMetricImpl(MetricType type) {
        this.metric = new AtomicMetric(type);
    }

    @Override
    public void reset() {
        this.metric.reset();
        this.numberOfSamples.set(0L);
    }

    @Override
    public long getNumberOfSamples() {
        return this.numberOfSamples.get();
    }

    @Override
    public void change(long delta) {
        this.metric.change(delta);
        this.numberOfSamples.incrementAndGet();
    }

    @Override
    public void increment() {
        this.metric.increment();
        this.numberOfSamples.incrementAndGet();
    }

    @Override
    public MetricType getMetricType() {
        return this.metric.getMetricType();
    }

    @Override
    public long getValue() {
        return this.metric.getValue();
    }

    @Override
    public String getCurrentMetricState() {
        return this.metric.getCurrentMetricState() + ", Number of samples: " + this.numberOfSamples.get();
    }

    @Override
    public void decrement() {
        this.metric.decrement();
        this.numberOfSamples.incrementAndGet();
    }
}

