/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.phoenix.jdbc.DelegateStatement;
import org.apache.phoenix.jdbc.LoggingPhoenixConnection;
import org.apache.phoenix.jdbc.LoggingPhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixMetricsLog;

public class LoggingPhoenixStatement
extends DelegateStatement {
    private PhoenixMetricsLog phoenixMetricsLog;
    private String sql;
    private Connection conn;

    public LoggingPhoenixStatement(Statement stmt, PhoenixMetricsLog phoenixMetricsLog, Connection conn) {
        super(stmt);
        this.phoenixMetricsLog = phoenixMetricsLog;
        this.conn = conn;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.sql = sql;
        boolean result = super.execute(sql);
        this.loggingAutoCommitHelper();
        return result;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.sql = sql;
        LoggingPhoenixResultSet rs = new LoggingPhoenixResultSet(super.executeQuery(sql), this.phoenixMetricsLog, this.sql);
        this.loggingAutoCommitHelper();
        return rs;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.sql = sql;
        int result = super.executeUpdate(sql);
        this.loggingAutoCommitHelper();
        return result;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet resultSet = super.getResultSet();
        return resultSet == null ? null : new LoggingPhoenixResultSet(resultSet, this.phoenixMetricsLog, this.sql);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return new LoggingPhoenixResultSet(super.getGeneratedKeys(), this.phoenixMetricsLog, this.sql);
    }

    private void loggingAutoCommitHelper() throws SQLException {
        if (this.conn.getAutoCommit() && this.conn instanceof LoggingPhoenixConnection) {
            ((LoggingPhoenixConnection)this.conn).loggingMetricsHelper();
        }
    }
}

