/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.ScanningResultIterator;
import org.apache.phoenix.iterate.SnapshotScanner;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.monitoring.ScanMetricsHolder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableSnapshotResultIterator
implements ResultIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableSnapshotResultIterator.class);
    private final Scan scan;
    private ResultIterator scanIterator;
    private Configuration configuration;
    private final ScanMetricsHolder scanMetricsHolder;
    private Tuple lastTuple = null;
    private static final ResultIterator UNINITIALIZED_SCANNER = ResultIterator.EMPTY_ITERATOR;
    private ArrayList<HRegionInfo> regions;
    private HTableDescriptor htd;
    private String snapshotName;
    private Path restoreDir;
    private Path rootDir;
    private FileSystem fs;
    private int currentRegion;
    private boolean closed = false;

    public TableSnapshotResultIterator(Configuration configuration, Scan scan, ScanMetricsHolder scanMetricsHolder) throws IOException {
        this.configuration = configuration;
        this.currentRegion = -1;
        this.scan = scan;
        this.scanMetricsHolder = scanMetricsHolder;
        this.scanIterator = UNINITIALIZED_SCANNER;
        this.restoreDir = PhoenixConfigurationUtil.isMRSnapshotManagedExternally(configuration) ? new Path(configuration.get("phoenix.tableSnapshot.restore.dir")) : new Path(configuration.get("phoenix.tableSnapshot.restore.dir"), UUID.randomUUID().toString());
        this.snapshotName = configuration.get("phoenix.mapreduce.snapshot.name");
        this.rootDir = FSUtils.getRootDir((Configuration)configuration);
        this.fs = this.rootDir.getFileSystem(configuration);
        this.init();
    }

    private void init() throws IOException {
        if (!PhoenixConfigurationUtil.isMRSnapshotManagedExternally(this.configuration)) {
            RestoreSnapshotHelper.RestoreMetaChanges meta = RestoreSnapshotHelper.copySnapshotForScanner((Configuration)this.configuration, (FileSystem)this.fs, (Path)this.rootDir, (Path)this.restoreDir, (String)this.snapshotName);
            List restoredRegions = meta.getRegionsToAdd();
            this.htd = meta.getTableDescriptor();
            this.regions = new ArrayList(restoredRegions.size());
            for (HRegionInfo restoredRegion : restoredRegions) {
                if (!this.isValidRegion(restoredRegion)) continue;
                this.regions.add(restoredRegion);
            }
        } else {
            Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)this.snapshotName, (Path)this.rootDir);
            HBaseProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)this.fs, (Path)snapshotDir);
            SnapshotManifest manifest = SnapshotManifest.open((Configuration)this.configuration, (FileSystem)this.fs, (Path)snapshotDir, (HBaseProtos.SnapshotDescription)snapshotDesc);
            List regionManifests = manifest.getRegionManifests();
            this.regions = new ArrayList(regionManifests.size());
            this.htd = manifest.getTableDescriptor();
            for (SnapshotProtos.SnapshotRegionManifest srm : regionManifests) {
                HRegionInfo hri = HRegionInfo.convert((HBaseProtos.RegionInfo)srm.getRegionInfo());
                if (!this.isValidRegion(hri)) continue;
                this.regions.add(hri);
            }
        }
        Collections.sort(this.regions);
        LOGGER.info("Initialization complete with " + this.regions.size() + " valid regions");
    }

    private boolean isValidRegion(HRegionInfo hri) {
        if (hri.isOffline() && (hri.isSplit() || hri.isSplitParent())) {
            return false;
        }
        return CellUtil.overlappingKeys((byte[])this.scan.getStartRow(), (byte[])this.scan.getStopRow(), (byte[])hri.getStartKey(), (byte[])hri.getEndKey());
    }

    public boolean initSnapshotScanner() throws SQLException {
        if (this.closed) {
            return true;
        }
        ResultIterator delegate = this.scanIterator;
        if (delegate == UNINITIALIZED_SCANNER) {
            ++this.currentRegion;
            if (this.currentRegion >= this.regions.size()) {
                return false;
            }
            try {
                HRegionInfo hri = this.regions.get(this.currentRegion);
                this.scanIterator = new ScanningResultIterator((ResultScanner)new SnapshotScanner(this.configuration, this.fs, this.restoreDir, this.htd, hri, this.scan), this.scan, this.scanMetricsHolder);
            }
            catch (Throwable e) {
                throw ServerUtil.parseServerException(e);
            }
        }
        return true;
    }

    @Override
    public Tuple next() throws SQLException {
        while (this.initSnapshotScanner()) {
            try {
                this.lastTuple = this.scanIterator.next();
                if (this.lastTuple == null) continue;
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                this.lastTuple.getKey(ptr);
                Tuple tuple = this.lastTuple;
                return tuple;
            }
            finally {
                if (this.lastTuple != null) continue;
                this.scanIterator.close();
                this.scanIterator = UNINITIALIZED_SCANNER;
                continue;
            }
            break;
        }
        return null;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
        try {
            this.scanIterator.close();
            if (!PhoenixConfigurationUtil.isMRSnapshotManagedExternally(this.configuration)) {
                this.fs.delete(this.restoreDir, true);
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        finally {
            this.scanIterator = UNINITIALIZED_SCANNER;
        }
    }

    @Override
    public void explain(List<String> planSteps) {
    }

    @Override
    public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
    }
}

