/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.phoenix.coprocessor.MetaDataEndpointImpl;
import org.apache.phoenix.coprocessor.PhoenixMetaDataCoprocessorHost;
import org.apache.phoenix.coprocessor.generated.ChildLinkMetaDataProtos;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildLinkMetaDataEndpoint
extends ChildLinkMetaDataProtos.ChildLinkMetaDataService
implements CoprocessorService,
Coprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChildLinkMetaDataEndpoint.class);
    private RegionCoprocessorEnvironment env;
    private PhoenixMetaDataCoprocessorHost phoenixAccessCoprocessorHost;
    private boolean accessCheckEnabled;

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
        this.phoenixAccessCoprocessorHost = new PhoenixMetaDataCoprocessorHost(this.env);
        this.accessCheckEnabled = env.getConfiguration().getBoolean("phoenix.acls.enabled", false);
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    public Service getService() {
        return this;
    }

    @Override
    public void createViewAddChildLink(RpcController controller, ChildLinkMetaDataProtos.CreateViewAddChildLinkRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        try {
            List<Mutation> childLinkMutations = ProtobufUtil.getMutations(request);
            if (childLinkMutations.isEmpty()) {
                done.run((Object)builder.build());
                return;
            }
            byte[][] rowKeyMetaData = new byte[3][];
            MetaDataUtil.getTenantIdAndSchemaAndTableName(childLinkMutations, rowKeyMetaData);
            byte[] parentSchemaName = rowKeyMetaData[1];
            byte[] parentTableName = rowKeyMetaData[2];
            String fullparentTableName = SchemaUtil.getTableName(parentSchemaName, parentTableName);
            this.getCoprocessorHost().preCreateViewAddChildLink(fullparentTableName);
            MetaDataEndpointImpl.mutateRowsWithLocks(this.accessCheckEnabled, this.env.getRegion(), childLinkMutations, Collections.emptySet(), 0L, 0L);
        }
        catch (Throwable t) {
            LOGGER.error("Unable to write mutations to " + PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME, t);
            builder.setReturnCode(MetaDataProtos.MutationCode.UNABLE_TO_CREATE_CHILD_LINK);
            builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
            done.run((Object)builder.build());
        }
    }

    private PhoenixMetaDataCoprocessorHost getCoprocessorHost() {
        return this.phoenixAccessCoprocessorHost;
    }
}

