/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.BooleanParseNodeVisitor;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.SelectStatementRewriter;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.types.PBoolean;

public class HavingCompiler {
    private HavingCompiler() {
    }

    public static Expression compile(StatementContext context, SelectStatement statement, GroupByCompiler.GroupBy groupBy) throws SQLException {
        ParseNode having = statement.getHaving();
        if (having == null) {
            return null;
        }
        ExpressionCompiler expressionBuilder = new ExpressionCompiler(context, groupBy);
        Expression expression = having.accept(expressionBuilder);
        if (expression.getDataType() != PBoolean.INSTANCE) {
            throw TypeMismatchException.newException(PBoolean.INSTANCE, expression.getDataType(), expression.toString());
        }
        if (LiteralExpression.isBooleanFalseOrNull(expression)) {
            context.setScanRanges(ScanRanges.NOTHING);
            return null;
        }
        if (LiteralExpression.isTrue(expression)) {
            return null;
        }
        if (!expressionBuilder.isAggregate()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.ONLY_AGGREGATE_IN_HAVING_CLAUSE).build().buildException();
        }
        return expression;
    }

    public static SelectStatement rewrite(StatementContext context, SelectStatement statement, GroupByCompiler.GroupBy groupBy) throws SQLException {
        ParseNode having = statement.getHaving();
        if (having == null) {
            return statement;
        }
        HavingClauseVisitor visitor = new HavingClauseVisitor(context, groupBy);
        having.accept(visitor);
        statement = SelectStatementRewriter.moveFromHavingToWhereClause(statement, visitor.getMoveToWhereClauseExpressions());
        return statement;
    }

    private static class HavingClauseVisitor
    extends BooleanParseNodeVisitor<Void> {
        private ParseNode topNode = null;
        private boolean hasNoAggregateFunctions = true;
        private Boolean hasOnlyAggregateColumns;
        private final StatementContext context;
        private final GroupByCompiler.GroupBy groupBy;
        private final Set<ParseNode> moveToWhereClause = new LinkedHashSet<ParseNode>();

        HavingClauseVisitor(StatementContext context, GroupByCompiler.GroupBy groupBy) {
            this.context = context;
            this.groupBy = groupBy;
        }

        public Set<ParseNode> getMoveToWhereClauseExpressions() {
            return this.moveToWhereClause;
        }

        @Override
        protected boolean enterBooleanNode(ParseNode node) throws SQLException {
            if (this.topNode == null) {
                this.topNode = node;
            }
            return true;
        }

        @Override
        protected Void leaveBooleanNode(ParseNode node, List<Void> l) throws SQLException {
            if (this.topNode == node) {
                if (this.hasNoAggregateFunctions && !Boolean.FALSE.equals(this.hasOnlyAggregateColumns)) {
                    this.moveToWhereClause.add(node);
                }
                this.hasNoAggregateFunctions = true;
                this.hasOnlyAggregateColumns = null;
                this.topNode = null;
            }
            return null;
        }

        @Override
        protected boolean enterNonBooleanNode(ParseNode node) throws SQLException {
            return true;
        }

        @Override
        protected Void leaveNonBooleanNode(ParseNode node, List<Void> l) throws SQLException {
            return null;
        }

        @Override
        public boolean visitEnter(AndParseNode node) throws SQLException {
            return true;
        }

        @Override
        public Void visitLeave(AndParseNode node, List<Void> l) throws SQLException {
            return null;
        }

        @Override
        public boolean visitEnter(FunctionParseNode node) throws SQLException {
            boolean isAggregate = node.isAggregate();
            this.hasNoAggregateFunctions = this.hasNoAggregateFunctions && !isAggregate;
            return !isAggregate && super.visitEnter(node);
        }

        @Override
        public Void visit(ColumnParseNode node) throws SQLException {
            ColumnRef ref = this.context.getResolver().resolveColumn(node.getSchemaName(), node.getTableName(), node.getName());
            boolean isAggregateColumn = this.groupBy.getExpressions().indexOf(ref.newColumnExpression(node.isTableNameCaseSensitive(), node.isCaseSensitive())) >= 0;
            this.hasOnlyAggregateColumns = this.hasOnlyAggregateColumns == null ? Boolean.valueOf(isAggregateColumn) : Boolean.valueOf(this.hasOnlyAggregateColumns & isAggregateColumn);
            return null;
        }
    }
}

