/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

public class LongCache {
    private final long[] cache;
    private final int size;
    private final int associativity;

    public LongCache(int size, int associativity) {
        this.size = size;
        this.cache = new long[2 * (size + associativity)];
        this.associativity = associativity;
    }

    public long set(long key, long value) {
        int index = this.index(key);
        int oldestIndex = 0;
        long oldestValue = Long.MAX_VALUE;
        for (int i = 0; i < this.associativity; ++i) {
            int currIndex = 2 * (index + i);
            if (this.cache[currIndex] == key) {
                oldestValue = 0L;
                oldestIndex = currIndex;
                break;
            }
            if (this.cache[currIndex + 1] > oldestValue) continue;
            oldestValue = this.cache[currIndex + 1];
            oldestIndex = currIndex;
        }
        this.cache[oldestIndex] = key;
        this.cache[oldestIndex + 1] = value;
        return oldestValue;
    }

    public long get(long key) {
        int index = this.index(key);
        for (int i = 0; i < this.associativity; ++i) {
            int currIndex = 2 * (index + i);
            if (this.cache[currIndex] != key) continue;
            return this.cache[currIndex + 1];
        }
        return 0L;
    }

    private int index(long hash) {
        return (int)(Math.abs(hash) % (long)this.size);
    }
}

