/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.jdkadapter;

import com.ibm.icu.impl.icuadapter.NumberFormatJDK;
import com.ibm.icu.util.Currency;
import java.math.RoundingMode;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;

public class NumberFormatICU
extends NumberFormat {
    private static final long serialVersionUID = 4892903815641574060L;
    private com.ibm.icu.text.NumberFormat fIcuNfmt;

    private NumberFormatICU(com.ibm.icu.text.NumberFormat icuNfmt) {
        this.fIcuNfmt = icuNfmt;
    }

    public static NumberFormat wrap(com.ibm.icu.text.NumberFormat icuNfmt) {
        if (icuNfmt instanceof NumberFormatJDK) {
            return ((NumberFormatJDK)icuNfmt).unwrap();
        }
        return new NumberFormatICU(icuNfmt);
    }

    public com.ibm.icu.text.NumberFormat unwrap() {
        return this.fIcuNfmt;
    }

    @Override
    public Object clone() {
        NumberFormatICU other = (NumberFormatICU)super.clone();
        other.fIcuNfmt = (com.ibm.icu.text.NumberFormat)this.fIcuNfmt.clone();
        return other;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NumberFormatICU) {
            return ((NumberFormatICU)obj).fIcuNfmt.equals(this.fIcuNfmt);
        }
        return false;
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.fIcuNfmt.format(number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.fIcuNfmt.format(number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.fIcuNfmt.format(number, toAppendTo, pos);
    }

    @Override
    public java.util.Currency getCurrency() {
        Currency icuCurrency = this.fIcuNfmt.getCurrency();
        if (icuCurrency == null) {
            return null;
        }
        return java.util.Currency.getInstance(icuCurrency.getCurrencyCode());
    }

    @Override
    public int getMaximumFractionDigits() {
        return this.fIcuNfmt.getMaximumFractionDigits();
    }

    @Override
    public int getMaximumIntegerDigits() {
        return this.fIcuNfmt.getMaximumIntegerDigits();
    }

    @Override
    public int getMinimumFractionDigits() {
        return this.fIcuNfmt.getMinimumFractionDigits();
    }

    @Override
    public int getMinimumIntegerDigits() {
        return this.fIcuNfmt.getMinimumIntegerDigits();
    }

    @Override
    public RoundingMode getRoundingMode() {
        int icuMode = this.fIcuNfmt.getRoundingMode();
        RoundingMode mode = RoundingMode.UP;
        switch (icuMode) {
            case 2: {
                mode = RoundingMode.CEILING;
                break;
            }
            case 1: {
                mode = RoundingMode.DOWN;
                break;
            }
            case 3: {
                mode = RoundingMode.FLOOR;
                break;
            }
            case 5: {
                mode = RoundingMode.HALF_DOWN;
                break;
            }
            case 6: {
                mode = RoundingMode.HALF_EVEN;
                break;
            }
            case 4: {
                mode = RoundingMode.HALF_UP;
                break;
            }
            case 7: {
                mode = RoundingMode.UNNECESSARY;
                break;
            }
            case 0: {
                mode = RoundingMode.UP;
            }
        }
        return mode;
    }

    @Override
    public int hashCode() {
        return this.fIcuNfmt.hashCode();
    }

    @Override
    public boolean isGroupingUsed() {
        return this.fIcuNfmt.isGroupingUsed();
    }

    @Override
    public boolean isParseIntegerOnly() {
        return this.fIcuNfmt.isParseIntegerOnly();
    }

    @Override
    public Number parse(String source) throws ParseException {
        return this.fIcuNfmt.parse(source);
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        return this.fIcuNfmt.parse(source, parsePosition);
    }

    @Override
    public void setCurrency(java.util.Currency currency) {
        if (currency == null) {
            this.fIcuNfmt.setCurrency(null);
        } else {
            this.fIcuNfmt.setCurrency(Currency.getInstance(currency.getCurrencyCode()));
        }
    }

    @Override
    public void setGroupingUsed(boolean newValue) {
        this.fIcuNfmt.setGroupingUsed(newValue);
    }

    @Override
    public void setMaximumFractionDigits(int newValue) {
        this.fIcuNfmt.setMaximumFractionDigits(newValue);
    }

    @Override
    public void setMaximumIntegerDigits(int newValue) {
        this.fIcuNfmt.setMaximumIntegerDigits(newValue);
    }

    @Override
    public void setMinimumFractionDigits(int newValue) {
        this.fIcuNfmt.setMinimumFractionDigits(newValue);
    }

    @Override
    public void setMinimumIntegerDigits(int newValue) {
        this.fIcuNfmt.setMinimumIntegerDigits(newValue);
    }

    @Override
    public void setParseIntegerOnly(boolean value) {
        this.fIcuNfmt.setParseIntegerOnly(value);
    }

    @Override
    public void setRoundingMode(RoundingMode roundingMode) {
        if (roundingMode.equals((Object)RoundingMode.CEILING)) {
            this.fIcuNfmt.setRoundingMode(2);
        } else if (roundingMode.equals((Object)RoundingMode.DOWN)) {
            this.fIcuNfmt.setRoundingMode(1);
        } else if (roundingMode.equals((Object)RoundingMode.FLOOR)) {
            this.fIcuNfmt.setRoundingMode(3);
        } else if (roundingMode.equals((Object)RoundingMode.HALF_DOWN)) {
            this.fIcuNfmt.setRoundingMode(5);
        } else if (roundingMode.equals((Object)RoundingMode.HALF_EVEN)) {
            this.fIcuNfmt.setRoundingMode(6);
        } else if (roundingMode.equals((Object)RoundingMode.HALF_UP)) {
            this.fIcuNfmt.setRoundingMode(4);
        } else if (roundingMode.equals((Object)RoundingMode.UNNECESSARY)) {
            this.fIcuNfmt.setRoundingMode(7);
        } else if (roundingMode.equals((Object)RoundingMode.UP)) {
            this.fIcuNfmt.setRoundingMode(0);
        } else {
            throw new IllegalArgumentException("Invalid rounding mode was specified.");
        }
    }
}

