/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.kafka;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractIdleService;
import java.net.BindException;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.Time;
import org.I0Itec.zkclient.exception.ZkTimeoutException;
import org.apache.twill.internal.utils.Networks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmbeddedKafkaServer
extends AbstractIdleService {
    public static final String START_RETRIES = "twill.kafka.start.timeout.retries";
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedKafkaServer.class);
    private static final String DEFAULT_START_RETRIES = "5";
    private final int startTimeoutRetries;
    private final Properties properties;
    private KafkaServer server;

    public EmbeddedKafkaServer(Properties properties) {
        this.startTimeoutRetries = Integer.parseInt(properties.getProperty(START_RETRIES, DEFAULT_START_RETRIES));
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)properties);
    }

    protected void startUp() throws Exception {
        int tries = 0;
        do {
            KafkaConfig kafkaConfig = this.createKafkaConfig(this.properties);
            KafkaServer kafkaServer = this.createKafkaServer(kafkaConfig);
            try {
                kafkaServer.startup();
                this.server = kafkaServer;
            }
            catch (Exception e) {
                kafkaServer.shutdown();
                kafkaServer.awaitShutdown();
                Throwable rootCause = Throwables.getRootCause((Throwable)e);
                if (rootCause instanceof ZkTimeoutException) {
                    LOG.warn("Timeout when connecting to ZooKeeper from KafkaServer. Attempt number {}.", (Object)tries, (Object)rootCause);
                } else if (rootCause instanceof BindException) {
                    LOG.warn("Kafka failed to bind to port {}. Attempt number {}.", new Object[]{kafkaConfig.port(), tries, rootCause});
                } else {
                    throw e;
                }
                TimeUnit.MILLISECONDS.sleep((long)new Random().nextInt(200) + 1L);
            }
        } while (this.server == null && ++tries < this.startTimeoutRetries);
        if (this.server == null) {
            throw new IllegalStateException("Failed to start Kafka server after " + tries + " attempts.");
        }
    }

    protected void shutDown() throws Exception {
        if (this.server != null) {
            this.server.shutdown();
            this.server.awaitShutdown();
        }
    }

    private KafkaServer createKafkaServer(KafkaConfig kafkaConfig) {
        return new KafkaServer(kafkaConfig, new Time(){

            public long milliseconds() {
                return System.currentTimeMillis();
            }

            public long nanoseconds() {
                return System.nanoTime();
            }

            public void sleep(long ms) {
                try {
                    Thread.sleep(ms);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        });
    }

    private KafkaConfig createKafkaConfig(Properties properties) {
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)properties);
        String port = prop.getProperty("port");
        if (port == null || "0".equals(port)) {
            int randomPort = Networks.getRandomPort();
            Preconditions.checkState((randomPort > 0 ? 1 : 0) != 0, (Object)"Failed to get random port.");
            prop.setProperty("port", Integer.toString(randomPort));
        }
        return new KafkaConfig(prop);
    }
}

