/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.sql.Timestamp;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PVarbinary;

public class PUnsignedTimestamp
extends PTimestamp {
    public static final PUnsignedTimestamp INSTANCE = new PUnsignedTimestamp();

    private PUnsignedTimestamp() {
        super("UNSIGNED_TIMESTAMP", 20, 12);
    }

    @Override
    public boolean isBytesComparableWith(PDataType otherType) {
        return PUnsignedTimestamp.equalsAny(this, otherType, PVarbinary.INSTANCE, PBinary.INSTANCE, PUnsignedTime.INSTANCE, PUnsignedDate.INSTANCE, PUnsignedLong.INSTANCE);
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        Timestamp ts = (Timestamp)super.toObject(object, actualType);
        PUnsignedTimestamp.throwIfNonNegativeDate(ts);
        return ts;
    }

    @Override
    public boolean isCastableTo(PDataType targetType) {
        return PUnsignedDate.INSTANCE.isCastableTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return targetType.equals(this) || PUnsignedDate.INSTANCE.isCoercibleTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        return super.isCoercibleTo(targetType, value) || PTimestamp.INSTANCE.isCoercibleTo(targetType, value);
    }

    @Override
    public int getResultSetSqlType() {
        return PTimestamp.INSTANCE.getResultSetSqlType();
    }

    @Override
    public int getNanos(ImmutableBytesWritable ptr, SortOrder sortOrder) {
        int nanos = PUnsignedInt.INSTANCE.getCodec().decodeInt(ptr.get(), ptr.getOffset() + PLong.INSTANCE.getByteSize(), sortOrder);
        return nanos;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return new Timestamp((Long)PUnsignedLong.INSTANCE.getSampleValue(maxLength, arrayLength));
    }
}

