/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;

public abstract class PBinaryBase
extends PDataType<byte[]> {
    protected PBinaryBase(String sqlTypeName, int sqlType, Class clazz, PDataType.PDataCodec codec, int ordinal) {
        super(sqlTypeName, sqlType, clazz, codec, ordinal);
    }

    public void getByte(ImmutableBytesWritable ptr, SortOrder sortOrder, int offset, ImmutableBytesWritable outPtr) {
        this.getByte(ptr.get(), ptr.getOffset(), ptr.getLength(), sortOrder, offset, outPtr);
    }

    public void getByte(byte[] bytes, int offset, int length, SortOrder sortOrder, int off, ImmutableBytesWritable outPtr) {
        byte ret = bytes[offset + off];
        if (sortOrder == SortOrder.DESC) {
            ret = SortOrder.invert(ret);
        }
        outPtr.set(PInteger.INSTANCE.toBytes(ret));
    }

    public void setByte(ImmutableBytesWritable ptr, SortOrder sortOrder, int offset, byte newValue, ImmutableBytesWritable outPtr) {
        this.setByte(ptr.get(), ptr.getOffset(), ptr.getLength(), sortOrder, offset, newValue, outPtr);
    }

    public void setByte(byte[] bytes, int offset, int length, SortOrder sortOrder, int off, byte newValue, ImmutableBytesWritable outPtr) {
        byte[] ret;
        if (sortOrder == SortOrder.ASC) {
            ret = new byte[length];
            System.arraycopy(bytes, offset, ret, 0, length);
        } else {
            ret = SortOrder.invert(bytes, offset, length);
        }
        ret[off] = newValue;
        outPtr.set(ret);
    }

    public void getBit(ImmutableBytesWritable ptr, SortOrder sortOrder, int offset, ImmutableBytesWritable outPtr) {
        this.getBit(ptr.get(), ptr.getOffset(), ptr.getLength(), sortOrder, offset, outPtr);
    }

    public void getBit(byte[] bytes, int offset, int length, SortOrder sortOrder, int off, ImmutableBytesWritable outPtr) {
        byte ret = bytes[offset + off / 8];
        if (sortOrder == SortOrder.DESC) {
            ret = SortOrder.invert(ret);
        }
        ret = (ret = (byte)(ret & 1 << off % 8)) != 0 ? (byte)1 : 0;
        outPtr.set(PInteger.INSTANCE.toBytes(ret));
    }

    public void setBit(ImmutableBytesWritable ptr, SortOrder sortOrder, int offset, byte newValue, ImmutableBytesWritable outPtr) {
        this.setBit(ptr.get(), ptr.getOffset(), ptr.getLength(), sortOrder, offset, newValue, outPtr);
    }

    public void setBit(byte[] bytes, int offset, int length, SortOrder sortOrder, int off, byte newValue, ImmutableBytesWritable outPtr) {
        byte ret = bytes[offset + off / 8];
        if (sortOrder == SortOrder.DESC) {
            ret = SortOrder.invert(ret);
        }
        ret = (byte)(ret & ~(1 << off % 8) | newValue << off % 8);
        this.setByte(bytes, offset, length, sortOrder, off / 8, ret, outPtr);
    }

    public void octetLength(ImmutableBytesWritable ptr, SortOrder sortOrder, ImmutableBytesWritable outPtr) {
        this.octetLength(ptr.get(), ptr.getOffset(), ptr.getLength(), sortOrder, outPtr);
    }

    public void octetLength(byte[] bytes, int offset, int length, SortOrder sortOrder, ImmutableBytesWritable outPtr) {
        bytes = new byte[PInteger.INSTANCE.getByteSize().intValue()];
        PInteger.INSTANCE.getCodec().encodeInt(length, bytes, 0);
        outPtr.set(bytes);
    }

    @Override
    public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, SortOrder sortOrder, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
        if (ptr.getLength() != 0 && desiredMaxLength != null) {
            if (maxLength == null) {
                if (value != null && srcType instanceof PBinaryBase) {
                    maxLength = ((byte[])value).length;
                } else {
                    this.coerceBytes(ptr, value, srcType, maxLength, scale, sortOrder, desiredMaxLength, desiredScale, sortOrder, true);
                    maxLength = ptr.getLength();
                }
            }
            return maxLength <= desiredMaxLength;
        }
        return true;
    }
}

