/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.SchemaNotFoundException;
import org.apache.phoenix.schema.TableNotFoundException;

public class PSynchronizedMetaData
implements PMetaData {
    @GuardedBy(value="readWriteLock")
    private PMetaData delegate;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public PSynchronizedMetaData(PMetaData metadata) {
        this.delegate = metadata;
    }

    @Override
    public Iterator<PTable> iterator() {
        this.readWriteLock.readLock().lock();
        try {
            Iterator<PTable> iterator = this.delegate.iterator();
            return iterator;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public int size() {
        this.readWriteLock.readLock().lock();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public PMetaData clone() {
        this.readWriteLock.readLock().lock();
        try {
            PMetaData pMetaData = this.delegate.clone();
            return pMetaData;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTable(PTable table, long resolvedTime) throws SQLException {
        this.readWriteLock.writeLock().lock();
        try {
            this.delegate.addTable(table, resolvedTime);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public PTableRef getTableRef(PTableKey key) throws TableNotFoundException {
        this.readWriteLock.readLock().lock();
        try {
            PTableRef pTableRef = this.delegate.getTableRef(key);
            return pTableRef;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateResolvedTimestamp(PTable table, long resolvedTimestamp) throws SQLException {
        this.readWriteLock.writeLock().lock();
        try {
            this.delegate.updateResolvedTimestamp(table, resolvedTimestamp);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void pruneTables(PMetaData.Pruner pruner) {
        this.readWriteLock.writeLock().lock();
        try {
            this.delegate.pruneTables(pruner);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public PFunction getFunction(PTableKey key) throws FunctionNotFoundException {
        this.readWriteLock.readLock().lock();
        try {
            PFunction pFunction = this.delegate.getFunction(key);
            return pFunction;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTable(PName tenantId, String tableName, String parentTableName, long tableTimeStamp) throws SQLException {
        this.readWriteLock.writeLock().lock();
        try {
            this.delegate.removeTable(tenantId, tableName, parentTableName, tableTimeStamp);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void pruneFunctions(PMetaData.Pruner pruner) {
        this.readWriteLock.writeLock().lock();
        try {
            this.delegate.pruneFunctions(pruner);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAge(PTableRef ref) {
        this.readWriteLock.readLock().lock();
        try {
            long l = this.delegate.getAge(ref);
            return l;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public PSchema getSchema(PTableKey key) throws SchemaNotFoundException {
        this.readWriteLock.readLock().lock();
        try {
            PSchema pSchema = this.delegate.getSchema(key);
            return pSchema;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeColumn(PName tenantId, String tableName, List<PColumn> columnsToRemove, long tableTimeStamp, long tableSeqNum, long resolvedTime) throws SQLException {
        this.readWriteLock.writeLock().lock();
        try {
            this.delegate.removeColumn(tenantId, tableName, columnsToRemove, tableTimeStamp, tableSeqNum, resolvedTime);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void addFunction(PFunction function) throws SQLException {
        this.readWriteLock.writeLock().lock();
        try {
            this.delegate.addFunction(function);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFunction(PName tenantId, String function, long functionTimeStamp) throws SQLException {
        this.readWriteLock.writeLock().lock();
        try {
            this.delegate.removeFunction(tenantId, function, functionTimeStamp);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void addSchema(PSchema schema) throws SQLException {
        this.readWriteLock.writeLock().lock();
        try {
            this.delegate.addSchema(schema);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSchema(PSchema schema, long schemaTimeStamp) {
        this.readWriteLock.writeLock().lock();
        try {
            this.delegate.removeSchema(schema, schemaTimeStamp);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

