/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.SizedUtil;

public class PColumnFamilyImpl
implements PColumnFamily {
    private final PName name;
    private final List<PColumn> columns;
    private final Map<String, PColumn> columnNamesByStrings;
    private final Map<byte[], PColumn> columnNamesByBytes;
    private final Map<byte[], PColumn> columnsByQualifiers;
    private final int estimatedSize;

    @Override
    public int getEstimatedSize() {
        return this.estimatedSize;
    }

    public PColumnFamilyImpl(PName name, List<PColumn> columns) {
        Preconditions.checkNotNull((Object)name);
        long estimatedSize = (long)(60 + name.getEstimatedSize()) + SizedUtil.sizeOfMap(columns.size()) * 2L + (long)SizedUtil.sizeOfArrayList(columns.size());
        this.name = name;
        this.columns = ImmutableList.copyOf(columns);
        ImmutableMap.Builder columnNamesByStringBuilder = ImmutableMap.builder();
        ImmutableSortedMap.Builder columnNamesByBytesBuilder = ImmutableSortedMap.orderedBy((Comparator)Bytes.BYTES_COMPARATOR);
        ImmutableSortedMap.Builder columnsByQualifiersBuilder = ImmutableSortedMap.orderedBy((Comparator)Bytes.BYTES_COMPARATOR);
        for (PColumn column : columns) {
            estimatedSize += (long)column.getEstimatedSize();
            columnNamesByBytesBuilder.put((Object)column.getName().getBytes(), (Object)column);
            columnNamesByStringBuilder.put((Object)column.getName().getString(), (Object)column);
            if (SchemaUtil.isPKColumn(column) || column.getColumnQualifierBytes() == null) continue;
            columnsByQualifiersBuilder.put((Object)column.getColumnQualifierBytes(), (Object)column);
        }
        this.columnNamesByBytes = columnNamesByBytesBuilder.build();
        this.columnNamesByStrings = columnNamesByStringBuilder.build();
        this.columnsByQualifiers = columnsByQualifiersBuilder.build();
        this.estimatedSize = (int)estimatedSize;
    }

    @Override
    public PName getName() {
        return this.name;
    }

    public List<PColumn> getColumns() {
        return this.columns;
    }

    @Override
    public PColumn getPColumnForColumnNameBytes(byte[] columnNameBytes) throws ColumnNotFoundException {
        PColumn column = this.columnNamesByBytes.get(columnNameBytes);
        if (column == null) {
            throw new ColumnNotFoundException(Bytes.toString((byte[])columnNameBytes));
        }
        return column;
    }

    @Override
    public PColumn getPColumnForColumnName(String columnName) throws ColumnNotFoundException {
        PColumn column = this.columnNamesByStrings.get(columnName);
        if (column == null) {
            throw new ColumnNotFoundException(columnName);
        }
        return column;
    }

    @Override
    public PColumn getPColumnForColumnQualifier(byte[] cq) throws ColumnNotFoundException {
        Preconditions.checkNotNull((Object)cq);
        return this.columnsByQualifiers.get(cq);
    }
}

