/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.sql.SQLException;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDataTypeFactory;

public class ArgumentTypeMismatchException
extends SQLException {
    private static final long serialVersionUID = 1L;
    private static SQLExceptionCode code = SQLExceptionCode.TYPE_MISMATCH;

    public ArgumentTypeMismatchException(PDataType expected, PDataType actual, String location) {
        super(new SQLExceptionInfo.Builder(code).setMessage("expected: " + expected + " but was: " + actual + " at " + location).build().toString(), code.getSQLState(), code.getErrorCode());
    }

    public ArgumentTypeMismatchException(Class<? extends PDataType>[] expecteds, PDataType actual, String location) {
        this(Arrays.toString(Collections2.transform(Arrays.asList(expecteds), (Function)new Function<Class<? extends PDataType>, PDataType>(){

            @Nullable
            public PDataType apply(@Nullable Class<? extends PDataType> input) {
                return PDataTypeFactory.getInstance().instanceFromClass(input);
            }
        }).toArray()), actual.toString(), location);
    }

    public ArgumentTypeMismatchException(String expected, String actual, String location) {
        super(new SQLExceptionInfo.Builder(code).setMessage("expected: " + expected + " but was: " + actual + " at " + location).build().toString(), code.getSQLState(), code.getErrorCode());
    }
}

