/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.NamedParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.SchemaUtil;

public class ColumnParseNode
extends NamedParseNode {
    private final TableName tableName;
    private final String fullName;
    private final String alias;

    public ColumnParseNode(TableName tableName, String name, String alias) {
        super(name);
        this.alias = alias;
        this.tableName = tableName;
        this.fullName = tableName == null ? this.getName() : tableName.toString() + "." + this.getName();
    }

    public ColumnParseNode(TableName tableName, String name) {
        this(tableName, name, null);
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        return visitor.visit(this);
    }

    public String getTableName() {
        return this.tableName == null ? null : this.tableName.getTableName();
    }

    public String getSchemaName() {
        return this.tableName == null ? null : this.tableName.getSchemaName();
    }

    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public int hashCode() {
        return this.fullName.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnParseNode other = (ColumnParseNode)obj;
        return this.fullName.equals(other.fullName);
    }

    public boolean isTableNameCaseSensitive() {
        return this.tableName == null ? false : this.tableName.isTableNameCaseSensitive();
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        String tableName = null;
        if (resolver == null) {
            if (this.tableName != null) {
                tableName = this.tableName.getTableName();
            }
        } else {
            try {
                ColumnRef ref = resolver.resolveColumn(this.getSchemaName(), this.getTableName(), this.getName());
                PColumn column = ref.getColumn();
                if (!SchemaUtil.isPKColumn(column)) {
                    PTable table = ref.getTable();
                    String defaultFamilyName = table.getDefaultFamilyName() == null ? "0" : table.getDefaultFamilyName().getString();
                    String dataFamilyName = column.getFamilyName().getString();
                    tableName = defaultFamilyName.equals(dataFamilyName) ? null : dataFamilyName;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (tableName != null) {
            if (this.isTableNameCaseSensitive()) {
                buf.append('\"');
                buf.append(tableName);
                buf.append('\"');
            } else {
                buf.append(tableName);
            }
            buf.append('.');
        }
        this.toSQL(buf);
    }
}

