/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;
import org.apache.phoenix.parse.UnaryParseNode;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.SchemaUtil;

public class CastParseNode
extends UnaryParseNode {
    private final PDataType dt;
    private final Integer maxLength;
    private final Integer scale;

    CastParseNode(ParseNode expr, String dataType, Integer maxLength, Integer scale, boolean arr) {
        this(expr, PDataType.fromSqlTypeName(SchemaUtil.normalizeIdentifier(dataType)), maxLength, scale, arr);
    }

    CastParseNode(ParseNode expr, PDataType dataType, Integer maxLength, Integer scale, boolean arr) {
        super(expr);
        this.dt = arr ? PDataType.fromTypeId(dataType.getSqlType() + 3000) : dataType;
        this.maxLength = maxLength;
        this.scale = scale;
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        List l = Collections.emptyList();
        if (visitor.visitEnter(this)) {
            l = this.acceptChildren(visitor);
        }
        return visitor.visitLeave(this, l);
    }

    public PDataType getDataType() {
        return this.dt;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getScale() {
        return this.scale;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dt == null ? 0 : this.dt.hashCode());
        result = 31 * result + (this.maxLength == null ? 0 : this.maxLength.hashCode());
        result = 31 * result + (this.scale == null ? 0 : this.scale.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CastParseNode other = (CastParseNode)obj;
        if (this.dt == null ? other.dt != null : !this.dt.equals(other.dt)) {
            return false;
        }
        if (this.maxLength == null ? other.maxLength != null : !this.maxLength.equals(other.maxLength)) {
            return false;
        }
        return !(this.scale == null ? other.scale != null : !this.scale.equals(other.scale));
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        List<ParseNode> children = this.getChildren();
        buf.append(" CAST(");
        children.get(0).toSQL(resolver, buf);
        buf.append(" AS ");
        boolean isArray = this.dt.isArrayType();
        PDataType type = isArray ? PDataType.arrayBaseType(this.dt) : this.dt;
        buf.append(type.getSqlTypeName());
        if (this.maxLength != null) {
            buf.append('(');
            buf.append(this.maxLength);
            if (this.scale != null) {
                buf.append(',');
                buf.append(this.scale);
            }
            buf.append(')');
        }
        if (isArray) {
            buf.append(' ');
            buf.append("ARRAY");
        }
        buf.append(")");
    }
}

