/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.data;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.regionserver.IndexKeyValueSkipListSet;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.covered.KeyValueStore;
import org.apache.phoenix.hbase.index.scanner.ReseekableScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexMemStore
implements KeyValueStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexMemStore.class);
    private IndexKeyValueSkipListSet kvset;
    private Comparator<KeyValue> comparator;
    public static final Comparator<KeyValue> COMPARATOR = new Comparator<KeyValue>(){
        private final KeyValue.KVComparator rawcomparator = new KeyValue.KVComparator();

        @Override
        public int compare(KeyValue left, KeyValue right) {
            return this.rawcomparator.compareFlatKey(left.getRowArray(), left.getOffset() + 8, left.getKeyLength(), right.getRowArray(), right.getOffset() + 8, right.getKeyLength());
        }
    };

    public IndexMemStore() {
        this(COMPARATOR);
    }

    IndexMemStore(Comparator<KeyValue> comparator) {
        this.comparator = comparator;
        this.kvset = IndexKeyValueSkipListSet.create(comparator);
    }

    @Override
    public void add(KeyValue kv, boolean overwrite) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Inserting: " + this.toString(kv));
        }
        if (!overwrite) {
            this.kvset.putIfAbsent(kv);
        } else {
            this.kvset.add(kv);
        }
        if (LOGGER.isTraceEnabled()) {
            this.dump();
        }
    }

    private void dump() {
        LOGGER.trace("Current kv state:\n");
        for (KeyValue kv : this.kvset) {
            LOGGER.trace("KV: " + this.toString(kv));
        }
        LOGGER.trace("========== END MemStore Dump ==================\n");
    }

    private String toString(KeyValue kv) {
        return kv.toString() + "/value=" + Bytes.toStringBinary((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength());
    }

    @Override
    public void rollback(KeyValue kv) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Rolling back: " + this.toString(kv));
        }
        this.kvset.remove(kv);
        if (LOGGER.isTraceEnabled()) {
            this.dump();
        }
    }

    @Override
    public ReseekableScanner getScanner() {
        return new MemStoreScanner();
    }

    protected class MemStoreScanner
    implements ReseekableScanner {
        private KeyValue nextRow = null;
        private KeyValue kvsetItRow = null;
        private Iterator<KeyValue> kvsetIt;
        volatile IndexKeyValueSkipListSet kvsetAtCreation;

        MemStoreScanner() {
            this.kvsetAtCreation = IndexMemStore.this.kvset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KeyValue getNext(Iterator<KeyValue> it) {
            KeyValue v = null;
            try {
                if (it.hasNext()) {
                    KeyValue keyValue = v = it.next();
                    return keyValue;
                }
                KeyValue keyValue = null;
                return keyValue;
            }
            finally {
                if (v != null) {
                    this.kvsetItRow = v;
                }
            }
        }

        @Override
        public synchronized boolean seek(Cell key) {
            if (key == null) {
                this.close();
                return false;
            }
            this.kvsetIt = this.kvsetAtCreation.tailSet(KeyValueUtil.ensureKeyValue((Cell)key)).iterator();
            this.kvsetItRow = null;
            return this.seekInSubLists();
        }

        private synchronized boolean seekInSubLists() {
            this.nextRow = this.getNext(this.kvsetIt);
            return this.nextRow != null;
        }

        @Override
        public synchronized boolean reseek(Cell key) {
            this.kvsetIt = this.kvsetAtCreation.tailSet(this.getHighest(KeyValueUtil.ensureKeyValue((Cell)key), this.kvsetItRow)).iterator();
            return this.seekInSubLists();
        }

        private KeyValue getHighest(KeyValue first, KeyValue second) {
            if (first == null && second == null) {
                return null;
            }
            if (first != null && second != null) {
                int compare = IndexMemStore.this.comparator.compare(first, second);
                return compare > 0 ? first : second;
            }
            return first != null ? first : second;
        }

        @Override
        public synchronized Cell peek() {
            return this.nextRow;
        }

        @Override
        public synchronized Cell next() {
            if (this.nextRow == null) {
                return null;
            }
            KeyValue ret = this.nextRow;
            this.nextRow = this.getNext(this.kvsetIt);
            return ret;
        }

        @Override
        public synchronized void close() {
            this.nextRow = null;
            this.kvsetIt = null;
            this.kvsetItRow = null;
        }
    }
}

