/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.BaseTerminalExpression;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.StringUtil;

public class LiteralExpression
extends BaseTerminalExpression {
    private static final LiteralExpression[] NULL_EXPRESSIONS = new LiteralExpression[Determinism.values().length];
    private static final LiteralExpression[] TYPED_NULL_EXPRESSIONS = new LiteralExpression[PDataType.values().length * Determinism.values().length];
    private static final LiteralExpression[] BOOLEAN_EXPRESSIONS = new LiteralExpression[2 * Determinism.values().length];
    private Object value;
    private PDataType type;
    private Determinism determinism;
    private byte[] byteValue;
    private Integer maxLength;
    private Integer scale;
    private SortOrder sortOrder;

    private static LiteralExpression getNullLiteralExpression(Determinism determinism) {
        return NULL_EXPRESSIONS[determinism.ordinal()];
    }

    private static LiteralExpression getTypedNullLiteralExpression(PDataType type, Determinism determinism) {
        return TYPED_NULL_EXPRESSIONS[type.ordinal() + PDataType.values().length * determinism.ordinal()];
    }

    private static LiteralExpression getBooleanLiteralExpression(Boolean bool, Determinism determinism) {
        return BOOLEAN_EXPRESSIONS[(Boolean.FALSE.equals(bool) ? 0 : Determinism.values().length) + determinism.ordinal()];
    }

    public static boolean isFalse(Expression child) {
        if (child != null) {
            return child == BOOLEAN_EXPRESSIONS[child.getDeterminism().ordinal()];
        }
        return false;
    }

    public static boolean isTrue(Expression child) {
        if (child != null) {
            return child == BOOLEAN_EXPRESSIONS[Determinism.values().length + child.getDeterminism().ordinal()];
        }
        return false;
    }

    public static boolean isBooleanNull(Expression child) {
        if (child != null) {
            return child == TYPED_NULL_EXPRESSIONS[PBoolean.INSTANCE.ordinal() + PDataType.values().length * child.getDeterminism().ordinal()];
        }
        return false;
    }

    public static boolean isBooleanFalseOrNull(Expression child) {
        if (child != null) {
            return child == BOOLEAN_EXPRESSIONS[child.getDeterminism().ordinal()] || child == TYPED_NULL_EXPRESSIONS[PBoolean.INSTANCE.ordinal() + PDataType.values().length * child.getDeterminism().ordinal()];
        }
        return false;
    }

    public static LiteralExpression newConstant(Object value) {
        return LiteralExpression.newConstant(value, Determinism.ALWAYS);
    }

    public static LiteralExpression newConstant(Object value, Determinism determinism) {
        String s;
        byte[] b;
        if (value instanceof Boolean) {
            return LiteralExpression.getBooleanLiteralExpression((Boolean)value, determinism);
        }
        if (value == null) {
            return LiteralExpression.getNullLiteralExpression(determinism);
        }
        PDataType type = PDataType.fromLiteral(value);
        if (type.isNull(b = type.toBytes(value))) {
            return LiteralExpression.getTypedNullLiteralExpression(type, determinism);
        }
        if (type == PVarchar.INSTANCE && (s = (String)value).length() == b.length) {
            type = PChar.INSTANCE;
        }
        return new LiteralExpression(value, type, b, determinism);
    }

    public static LiteralExpression newConstant(Object value, PDataType type) throws SQLException {
        return LiteralExpression.newConstant(value, type, Determinism.ALWAYS);
    }

    public static LiteralExpression newConstant(Object value, PDataType type, Determinism determinism) throws SQLException {
        return LiteralExpression.newConstant(value, type, SortOrder.getDefault(), determinism);
    }

    public static LiteralExpression newConstant(Object value, PDataType type, SortOrder sortOrder) throws SQLException {
        return LiteralExpression.newConstant(value, type, null, null, sortOrder, Determinism.ALWAYS);
    }

    public static LiteralExpression newConstant(Object value, PDataType type, SortOrder sortOrder, Determinism determinism) throws SQLException {
        return LiteralExpression.newConstant(value, type, null, null, sortOrder, determinism);
    }

    public static LiteralExpression newConstant(Object value, PDataType type, Integer maxLength, Integer scale) throws SQLException {
        return LiteralExpression.newConstant(value, type, maxLength, scale, SortOrder.getDefault(), Determinism.ALWAYS);
    }

    public static LiteralExpression newConstant(Object value, PDataType type, Integer maxLength, Integer scale, Determinism determinism) throws SQLException {
        return LiteralExpression.newConstant(value, type, maxLength, scale, SortOrder.getDefault(), determinism);
    }

    public static LiteralExpression newConstant(Object value, PDataType type, Integer maxLength, Integer scale, SortOrder sortOrder, Determinism determinism) throws SQLException {
        return LiteralExpression.newConstant(value, type, maxLength, scale, sortOrder, determinism, true);
    }

    public static LiteralExpression newConstant(Object value, PDataType type, Integer maxLength, Integer scale, SortOrder sortOrder, Determinism determinism, boolean rowKeyOrderOptimizable) throws SQLException {
        byte[] b;
        if (value == null) {
            return type == null ? LiteralExpression.getNullLiteralExpression(determinism) : LiteralExpression.getTypedNullLiteralExpression(type, determinism);
        }
        if (value instanceof Boolean) {
            return LiteralExpression.getBooleanLiteralExpression((Boolean)value, determinism);
        }
        PDataType actualType = PDataType.fromLiteral(value);
        type = type == null ? actualType : type;
        try {
            value = type.toObject(value, actualType);
        }
        catch (IllegalDataException e) {
            throw TypeMismatchException.newException(type, actualType, value.toString());
        }
        byte[] byArray = b = type.isArrayType() ? ((PArrayDataType)type).toBytes(value, PArrayDataType.arrayBaseType(type), sortOrder, rowKeyOrderOptimizable) : type.toBytes(value, sortOrder);
        if (type == PVarchar.INSTANCE || type == PChar.INSTANCE) {
            if (type == PChar.INSTANCE && maxLength != null && b.length < maxLength) {
                b = rowKeyOrderOptimizable ? type.pad(b, maxLength, sortOrder) : StringUtil.padChar(b, maxLength);
            } else if (value != null) {
                maxLength = ((String)value).length();
            }
        } else if (type.isArrayType()) {
            maxLength = ((PhoenixArray)value).getMaxLength();
        }
        if (b.length == 0) {
            return LiteralExpression.getTypedNullLiteralExpression(type, determinism);
        }
        if (maxLength == null) {
            maxLength = type.isFixedWidth() ? type.getMaxLength(value) : null;
        }
        return new LiteralExpression(value, type, b, maxLength, scale, sortOrder, determinism);
    }

    public LiteralExpression() {
    }

    public LiteralExpression(byte[] byteValue) {
        this.byteValue = byteValue != null ? byteValue : ByteUtil.EMPTY_BYTE_ARRAY;
        this.determinism = Determinism.ALWAYS;
    }

    private LiteralExpression(PDataType type, Determinism determinism) {
        this(null, type, ByteUtil.EMPTY_BYTE_ARRAY, determinism);
    }

    private LiteralExpression(Object value, PDataType type, byte[] byteValue, Determinism determinism) {
        this(value, type, byteValue, type == null || !type.isFixedWidth() ? null : type.getMaxLength(value), null, SortOrder.getDefault(), determinism);
    }

    private LiteralExpression(Object value, PDataType type, byte[] byteValue, Integer maxLength, Integer scale, SortOrder sortOrder, Determinism deterministic) {
        Preconditions.checkNotNull((Object)((Object)sortOrder));
        this.value = value;
        this.type = type;
        this.byteValue = byteValue;
        this.maxLength = maxLength;
        this.scale = scale != null ? scale : (type == null ? null : type.getScale(value));
        this.sortOrder = sortOrder;
        this.determinism = deterministic;
    }

    @Override
    public Determinism getDeterminism() {
        return this.determinism;
    }

    public String toString() {
        if (this.value == null && this.byteValue != null) {
            return Bytes.toStringBinary((byte[])this.byteValue);
        }
        if (this.value == null) {
            return "null";
        }
        if (this.type.isCoercibleTo(PTimestamp.INSTANCE)) {
            return this.type + " " + this.type.toStringLiteral(this.value, null);
        }
        return this.type.toStringLiteral(this.value, null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LiteralExpression other = (LiteralExpression)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        int encodedByteLengthAndBool = WritableUtils.readVInt((DataInput)input);
        int byteLength = Math.abs(encodedByteLengthAndBool) - 1;
        this.byteValue = new byte[byteLength];
        input.readFully(this.byteValue, 0, byteLength);
        int sortOrderAndDeterminism = WritableUtils.readVInt((DataInput)input);
        if (sortOrderAndDeterminism <= 2) {
            this.determinism = encodedByteLengthAndBool > 0 ? Determinism.ALWAYS : Determinism.PER_ROW;
            this.sortOrder = SortOrder.fromSystemValue(sortOrderAndDeterminism);
        } else {
            int determinismOrdinal = (sortOrderAndDeterminism >> 2) - 1;
            this.determinism = Determinism.values()[determinismOrdinal];
            int sortOrderValue = sortOrderAndDeterminism & 3;
            this.sortOrder = SortOrder.fromSystemValue(sortOrderValue);
        }
        int typeOrdinal = WritableUtils.readVInt((DataInput)input);
        this.type = typeOrdinal < 0 ? null : PDataType.values()[typeOrdinal];
        this.value = this.byteValue.length == 0 ? null : this.type.toObject(this.byteValue, 0, this.byteValue.length, this.type, this.sortOrder);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        WritableUtils.writeVInt((DataOutput)output, (int)((this.byteValue.length + 1) * (this.determinism == Determinism.ALWAYS ? 1 : -1)));
        output.write(this.byteValue);
        int sortOrderAndDeterminism = (this.determinism.ordinal() + 1 << 2) + this.sortOrder.getSystemValue();
        WritableUtils.writeVInt((DataOutput)output, (int)sortOrderAndDeterminism);
        WritableUtils.writeVInt((DataOutput)output, (int)(this.type == null ? -1 : this.type.ordinal()));
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        ptr.set(this.byteValue);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return this.type;
    }

    @Override
    public Integer getMaxLength() {
        Object value;
        if (this.maxLength == null && this.getDataType() != null && this.getDataType().isArrayType() && PDataType.arrayBaseType(this.getDataType()).getByteSize() == null && (value = this.getValue()) instanceof PhoenixArray) {
            return ((PhoenixArray)value).getMaxLength();
        }
        return this.maxLength;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public boolean isNullable() {
        return this.value == null;
    }

    public Object getValue() {
        return this.value;
    }

    public byte[] getBytes() {
        return this.byteValue;
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isStateless() {
        return true;
    }

    static {
        for (Determinism determinism : Determinism.values()) {
            LiteralExpression.NULL_EXPRESSIONS[determinism.ordinal()] = new LiteralExpression(null, determinism);
            for (int i = 0; i < PDataType.values().length; ++i) {
                LiteralExpression.TYPED_NULL_EXPRESSIONS[i + PDataType.values().length * determinism.ordinal()] = new LiteralExpression(PDataType.values()[i], determinism);
            }
            LiteralExpression.BOOLEAN_EXPRESSIONS[determinism.ordinal()] = new LiteralExpression(Boolean.FALSE, PBoolean.INSTANCE, PBoolean.INSTANCE.toBytes(Boolean.FALSE), determinism);
            LiteralExpression.BOOLEAN_EXPRESSIONS[Determinism.values().length + determinism.ordinal()] = new LiteralExpression(Boolean.TRUE, PBoolean.INSTANCE, PBoolean.INSTANCE.toBytes(Boolean.TRUE), determinism);
        }
    }
}

