/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.SQLException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.DelegateQueryPlan;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.iterate.CursorResultIterator;
import org.apache.phoenix.iterate.LookAheadResultIterator;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;

public class CursorFetchPlan
extends DelegateQueryPlan {
    private CursorResultIterator resultIterator;
    private int fetchSize;
    private boolean isAggregate;
    private String cursorName;

    public CursorFetchPlan(QueryPlan cursorQueryPlan, String cursorName) {
        super(cursorQueryPlan);
        this.isAggregate = this.delegate.getStatement().isAggregate() || this.delegate.getStatement().isDistinct();
        this.cursorName = cursorName;
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        StatementContext context = this.delegate.getContext();
        if (this.resultIterator == null) {
            context.getOverallQueryMetrics().startQuery();
            this.resultIterator = new CursorResultIterator(LookAheadResultIterator.wrap(this.delegate.iterator(scanGrouper, scan)), this.cursorName);
        }
        return this.resultIterator;
    }

    @Override
    public <T> T accept(QueryPlanVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        return this.delegate.getExplainPlan();
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }
}

