/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.SubselectRewriter;
import org.apache.phoenix.compile.TupleProjectionCompiler;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.AndBooleanParseNodeVisitor;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.AndRewriterBooleanParseNodeVisitor;
import org.apache.phoenix.parse.BindTableNode;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.ComparisonParseNode;
import org.apache.phoenix.parse.ConcreteTableNode;
import org.apache.phoenix.parse.DerivedTableNode;
import org.apache.phoenix.parse.EqualParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.StatelessTraverseAllParseNodeVisitor;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.parse.TableNodeVisitor;
import org.apache.phoenix.parse.TableWildcardParseNode;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.LocalIndexDataColumnRef;
import org.apache.phoenix.schema.MetaDataEntityNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ProjectedColumn;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ParseNodeUtil;
import org.apache.phoenix.util.SchemaUtil;

public class JoinCompiler {
    private final PhoenixStatement phoenixStatement;
    private final SelectStatement originalJoinSelectStatement;
    private final ColumnResolver origResolver;
    private final boolean useStarJoin;
    private final Map<ColumnRef, ColumnRefType> columnRefs;
    private final Map<ColumnRef, ColumnParseNode> columnNodes;
    private final boolean useSortMergeJoin;
    private static final ParseNodeFactory NODE_FACTORY = new ParseNodeFactory();

    private JoinCompiler(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver) {
        this.phoenixStatement = statement;
        this.originalJoinSelectStatement = select;
        this.origResolver = resolver;
        this.useStarJoin = !select.getHint().hasHint(HintNode.Hint.NO_STAR_JOIN);
        this.columnRefs = new HashMap<ColumnRef, ColumnRefType>();
        this.columnNodes = new HashMap<ColumnRef, ColumnParseNode>();
        this.useSortMergeJoin = select.getHint().hasHint(HintNode.Hint.USE_SORT_MERGE_JOIN);
    }

    public static JoinTable compile(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver) throws SQLException {
        JoinTable joinTable;
        JoinTable joinTable2;
        JoinCompiler compiler;
        JoinCompiler joinCompiler = compiler = new JoinCompiler(statement, select, resolver);
        joinCompiler.getClass();
        JoinTableConstructor constructor = joinCompiler.new JoinTableConstructor();
        Pair<Table, List<JoinSpec>> res = select.getFrom().accept(constructor);
        if (res.getSecond() == null) {
            JoinCompiler joinCompiler2 = compiler;
            joinCompiler2.getClass();
            joinTable2 = joinCompiler2.new JoinTable((Table)res.getFirst());
        } else {
            JoinCompiler joinCompiler3 = compiler;
            joinCompiler3.getClass();
            joinTable2 = joinTable = joinCompiler3.new JoinTable((Table)res.getFirst(), (List)res.getSecond());
        }
        if (select.getWhere() != null) {
            joinTable.pushDownFilter(select.getWhere());
        }
        ColumnRefParseNodeVisitor generalRefVisitor = new ColumnRefParseNodeVisitor(resolver, statement.getConnection());
        ColumnRefParseNodeVisitor joinLocalRefVisitor = new ColumnRefParseNodeVisitor(resolver, statement.getConnection());
        joinTable.pushDownColumnRefVisitors(generalRefVisitor, joinLocalRefVisitor);
        ParseNodeUtil.applyParseNodeVisitor(select, generalRefVisitor, false);
        compiler.columnNodes.putAll(joinLocalRefVisitor.getColumnRefMap());
        compiler.columnNodes.putAll(generalRefVisitor.getColumnRefMap());
        for (ColumnRef ref : generalRefVisitor.getColumnRefMap().keySet()) {
            compiler.columnRefs.put(ref, ColumnRefType.GENERAL);
        }
        for (ColumnRef ref : joinLocalRefVisitor.getColumnRefMap().keySet()) {
            if (compiler.columnRefs.containsKey(ref)) continue;
            compiler.columnRefs.put(ref, ColumnRefType.JOINLOCAL);
        }
        joinTable.pruneSubselectAliasedNodes();
        return joinTable;
    }

    private static boolean isCouldPushToServerAsHashJoinProbeSide(SelectStatement selectStatement) {
        return !selectStatement.isJoin() && !selectStatement.isAggregate() && !selectStatement.isDistinct() && !(selectStatement.getFrom() instanceof DerivedTableNode) && selectStatement.getLimit() == null && selectStatement.getOffset() == null;
    }

    private static ParseNode combine(List<ParseNode> nodes) {
        if (nodes.isEmpty()) {
            return null;
        }
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        return NODE_FACTORY.and(nodes);
    }

    private boolean isWildCardSelectForTable(List<AliasedNode> select, TableRef tableRef, ColumnResolver resolver) throws SQLException {
        ColumnRefParseNodeVisitor visitor = new ColumnRefParseNodeVisitor(resolver, this.phoenixStatement.getConnection());
        for (AliasedNode aliasedNode : select) {
            TableName tableName;
            ParseNode node = aliasedNode.getNode();
            if (!(node instanceof TableWildcardParseNode) || !tableRef.equals(resolver.resolveTable((tableName = ((TableWildcardParseNode)node).getTableName()).getSchemaName(), tableName.getTableName()))) continue;
            return true;
        }
        return false;
    }

    private static Expression compilePostFilterExpression(StatementContext context, List<ParseNode> postFilters) throws SQLException {
        if (postFilters.isEmpty()) {
            return null;
        }
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(context);
        ArrayList<Expression> expressions = new ArrayList<Expression>(postFilters.size());
        for (ParseNode postFilter : postFilters) {
            expressionCompiler.reset();
            Expression expression = postFilter.accept(expressionCompiler);
            expressions.add(expression);
        }
        if (expressions.size() == 1) {
            return (Expression)expressions.get(0);
        }
        return AndExpression.create(expressions);
    }

    public static PTable joinProjectedTables(PTable left, PTable right, JoinTableNode.JoinType type) throws SQLException {
        Preconditions.checkArgument((left.getType() == PTableType.PROJECTED ? 1 : 0) != 0);
        Preconditions.checkArgument((right.getType() == PTableType.PROJECTED ? 1 : 0) != 0);
        ArrayList merged = Lists.newArrayList();
        if (type == JoinTableNode.JoinType.Full) {
            for (PColumn c : left.getColumns()) {
                merged.add(new ProjectedColumn(c.getName(), c.getFamilyName(), c.getPosition(), true, ((ProjectedColumn)c).getSourceColumnRef(), SchemaUtil.isPKColumn(c) ? null : c.getName().getBytes()));
            }
        } else {
            merged.addAll(left.getColumns());
        }
        int position = merged.size();
        for (PColumn c : right.getColumns()) {
            if (SchemaUtil.isPKColumn(c)) continue;
            ProjectedColumn column = new ProjectedColumn(c.getName(), c.getFamilyName(), position++, type == JoinTableNode.JoinType.Inner ? c.isNullable() : true, ((ProjectedColumn)c).getSourceColumnRef(), c.getName().getBytes());
            merged.add(column);
        }
        if (left.getBucketNum() != null) {
            merged.remove(0);
        }
        return new PTableImpl.Builder().setType(left.getType()).setState(left.getIndexState()).setTimeStamp(left.getTimeStamp()).setIndexDisableTimestamp(left.getIndexDisableTimestamp()).setSequenceNumber(left.getSequenceNumber()).setImmutableRows(left.isImmutableRows()).setDisableWAL(false).setMultiTenant(left.isMultiTenant()).setStoreNulls(left.getStoreNulls()).setViewType(left.getViewType()).setViewIndexIdType(left.getviewIndexIdType()).setViewIndexId(left.getViewIndexId()).setIndexType(left.getIndexType()).setTransactionProvider(left.getTransactionProvider()).setUpdateCacheFrequency(left.getUpdateCacheFrequency()).setNamespaceMapped(left.isNamespaceMapped()).setAutoPartitionSeqName(left.getAutoPartitionSeqName()).setAppendOnlySchema(left.isAppendOnlySchema()).setImmutableStorageScheme(PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN).setQualifierEncodingScheme(PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS).setBaseColumnCount(-1).setEncodedCQCounter(PTable.EncodedCQCounter.NULL_COUNTER).setUseStatsForParallelization(left.useStatsForParallelization()).setExcludedColumns((List<PColumn>)ImmutableList.of()).setTenantId(left.getTenantId()).setSchemaName(left.getSchemaName()).setTableName(PNameFactory.newName(SchemaUtil.getTableName(left.getName().getString(), right.getName().getString()))).setPkName(left.getPKName()).setRowKeyOrderOptimizable(left.rowKeyOrderOptimizable()).setBucketNum(left.getBucketNum()).setIndexes(left.getIndexes() == null ? Collections.emptyList() : left.getIndexes()).setParentSchemaName(left.getParentSchemaName()).setParentTableName(left.getParentTableName()).setPhysicalNames((List<PName>)ImmutableList.of()).setColumns(merged).build();
    }

    private static class ColumnRefParseNodeVisitor
    extends StatelessTraverseAllParseNodeVisitor {
        private final ColumnResolver resolver;
        private final PhoenixConnection connection;
        private final Set<TableRef> tableRefSet;
        private final Map<ColumnRef, ColumnParseNode> columnRefMap;

        public ColumnRefParseNodeVisitor(ColumnResolver resolver, PhoenixConnection connection) {
            this.resolver = resolver;
            this.tableRefSet = new HashSet<TableRef>();
            this.columnRefMap = new HashMap<ColumnRef, ColumnParseNode>();
            this.connection = connection;
        }

        public void reset() {
            this.tableRefSet.clear();
            this.columnRefMap.clear();
        }

        @Override
        public Void visit(ColumnParseNode node) throws SQLException {
            ColumnRef columnRef = null;
            try {
                columnRef = this.resolver.resolveColumn(node.getSchemaName(), node.getTableName(), node.getName());
            }
            catch (ColumnNotFoundException e) {
                TableRef tableRef = this.resolver.resolveTable(node.getSchemaName(), node.getTableName());
                if (tableRef.getTable().getIndexType() == PTable.IndexType.LOCAL) {
                    TableRef parentTableRef = FromCompiler.getResolver(NODE_FACTORY.namedTable(null, TableName.create(tableRef.getTable().getSchemaName().getString(), tableRef.getTable().getParentTableName().getString())), this.connection).resolveTable(tableRef.getTable().getSchemaName().getString(), tableRef.getTable().getParentTableName().getString());
                    columnRef = new LocalIndexColumnRef(parentTableRef, IndexUtil.getDataColumnFamilyName(node.getName()), IndexUtil.getDataColumnName(node.getName()), tableRef);
                }
                throw e;
            }
            this.columnRefMap.put(columnRef, node);
            this.tableRefSet.add(columnRef.getTableRef());
            return null;
        }

        public Set<TableRef> getTableRefSet() {
            return this.tableRefSet;
        }

        public Map<ColumnRef, ColumnParseNode> getColumnRefMap() {
            return this.columnRefMap;
        }

        public ColumnRefType getContentType(List<TableRef> selfTableRefs) {
            if (this.tableRefSet.isEmpty()) {
                return ColumnRefType.NONE;
            }
            ColumnRefType ret = ColumnRefType.NONE;
            for (TableRef tRef : this.tableRefSet) {
                boolean isSelf = selfTableRefs.contains(tRef);
                switch (ret) {
                    case NONE: {
                        ret = isSelf ? ColumnRefType.SELF_ONLY : ColumnRefType.FOREIGN_ONLY;
                        break;
                    }
                    case SELF_ONLY: {
                        ret = isSelf ? ColumnRefType.SELF_ONLY : ColumnRefType.COMPLEX;
                        break;
                    }
                    case FOREIGN_ONLY: {
                        ret = isSelf ? ColumnRefType.COMPLEX : ColumnRefType.FOREIGN_ONLY;
                        break;
                    }
                }
                if (ret != ColumnRefType.COMPLEX) continue;
                break;
            }
            return ret;
        }

        public static enum ColumnRefType {
            NONE,
            SELF_ONLY,
            FOREIGN_ONLY,
            COMPLEX;

        }
    }

    private static class LocalIndexColumnRef
    extends ColumnRef {
        private final TableRef indexTableRef;

        public LocalIndexColumnRef(TableRef tableRef, String familyName, String columnName, TableRef indexTableRef) throws MetaDataEntityNotFoundException {
            super(tableRef, familyName, columnName);
            this.indexTableRef = indexTableRef;
        }

        @Override
        public TableRef getTableRef() {
            return this.indexTableRef;
        }
    }

    private static class OnNodeVisitor
    extends AndBooleanParseNodeVisitor<Void> {
        private final ColumnRefParseNodeVisitor columnRefVisitor;
        private final JoinSpec joinSpec;

        public OnNodeVisitor(ColumnResolver resolver, JoinSpec joinSpec, PhoenixConnection connection) {
            this.joinSpec = joinSpec;
            this.columnRefVisitor = new ColumnRefParseNodeVisitor(resolver, connection);
        }

        @Override
        protected Void leaveBooleanNode(ParseNode node, List<Void> l) throws SQLException {
            this.columnRefVisitor.reset();
            node.accept(this.columnRefVisitor);
            ColumnRefParseNodeVisitor.ColumnRefType type = this.columnRefVisitor.getContentType(this.joinSpec.getRhsJoinTableRefs());
            if (type == ColumnRefParseNodeVisitor.ColumnRefType.NONE || type == ColumnRefParseNodeVisitor.ColumnRefType.SELF_ONLY) {
                this.joinSpec.pushDownFilterToRhsJoinTable(node);
            } else {
                this.throwAmbiguousJoinConditionException();
            }
            return null;
        }

        @Override
        protected Void leaveNonBooleanNode(ParseNode node, List<Void> l) throws SQLException {
            return null;
        }

        @Override
        public Void visitLeave(AndParseNode node, List<Void> l) throws SQLException {
            return null;
        }

        @Override
        public Void visitLeave(ComparisonParseNode node, List<Void> l) throws SQLException {
            if (!(node instanceof EqualParseNode)) {
                return this.leaveBooleanNode((ParseNode)node, (List)l);
            }
            this.columnRefVisitor.reset();
            node.getLHS().accept(this.columnRefVisitor);
            ColumnRefParseNodeVisitor.ColumnRefType lhsType = this.columnRefVisitor.getContentType(this.joinSpec.getRhsJoinTableRefs());
            HashSet lhsTableRefSet = Sets.newHashSet(this.columnRefVisitor.getTableRefSet());
            this.columnRefVisitor.reset();
            node.getRHS().accept(this.columnRefVisitor);
            ColumnRefParseNodeVisitor.ColumnRefType rhsType = this.columnRefVisitor.getContentType(this.joinSpec.getRhsJoinTableRefs());
            HashSet rhsTableRefSet = Sets.newHashSet(this.columnRefVisitor.getTableRefSet());
            if (!(lhsType != ColumnRefParseNodeVisitor.ColumnRefType.SELF_ONLY && lhsType != ColumnRefParseNodeVisitor.ColumnRefType.NONE || rhsType != ColumnRefParseNodeVisitor.ColumnRefType.SELF_ONLY && rhsType != ColumnRefParseNodeVisitor.ColumnRefType.NONE)) {
                this.joinSpec.pushDownFilterToRhsJoinTable(node);
            } else if (lhsType == ColumnRefParseNodeVisitor.ColumnRefType.FOREIGN_ONLY && rhsType == ColumnRefParseNodeVisitor.ColumnRefType.SELF_ONLY) {
                this.joinSpec.addOnCondition((EqualParseNode)node);
                this.joinSpec.addDependentTableRefs(lhsTableRefSet);
            } else if (rhsType == ColumnRefParseNodeVisitor.ColumnRefType.FOREIGN_ONLY && lhsType == ColumnRefParseNodeVisitor.ColumnRefType.SELF_ONLY) {
                this.joinSpec.addOnCondition(NODE_FACTORY.equal(node.getRHS(), node.getLHS()));
                this.joinSpec.addDependentTableRefs(rhsTableRefSet);
            } else {
                this.throwAmbiguousJoinConditionException();
            }
            return null;
        }

        public void throwAmbiguousJoinConditionException() throws SQLException {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.AMBIGUOUS_JOIN_CONDITION).build().buildException();
        }
    }

    private static class WhereNodeVisitor
    extends AndBooleanParseNodeVisitor<Void> {
        private ColumnRefParseNodeVisitor columnRefVisitor;
        private JoinTable joinTable;

        public WhereNodeVisitor(ColumnResolver resolver, JoinTable joinTablesContext, PhoenixConnection connection) {
            this.joinTable = joinTablesContext;
            this.columnRefVisitor = new ColumnRefParseNodeVisitor(resolver, connection);
        }

        @Override
        protected Void leaveBooleanNode(ParseNode node, List<Void> l) throws SQLException {
            this.columnRefVisitor.reset();
            node.accept(this.columnRefVisitor);
            ColumnRefParseNodeVisitor.ColumnRefType type = this.columnRefVisitor.getContentType(this.joinTable.getLeftTableRef());
            switch (type) {
                case NONE: 
                case SELF_ONLY: {
                    this.joinTable.addLeftTableFilter(node);
                    break;
                }
                case FOREIGN_ONLY: {
                    JoinTable matched = null;
                    for (JoinSpec joinSpec : this.joinTable.getPrefilterAcceptedJoinSpecs()) {
                        if (this.columnRefVisitor.getContentType(joinSpec.getRhsJoinTable().getAllTableRefs()) != ColumnRefParseNodeVisitor.ColumnRefType.SELF_ONLY) continue;
                        matched = joinSpec.getRhsJoinTable();
                        break;
                    }
                    if (matched != null) {
                        matched.pushDownFilter(node);
                        break;
                    }
                    this.joinTable.addPostJoinFilter(node);
                    break;
                }
                default: {
                    this.joinTable.addPostJoinFilter(node);
                }
            }
            return null;
        }

        @Override
        protected Void leaveNonBooleanNode(ParseNode node, List<Void> l) throws SQLException {
            return null;
        }

        @Override
        public Void visitLeave(AndParseNode node, List<Void> l) throws SQLException {
            return null;
        }

        @Override
        public Void visitLeave(ComparisonParseNode node, List<Void> l) throws SQLException {
            if (!(node instanceof EqualParseNode)) {
                return this.leaveBooleanNode((ParseNode)node, (List)l);
            }
            List<JoinSpec> prefilterAcceptedJoinSpecs = this.joinTable.getPrefilterAcceptedJoinSpecs();
            ListIterator<JoinSpec> iter = prefilterAcceptedJoinSpecs.listIterator(prefilterAcceptedJoinSpecs.size());
            while (iter.hasPrevious()) {
                JoinSpec joinSpec = iter.previous();
                if (joinSpec.getType() != JoinTableNode.JoinType.Inner || joinSpec.isSingleValueOnly()) continue;
                try {
                    joinSpec.pushDownOnCondition(node);
                    return null;
                }
                catch (SQLException sQLException) {
                }
            }
            return this.leaveBooleanNode((ParseNode)node, (List)l);
        }
    }

    private static class PushDownPostFilterParseNodeVisitor
    extends AndRewriterBooleanParseNodeVisitor {
        private ColumnRefParseNodeVisitor columnRefParseNodeVisitor;
        private JoinTable joinTable;

        public PushDownPostFilterParseNodeVisitor(ColumnResolver resolver, JoinTable joinTablesContext, PhoenixConnection connection) {
            super(NODE_FACTORY);
            this.joinTable = joinTablesContext;
            this.columnRefParseNodeVisitor = new ColumnRefParseNodeVisitor(resolver, connection);
        }

        @Override
        protected ParseNode leaveBooleanNode(ParseNode parentParseNode, List<ParseNode> childParseNodes) throws SQLException {
            this.columnRefParseNodeVisitor.reset();
            parentParseNode.accept(this.columnRefParseNodeVisitor);
            ColumnRefParseNodeVisitor.ColumnRefType columnRefType = this.columnRefParseNodeVisitor.getContentType(this.joinTable.getAllTableRefs());
            if (columnRefType == ColumnRefParseNodeVisitor.ColumnRefType.NONE || columnRefType == ColumnRefParseNodeVisitor.ColumnRefType.SELF_ONLY) {
                this.joinTable.postFilters.add(parentParseNode);
                return null;
            }
            return parentParseNode;
        }
    }

    public class Table {
        private TableNode tableNode;
        private final boolean isWildcard;
        private final List<ColumnDef> dynamicColumns;
        private final Double tableSamplingRate;
        private SelectStatement subselectStatement;
        private TableRef tableRef;
        private final List<ParseNode> preFilterParseNodes;
        private final List<ParseNode> postFilterParseNodes;
        private final boolean filterCanPushDownToSubselect;

        private Table(TableNode tableNode, boolean isWildcard, List<ColumnDef> dynamicColumns, Double tableSamplingRate, TableRef tableRef) {
            this.tableNode = tableNode;
            this.isWildcard = isWildcard;
            this.dynamicColumns = dynamicColumns;
            this.tableSamplingRate = tableSamplingRate;
            this.subselectStatement = null;
            this.tableRef = tableRef;
            this.preFilterParseNodes = new ArrayList<ParseNode>();
            this.postFilterParseNodes = Collections.emptyList();
            this.filterCanPushDownToSubselect = false;
        }

        private Table(DerivedTableNode tableNode, boolean isWildcard, TableRef tableRef) throws SQLException {
            this.tableNode = tableNode;
            this.isWildcard = isWildcard;
            this.dynamicColumns = Collections.emptyList();
            this.tableSamplingRate = ConcreteTableNode.DEFAULT_TABLE_SAMPLING_RATE;
            this.subselectStatement = SubselectRewriter.flatten(tableNode.getSelect(), JoinCompiler.this.phoenixStatement.getConnection());
            this.tableRef = tableRef;
            this.preFilterParseNodes = new ArrayList<ParseNode>();
            this.postFilterParseNodes = new ArrayList<ParseNode>();
            this.filterCanPushDownToSubselect = SubselectRewriter.isFilterCanPushDownToSelect(this.subselectStatement);
        }

        public TableNode getTableNode() {
            return this.tableNode;
        }

        public List<ColumnDef> getDynamicColumns() {
            return this.dynamicColumns;
        }

        public Double getTableSamplingRate() {
            return this.tableSamplingRate;
        }

        public boolean isSubselect() {
            return this.subselectStatement != null;
        }

        public SelectStatement getSubselectStatement() {
            return this.subselectStatement;
        }

        public void pruneSubselectAliasedNodes() throws SQLException {
            if (!this.isSubselect()) {
                return;
            }
            Set<String> referencedColumnNames = this.getReferencedColumnNames();
            SelectStatement newSubselectStatement = SubselectRewriter.pruneSelectAliasedNodes(this.subselectStatement, referencedColumnNames, JoinCompiler.this.phoenixStatement.getConnection());
            if (!newSubselectStatement.getSelect().equals(this.subselectStatement.getSelect())) {
                DerivedTableNode newDerivedTableNode = NODE_FACTORY.derivedTable(this.tableNode.getAlias(), newSubselectStatement);
                TableRef newTableRef = FromCompiler.refreshDerivedTableNode(JoinCompiler.this.origResolver, newDerivedTableNode);
                assert (newTableRef != null);
                this.subselectStatement = newSubselectStatement;
                this.tableRef = newTableRef;
                this.tableNode = newDerivedTableNode;
            }
        }

        private Set<String> getReferencedColumnNames() throws SQLException {
            assert (this.isSubselect());
            if (this.isWildCardSelect()) {
                return null;
            }
            HashSet<String> referencedColumnNames = new HashSet<String>();
            for (Map.Entry entry : JoinCompiler.this.columnNodes.entrySet()) {
                if (!this.tableRef.equals(((ColumnRef)entry.getKey()).getTableRef())) continue;
                ColumnParseNode columnParseNode = (ColumnParseNode)entry.getValue();
                String normalizedColumnName = SchemaUtil.getNormalizedColumnName(columnParseNode);
                referencedColumnNames.add(normalizedColumnName);
            }
            return referencedColumnNames;
        }

        public List<AliasedNode> getSelectAliasedNodes() {
            if (this.isWildCardSelect()) {
                return Collections.singletonList(NODE_FACTORY.aliasedNode(null, NODE_FACTORY.wildcard()));
            }
            ArrayList<AliasedNode> ret = new ArrayList<AliasedNode>();
            for (Map.Entry entry : JoinCompiler.this.columnNodes.entrySet()) {
                if (!this.tableRef.equals(((ColumnRef)entry.getKey()).getTableRef())) continue;
                ret.add(NODE_FACTORY.aliasedNode(null, (ParseNode)entry.getValue()));
            }
            if (ret.isEmpty()) {
                ret.add(NODE_FACTORY.aliasedNode(null, NODE_FACTORY.literal(1)));
            }
            return ret;
        }

        public List<ParseNode> getPreFilterParseNodes() {
            return this.preFilterParseNodes;
        }

        public List<ParseNode> getPostFilterParseNodes() {
            return this.postFilterParseNodes;
        }

        public TableRef getTableRef() {
            return this.tableRef;
        }

        public void addFilter(ParseNode filter) throws SQLException {
            if (!this.isSubselect() || this.filterCanPushDownToSubselect) {
                this.addPreFilter(filter);
            } else {
                this.postFilterParseNodes.add(filter);
            }
        }

        private void addPreFilter(ParseNode preFilterParseNode) throws SQLException {
            if (this.isSubselect()) {
                preFilterParseNode = SubselectRewriter.rewritePreFilterForSubselect(preFilterParseNode, this.subselectStatement, this.tableNode.getAlias());
            }
            this.preFilterParseNodes.add(preFilterParseNode);
        }

        public ParseNode getCombinedPreFilterParseNodes() {
            return JoinCompiler.combine(this.preFilterParseNodes);
        }

        public SelectStatement getAsSubquery(List<OrderByNode> newOrderByNodes) throws SQLException {
            if (this.isSubselect()) {
                return SubselectRewriter.applyOrderByAndPostFilters(this.getSelectStatementByApplyPreFiltersForSubselect(), newOrderByNodes, this.tableNode.getAlias(), this.postFilterParseNodes);
            }
            assert (this.postFilterParseNodes == null || this.postFilterParseNodes.isEmpty());
            return NODE_FACTORY.select(this.tableNode, JoinCompiler.this.originalJoinSelectStatement.getHint(), false, this.getSelectAliasedNodes(), this.getCombinedPreFilterParseNodes(), null, null, newOrderByNodes, null, null, 0, false, JoinCompiler.this.originalJoinSelectStatement.hasSequence(), Collections.emptyList(), JoinCompiler.this.originalJoinSelectStatement.getUdfParseNodes());
        }

        public SelectStatement getAsSubqueryForOptimization(boolean applyGroupByOrOrderBy) throws SQLException {
            Set<TableRef> set;
            assert (!this.isSubselect());
            SelectStatement query = this.getAsSubquery(null);
            if (!applyGroupByOrOrderBy) {
                return query;
            }
            boolean addGroupBy = false;
            boolean addOrderBy = false;
            if (JoinCompiler.this.originalJoinSelectStatement.getGroupBy() != null && !JoinCompiler.this.originalJoinSelectStatement.getGroupBy().isEmpty()) {
                ColumnRefParseNodeVisitor groupByVisitor = new ColumnRefParseNodeVisitor(JoinCompiler.this.origResolver, JoinCompiler.this.phoenixStatement.getConnection());
                for (ParseNode parseNode : JoinCompiler.this.originalJoinSelectStatement.getGroupBy()) {
                    parseNode.accept(groupByVisitor);
                }
                set = groupByVisitor.getTableRefSet();
                if (set.size() == 1 && this.tableRef.equals(set.iterator().next())) {
                    addGroupBy = true;
                }
            } else if (JoinCompiler.this.originalJoinSelectStatement.getOrderBy() != null && !JoinCompiler.this.originalJoinSelectStatement.getOrderBy().isEmpty()) {
                ColumnRefParseNodeVisitor orderByVisitor = new ColumnRefParseNodeVisitor(JoinCompiler.this.origResolver, JoinCompiler.this.phoenixStatement.getConnection());
                for (OrderByNode orderByNode : JoinCompiler.this.originalJoinSelectStatement.getOrderBy()) {
                    orderByNode.getNode().accept(orderByVisitor);
                }
                set = orderByVisitor.getTableRefSet();
                if (set.size() == 1 && this.tableRef.equals(set.iterator().next())) {
                    addOrderBy = true;
                }
            }
            if (!addGroupBy && !addOrderBy) {
                return query;
            }
            List<AliasedNode> selectList = query.getSelect();
            if (addGroupBy) {
                assert (!this.isWildCardSelect());
                selectList = new ArrayList<AliasedNode>(query.getSelect().size());
                for (AliasedNode aliasedNode : query.getSelect()) {
                    FunctionParseNode node = NODE_FACTORY.function("MIN", Collections.singletonList(aliasedNode.getNode()));
                    selectList.add(NODE_FACTORY.aliasedNode(null, node));
                }
            }
            return NODE_FACTORY.select(query.getFrom(), query.getHint(), query.isDistinct(), selectList, query.getWhere(), addGroupBy ? JoinCompiler.this.originalJoinSelectStatement.getGroupBy() : query.getGroupBy(), addGroupBy ? null : query.getHaving(), addOrderBy ? JoinCompiler.this.originalJoinSelectStatement.getOrderBy() : query.getOrderBy(), query.getLimit(), query.getOffset(), query.getBindCount(), addGroupBy, query.hasSequence(), query.getSelects(), query.getUdfParseNodes());
        }

        public boolean hasFilters() {
            return this.isSubselect() ? !this.postFilterParseNodes.isEmpty() || this.subselectStatement.getWhere() != null || this.subselectStatement.getHaving() != null : !this.preFilterParseNodes.isEmpty();
        }

        public boolean isCouldPushToServerAsHashJoinProbeSide() throws SQLException {
            if (this.postFilterParseNodes != null && !this.postFilterParseNodes.isEmpty()) {
                return false;
            }
            SelectStatement selectStatementToUse = this.getAsSubquery(null);
            ParseNodeUtil.RewriteResult rewriteResult = ParseNodeUtil.rewrite(selectStatementToUse, JoinCompiler.this.phoenixStatement.getConnection());
            return JoinCompiler.isCouldPushToServerAsHashJoinProbeSide(rewriteResult.getRewrittenSelectStatement());
        }

        private SelectStatement getSelectStatementByApplyPreFiltersForSubselect() {
            return SubselectRewriter.applyPreFiltersForSubselect(this.subselectStatement, this.preFilterParseNodes, this.tableNode.getAlias());
        }

        protected boolean isWildCardSelect() {
            return this.isWildcard;
        }

        public void projectColumns(Scan scan) {
            assert (!this.isSubselect());
            if (this.isWildCardSelect()) {
                scan.getFamilyMap().clear();
                return;
            }
            for (ColumnRef columnRef : JoinCompiler.this.columnRefs.keySet()) {
                if (!columnRef.getTableRef().equals(this.tableRef) || SchemaUtil.isPKColumn(columnRef.getColumn()) || columnRef instanceof LocalIndexColumnRef) continue;
                EncodedColumnsUtil.setColumns(columnRef.getColumn(), this.tableRef.getTable(), scan);
            }
        }

        public PTable createProjectedTable(boolean retainPKColumns, StatementContext context) throws SQLException {
            assert (!this.isSubselect());
            ArrayList<ColumnRef> sourceColumns = new ArrayList<ColumnRef>();
            PTable table = this.tableRef.getTable();
            if (retainPKColumns) {
                for (PColumn pColumn : table.getPKColumns()) {
                    sourceColumns.add(new ColumnRef(this.tableRef, pColumn.getPosition()));
                }
            }
            if (this.isWildCardSelect()) {
                for (PColumn pColumn : table.getColumns()) {
                    if (retainPKColumns && SchemaUtil.isPKColumn(pColumn)) continue;
                    sourceColumns.add(new ColumnRef(this.tableRef, pColumn.getPosition()));
                }
            } else {
                for (Map.Entry entry : JoinCompiler.this.columnRefs.entrySet()) {
                    ColumnRef columnRef = (ColumnRef)entry.getKey();
                    if (!columnRef.getTableRef().equals(this.tableRef) || retainPKColumns && SchemaUtil.isPKColumn(columnRef.getColumn())) continue;
                    if (columnRef instanceof LocalIndexColumnRef) {
                        sourceColumns.add(new LocalIndexDataColumnRef(context, this.tableRef, IndexUtil.getIndexColumnName(columnRef.getColumn())));
                        continue;
                    }
                    sourceColumns.add(columnRef);
                }
            }
            return TupleProjectionCompiler.createProjectedTable(this.tableRef, sourceColumns, retainPKColumns);
        }

        public PTable createProjectedTable(RowProjector rowProjector) throws SQLException {
            assert (this.isSubselect());
            TableRef tableRef = FromCompiler.getResolverForCompiledDerivedTable(JoinCompiler.this.phoenixStatement.getConnection(), this.tableRef, rowProjector).getTables().get(0);
            ArrayList<ColumnRef> sourceColumns = new ArrayList<ColumnRef>();
            PTable table = tableRef.getTable();
            for (PColumn column : table.getColumns()) {
                sourceColumns.add(new ColumnRef(tableRef, column.getPosition()));
            }
            return TupleProjectionCompiler.createProjectedTable(tableRef, sourceColumns, false);
        }
    }

    public class JoinSpec {
        private final JoinTableNode.JoinType type;
        private final List<EqualParseNode> onConditions;
        private final JoinTable rhsJoinTable;
        private final boolean singleValueOnly;
        private Set<TableRef> dependentTableRefs;
        private OnNodeVisitor onNodeVisitor;

        private JoinSpec(JoinTableNode.JoinType type, ParseNode onNode, JoinTable joinTable, boolean singleValueOnly, ColumnResolver resolver) throws SQLException {
            this.type = type;
            this.onConditions = new ArrayList<EqualParseNode>();
            this.rhsJoinTable = joinTable;
            this.singleValueOnly = singleValueOnly;
            this.dependentTableRefs = new HashSet<TableRef>();
            this.onNodeVisitor = new OnNodeVisitor(resolver, this, JoinCompiler.this.phoenixStatement.getConnection());
            if (onNode != null) {
                this.pushDownOnCondition(onNode);
            }
        }

        public void pushDownOnCondition(ParseNode node) throws SQLException {
            node.accept(this.onNodeVisitor);
        }

        public JoinTableNode.JoinType getType() {
            return this.type;
        }

        public List<EqualParseNode> getOnConditions() {
            return this.onConditions;
        }

        public JoinTable getRhsJoinTable() {
            return this.rhsJoinTable;
        }

        public List<TableRef> getRhsJoinTableRefs() {
            return this.rhsJoinTable.getAllTableRefs();
        }

        public void pushDownFilterToRhsJoinTable(ParseNode parseNode) throws SQLException {
            this.rhsJoinTable.pushDownFilter(parseNode);
        }

        public void addOnCondition(EqualParseNode equalParseNode) {
            this.onConditions.add(equalParseNode);
        }

        public void addDependentTableRefs(Collection<TableRef> tableRefs) {
            this.dependentTableRefs.addAll(tableRefs);
        }

        public boolean isSingleValueOnly() {
            return this.singleValueOnly;
        }

        public Set<TableRef> getDependentTableRefs() {
            return this.dependentTableRefs;
        }

        public Pair<List<Expression>, List<Expression>> compileJoinConditions(StatementContext lhsCtx, StatementContext rhsCtx, Strategy strategy) throws SQLException {
            if (this.onConditions.isEmpty()) {
                return new Pair(Collections.singletonList(LiteralExpression.newConstant(1)), Collections.singletonList(LiteralExpression.newConstant(1)));
            }
            ArrayList compiled = Lists.newArrayListWithExpectedSize((int)this.onConditions.size());
            ExpressionCompiler lhsCompiler = new ExpressionCompiler(lhsCtx);
            ExpressionCompiler rhsCompiler = new ExpressionCompiler(rhsCtx);
            for (EqualParseNode condition : this.onConditions) {
                SortOrder toSortOrder;
                lhsCompiler.reset();
                Expression left = condition.getLHS().accept(lhsCompiler);
                rhsCompiler.reset();
                Expression right = condition.getRHS().accept(rhsCompiler);
                PDataType toType = this.getCommonType(left.getDataType(), right.getDataType());
                SortOrder sortOrder = strategy == Strategy.SORT_MERGE ? SortOrder.ASC : (toSortOrder = strategy == Strategy.HASH_BUILD_LEFT ? right.getSortOrder() : left.getSortOrder());
                if (left.getDataType() != toType || left.getSortOrder() != toSortOrder) {
                    left = CoerceExpression.create(left, toType, toSortOrder, left.getMaxLength());
                }
                if (right.getDataType() != toType || right.getSortOrder() != toSortOrder) {
                    right = CoerceExpression.create(right, toType, toSortOrder, right.getMaxLength());
                }
                compiled.add(new Pair((Object)left, (Object)right));
            }
            if (strategy != Strategy.SORT_MERGE) {
                Collections.sort(compiled, new Comparator<Pair<Expression, Expression>>(){

                    @Override
                    public int compare(Pair<Expression, Expression> o1, Pair<Expression, Expression> o2) {
                        boolean isFixedNullable2;
                        Expression e1 = (Expression)o1.getFirst();
                        Expression e2 = (Expression)o2.getFirst();
                        boolean isFixed1 = e1.getDataType().isFixedWidth();
                        boolean isFixed2 = e2.getDataType().isFixedWidth();
                        boolean isFixedNullable1 = e1.isNullable() && isFixed1;
                        boolean bl = isFixedNullable2 = e2.isNullable() && isFixed2;
                        if (isFixedNullable1 == isFixedNullable2) {
                            if (isFixed1 == isFixed2) {
                                return 0;
                            }
                            if (isFixed1) {
                                return -1;
                            }
                            return 1;
                        }
                        if (isFixedNullable1) {
                            return 1;
                        }
                        return -1;
                    }
                });
            }
            ArrayList lConditions = Lists.newArrayListWithExpectedSize((int)compiled.size());
            ArrayList rConditions = Lists.newArrayListWithExpectedSize((int)compiled.size());
            for (Pair pair : compiled) {
                lConditions.add(pair.getFirst());
                rConditions.add(pair.getSecond());
            }
            return new Pair((Object)lConditions, (Object)rConditions);
        }

        private PDataType getCommonType(PDataType lType, PDataType rType) throws SQLException {
            if (lType == rType) {
                return lType;
            }
            if (!lType.isComparableTo(rType)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.TYPE_MISMATCH).setMessage("On-clause LHS expression and RHS expression must be comparable. LHS type: " + lType + ", RHS type: " + rType).build().buildException();
            }
            if (lType.isCoercibleTo(PTinyint.INSTANCE) && (rType == null || rType.isCoercibleTo(PTinyint.INSTANCE))) {
                return lType;
            }
            if (lType.isCoercibleTo(PSmallint.INSTANCE) && (rType == null || rType.isCoercibleTo(PSmallint.INSTANCE))) {
                return lType;
            }
            if (lType.isCoercibleTo(PInteger.INSTANCE) && (rType == null || rType.isCoercibleTo(PInteger.INSTANCE))) {
                return lType;
            }
            if (lType.isCoercibleTo(PLong.INSTANCE) && (rType == null || rType.isCoercibleTo(PLong.INSTANCE))) {
                return lType;
            }
            if (lType.isCoercibleTo(PDouble.INSTANCE) && (rType == null || rType.isCoercibleTo(PDouble.INSTANCE))) {
                return lType;
            }
            if (lType.isCoercibleTo(PDecimal.INSTANCE) && (rType == null || rType.isCoercibleTo(PDecimal.INSTANCE))) {
                return PDecimal.INSTANCE;
            }
            if (lType.isCoercibleTo(PDate.INSTANCE) && (rType == null || rType.isCoercibleTo(PDate.INSTANCE))) {
                return lType;
            }
            if (lType.isCoercibleTo(PTimestamp.INSTANCE) && (rType == null || rType.isCoercibleTo(PTimestamp.INSTANCE))) {
                return lType;
            }
            if (lType.isCoercibleTo(PVarchar.INSTANCE) && (rType == null || rType.isCoercibleTo(PVarchar.INSTANCE))) {
                return PVarchar.INSTANCE;
            }
            if (lType.isCoercibleTo(PBoolean.INSTANCE) && (rType == null || rType.isCoercibleTo(PBoolean.INSTANCE))) {
                return PBoolean.INSTANCE;
            }
            return PVarbinary.INSTANCE;
        }
    }

    public class JoinTable {
        private final Table leftTable;
        private final List<JoinSpec> joinSpecs;
        private List<ParseNode> postFilters;
        private final List<Table> allTables;
        private final List<TableRef> allTableRefs;
        private final boolean allLeftJoin;
        private final boolean isPrefilterAccepted;
        private final List<JoinSpec> prefilterAcceptedTables;

        private JoinTable(Table table) {
            this.leftTable = table;
            this.joinSpecs = Collections.emptyList();
            this.postFilters = Collections.EMPTY_LIST;
            this.allTables = Collections.singletonList(table);
            this.allTableRefs = Collections.singletonList(table.getTableRef());
            this.allLeftJoin = false;
            this.isPrefilterAccepted = true;
            this.prefilterAcceptedTables = Collections.emptyList();
        }

        private JoinTable(Table table, List<JoinSpec> joinSpecs) {
            int i;
            JoinSpec joinSpec;
            this.leftTable = table;
            this.joinSpecs = joinSpecs;
            this.postFilters = new ArrayList<ParseNode>();
            this.allTables = new ArrayList<Table>();
            this.allTableRefs = new ArrayList<TableRef>();
            this.allTables.add(table);
            boolean allLeftJoin = true;
            int lastRightJoinIndex = -1;
            boolean hasFullJoin = false;
            for (int i2 = 0; i2 < joinSpecs.size(); ++i2) {
                joinSpec = joinSpecs.get(i2);
                this.allTables.addAll(joinSpec.getRhsJoinTable().getAllTables());
                allLeftJoin = allLeftJoin && joinSpec.getType() == JoinTableNode.JoinType.Left;
                boolean bl = hasFullJoin = hasFullJoin || joinSpec.getType() == JoinTableNode.JoinType.Full;
                if (joinSpec.getType() != JoinTableNode.JoinType.Right) continue;
                lastRightJoinIndex = i2;
            }
            for (Table t : this.allTables) {
                this.allTableRefs.add(t.getTableRef());
            }
            this.allLeftJoin = allLeftJoin;
            this.isPrefilterAccepted = !hasFullJoin && lastRightJoinIndex == -1;
            this.prefilterAcceptedTables = new ArrayList<JoinSpec>();
            int n = i = lastRightJoinIndex == -1 ? 0 : lastRightJoinIndex;
            while (i < joinSpecs.size()) {
                joinSpec = joinSpecs.get(i);
                if (joinSpec.getType() != JoinTableNode.JoinType.Left && joinSpec.getType() != JoinTableNode.JoinType.Anti && joinSpec.getType() != JoinTableNode.JoinType.Full) {
                    this.prefilterAcceptedTables.add(joinSpec);
                }
                ++i;
            }
        }

        public Table getLeftTable() {
            return this.leftTable;
        }

        public List<JoinSpec> getJoinSpecs() {
            return this.joinSpecs;
        }

        public List<Table> getAllTables() {
            return this.allTables;
        }

        public List<TableRef> getAllTableRefs() {
            return this.allTableRefs;
        }

        public List<TableRef> getLeftTableRef() {
            return Collections.singletonList(this.leftTable.getTableRef());
        }

        public boolean isAllLeftJoin() {
            return this.allLeftJoin;
        }

        public SelectStatement getOriginalJoinSelectStatement() {
            return JoinCompiler.this.originalJoinSelectStatement;
        }

        public ColumnResolver getOriginalResolver() {
            return JoinCompiler.this.origResolver;
        }

        public Map<ColumnRef, ColumnRefType> getColumnRefs() {
            return JoinCompiler.this.columnRefs;
        }

        public ParseNode getPostFiltersCombined() {
            return JoinCompiler.combine(this.postFilters);
        }

        public void addPostJoinFilter(ParseNode parseNode) {
            if (this.postFilters == Collections.EMPTY_LIST) {
                this.postFilters = new ArrayList<ParseNode>();
            }
            this.postFilters.add(parseNode);
        }

        public void addLeftTableFilter(ParseNode parseNode) throws SQLException {
            if (this.isPrefilterAccepted) {
                this.leftTable.addFilter(parseNode);
            } else {
                this.addPostJoinFilter(parseNode);
            }
        }

        public List<JoinSpec> getPrefilterAcceptedJoinSpecs() {
            return this.prefilterAcceptedTables;
        }

        public void pushDownFilter(ParseNode filter) throws SQLException {
            if (this.joinSpecs.isEmpty()) {
                this.leftTable.addFilter(filter);
                return;
            }
            WhereNodeVisitor visitor = new WhereNodeVisitor(JoinCompiler.this.origResolver, this, JoinCompiler.this.phoenixStatement.getConnection());
            filter.accept(visitor);
        }

        public void pushDownColumnRefVisitors(ColumnRefParseNodeVisitor generalRefVisitor, ColumnRefParseNodeVisitor joinLocalRefVisitor) throws SQLException {
            for (ParseNode node : this.leftTable.getPostFilterParseNodes()) {
                node.accept(generalRefVisitor);
            }
            for (ParseNode node : this.postFilters) {
                node.accept(generalRefVisitor);
            }
            for (JoinSpec joinSpec : this.joinSpecs) {
                JoinTable joinTable = joinSpec.getRhsJoinTable();
                boolean hasSubJoin = !joinTable.getJoinSpecs().isEmpty();
                for (EqualParseNode node : joinSpec.getOnConditions()) {
                    node.getLHS().accept(generalRefVisitor);
                    if (hasSubJoin) {
                        node.getRHS().accept(generalRefVisitor);
                        continue;
                    }
                    node.getRHS().accept(joinLocalRefVisitor);
                }
                joinTable.pushDownColumnRefVisitors(generalRefVisitor, joinLocalRefVisitor);
            }
        }

        public void pruneSubselectAliasedNodes() throws SQLException {
            this.leftTable.pruneSubselectAliasedNodes();
            for (JoinSpec joinSpec : this.joinSpecs) {
                JoinTable rhsJoinTablesContext = joinSpec.getRhsJoinTable();
                rhsJoinTablesContext.pruneSubselectAliasedNodes();
            }
        }

        public Expression compilePostFilterExpression(StatementContext context) throws SQLException {
            ArrayList filtersCombined = Lists.newArrayList(this.postFilters);
            return JoinCompiler.compilePostFilterExpression(context, filtersCombined);
        }

        public List<Strategy> getApplicableJoinStrategies() throws SQLException {
            ArrayList strategies = Lists.newArrayList();
            if (JoinCompiler.this.useSortMergeJoin) {
                strategies.add(Strategy.SORT_MERGE);
            } else {
                JoinSpec lastJoinSpec;
                JoinTableNode.JoinType type;
                if (this.getStarJoinVector() != null) {
                    strategies.add(Strategy.HASH_BUILD_RIGHT);
                }
                if (((type = (lastJoinSpec = this.joinSpecs.get(this.joinSpecs.size() - 1)).getType()) == JoinTableNode.JoinType.Right || type == JoinTableNode.JoinType.Inner) && lastJoinSpec.getRhsJoinTable().getJoinSpecs().isEmpty() && lastJoinSpec.getRhsJoinTable().getLeftTable().isCouldPushToServerAsHashJoinProbeSide()) {
                    strategies.add(Strategy.HASH_BUILD_LEFT);
                }
                strategies.add(Strategy.SORT_MERGE);
            }
            return strategies;
        }

        public boolean[] getStarJoinVector() throws SQLException {
            int count = this.joinSpecs.size();
            if (!this.leftTable.isCouldPushToServerAsHashJoinProbeSide() || !JoinCompiler.this.useStarJoin && count > 1 && this.joinSpecs.get(count - 1).getType() != JoinTableNode.JoinType.Left && this.joinSpecs.get(count - 1).getType() != JoinTableNode.JoinType.Semi && this.joinSpecs.get(count - 1).getType() != JoinTableNode.JoinType.Anti && !this.joinSpecs.get(count - 1).isSingleValueOnly()) {
                return null;
            }
            boolean[] vector = new boolean[count];
            for (int i = 0; i < count; ++i) {
                JoinSpec joinSpec = this.joinSpecs.get(i);
                if (joinSpec.getType() != JoinTableNode.JoinType.Left && joinSpec.getType() != JoinTableNode.JoinType.Inner && joinSpec.getType() != JoinTableNode.JoinType.Semi && joinSpec.getType() != JoinTableNode.JoinType.Anti) {
                    return null;
                }
                vector[i] = true;
                Iterator<TableRef> iter = joinSpec.getDependentTableRefs().iterator();
                while (vector[i] && iter.hasNext()) {
                    TableRef tableRef = iter.next();
                    if (tableRef.equals(this.leftTable.getTableRef())) continue;
                    vector[i] = false;
                }
            }
            return vector;
        }

        public JoinTable createSubJoinTable(PhoenixConnection phoenixConnection) throws SQLException {
            assert (this.joinSpecs.size() > 0);
            JoinTable newJoinTablesContext = this.joinSpecs.size() > 1 ? new JoinTable(this.leftTable, this.joinSpecs.subList(0, this.joinSpecs.size() - 1)) : new JoinTable(this.leftTable);
            JoinTableNode.JoinType rightmostJoinType = this.joinSpecs.get(this.joinSpecs.size() - 1).getType();
            if (rightmostJoinType == JoinTableNode.JoinType.Right || rightmostJoinType == JoinTableNode.JoinType.Full) {
                return newJoinTablesContext;
            }
            if (this.postFilters.isEmpty()) {
                return newJoinTablesContext;
            }
            PushDownPostFilterParseNodeVisitor pushDownPostFilterNodeVistor = new PushDownPostFilterParseNodeVisitor(JoinCompiler.this.origResolver, newJoinTablesContext, phoenixConnection);
            int index = 0;
            ArrayList<ParseNode> newPostFilterParseNodes = null;
            for (ParseNode postFilterParseNode : this.postFilters) {
                ParseNode newPostFilterParseNode = postFilterParseNode.accept(pushDownPostFilterNodeVistor);
                if (newPostFilterParseNode != postFilterParseNode && newPostFilterParseNodes == null) {
                    newPostFilterParseNodes = new ArrayList<ParseNode>(this.postFilters.subList(0, index));
                }
                if (newPostFilterParseNodes != null && newPostFilterParseNode != null) {
                    newPostFilterParseNodes.add(newPostFilterParseNode);
                }
                ++index;
            }
            if (newPostFilterParseNodes != null) {
                this.postFilters = newPostFilterParseNodes;
            }
            return newJoinTablesContext;
        }

        public SelectStatement getAsSingleSubquery(SelectStatement query, boolean asSubquery) throws SQLException {
            assert (JoinCompiler.isCouldPushToServerAsHashJoinProbeSide(query));
            if (asSubquery) {
                return query;
            }
            return NODE_FACTORY.select(JoinCompiler.this.originalJoinSelectStatement, query.getFrom(), query.getWhere());
        }

        public boolean hasPostReference() {
            for (Table table : this.allTables) {
                if (!table.isWildCardSelect()) continue;
                return true;
            }
            for (Map.Entry entry : JoinCompiler.this.columnRefs.entrySet()) {
                if (entry.getValue() != ColumnRefType.GENERAL || !this.allTableRefs.contains(((ColumnRef)entry.getKey()).getTableRef())) continue;
                return true;
            }
            return false;
        }

        public boolean hasFilters() {
            if (!this.postFilters.isEmpty()) {
                return true;
            }
            if (this.isPrefilterAccepted && this.leftTable.hasFilters()) {
                return true;
            }
            for (JoinSpec joinSpec : this.prefilterAcceptedTables) {
                if (!joinSpec.getRhsJoinTable().hasFilters()) continue;
                return true;
            }
            return false;
        }
    }

    private class JoinTableConstructor
    implements TableNodeVisitor<Pair<Table, List<JoinSpec>>> {
        private JoinTableConstructor() {
        }

        private TableRef resolveTable(String alias, TableName name) throws SQLException {
            if (alias != null) {
                return JoinCompiler.this.origResolver.resolveTable(null, alias);
            }
            return JoinCompiler.this.origResolver.resolveTable(name.getSchemaName(), name.getTableName());
        }

        @Override
        public Pair<Table, List<JoinSpec>> visit(BindTableNode boundTableNode) throws SQLException {
            TableRef tableRef = this.resolveTable(boundTableNode.getAlias(), boundTableNode.getName());
            boolean isWildCard = JoinCompiler.this.isWildCardSelectForTable(JoinCompiler.this.originalJoinSelectStatement.getSelect(), tableRef, JoinCompiler.this.origResolver);
            Table table = new Table(boundTableNode, isWildCard, Collections.emptyList(), boundTableNode.getTableSamplingRate(), tableRef);
            return new Pair((Object)table, null);
        }

        @Override
        public Pair<Table, List<JoinSpec>> visit(JoinTableNode joinNode) throws SQLException {
            Pair<Table, List<JoinSpec>> lhs = joinNode.getLHS().accept(this);
            Pair<Table, List<JoinSpec>> rhs = joinNode.getRHS().accept(this);
            JoinTable joinTable = rhs.getSecond() == null ? new JoinTable((Table)rhs.getFirst()) : new JoinTable((Table)rhs.getFirst(), (List)rhs.getSecond());
            ArrayList<JoinSpec> joinSpecs = (ArrayList<JoinSpec>)lhs.getSecond();
            if (joinSpecs == null) {
                joinSpecs = new ArrayList<JoinSpec>();
            }
            joinSpecs.add(new JoinSpec(joinNode.getType(), joinNode.getOnNode(), joinTable, joinNode.isSingleValueOnly(), JoinCompiler.this.origResolver));
            return new Pair(lhs.getFirst(), joinSpecs);
        }

        @Override
        public Pair<Table, List<JoinSpec>> visit(NamedTableNode namedTableNode) throws SQLException {
            TableRef tableRef = this.resolveTable(namedTableNode.getAlias(), namedTableNode.getName());
            boolean isWildCard = JoinCompiler.this.isWildCardSelectForTable(JoinCompiler.this.originalJoinSelectStatement.getSelect(), tableRef, JoinCompiler.this.origResolver);
            Table table = new Table(namedTableNode, isWildCard, namedTableNode.getDynamicColumns(), namedTableNode.getTableSamplingRate(), tableRef);
            return new Pair((Object)table, null);
        }

        @Override
        public Pair<Table, List<JoinSpec>> visit(DerivedTableNode subselectNode) throws SQLException {
            TableRef tableRef = this.resolveTable(subselectNode.getAlias(), null);
            boolean isWildCard = JoinCompiler.this.isWildCardSelectForTable(JoinCompiler.this.originalJoinSelectStatement.getSelect(), tableRef, JoinCompiler.this.origResolver);
            Table table = new Table(subselectNode, isWildCard, tableRef);
            return new Pair((Object)table, null);
        }
    }

    public static enum ColumnRefType {
        JOINLOCAL,
        GENERAL;

    }

    public static enum Strategy {
        HASH_BUILD_LEFT,
        HASH_BUILD_RIGHT,
        SORT_MERGE;

    }
}

