/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.Collections;
import org.apache.phoenix.compile.BaseMutationPlan;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.DropSequenceStatement;
import org.apache.phoenix.schema.MetaDataClient;

public class DropSequenceCompiler {
    private final PhoenixStatement statement;
    private final PhoenixStatement.Operation operation;

    public DropSequenceCompiler(PhoenixStatement statement, PhoenixStatement.Operation operation) {
        this.statement = statement;
        this.operation = operation;
    }

    public MutationPlan compile(final DropSequenceStatement sequence) throws SQLException {
        PhoenixConnection connection = this.statement.getConnection();
        final MetaDataClient client = new MetaDataClient(connection);
        StatementContext context = new StatementContext(this.statement);
        return new BaseMutationPlan(context, this.operation){

            @Override
            public MutationState execute() throws SQLException {
                return client.dropSequence(sequence);
            }

            @Override
            public ExplainPlan getExplainPlan() throws SQLException {
                return new ExplainPlan(Collections.singletonList("DROP SEQUENCE"));
            }
        };
    }
}

