/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import org.apache.curator.framework.CuratorFramework;
import org.apache.omid.tso.LeaseManager;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.TSOChannelHandler;
import org.apache.omid.tso.TSOStateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PausableLeaseManager
extends LeaseManager {
    private static final Logger LOG = LoggerFactory.getLogger(PausableLeaseManager.class);
    private volatile boolean pausedInTryToGetInitialLeasePeriod = false;
    private volatile boolean pausedInTryToRenewLeasePeriod = false;
    private volatile boolean pausedInStillInLeasePeriod = false;

    public PausableLeaseManager(String id, TSOChannelHandler tsoChannelHandler, TSOStateManager stateManager, long leasePeriodInMs, String tsoLeasePath, String currentTSOPath, CuratorFramework zkClient, Panicker panicker) {
        super(id, tsoChannelHandler, stateManager, leasePeriodInMs, tsoLeasePath, currentTSOPath, zkClient, panicker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryToGetInitialLeasePeriod() throws Exception {
        while (this.pausedInTryToGetInitialLeasePeriod) {
            PausableLeaseManager pausableLeaseManager = this;
            synchronized (pausableLeaseManager) {
                try {
                    LOG.info("{} paused in tryToGetInitialLeasePeriod()", (Object)this);
                    this.wait();
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted whilst paused");
                    Thread.currentThread().interrupt();
                }
            }
        }
        super.tryToGetInitialLeasePeriod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryToRenewLeasePeriod() throws Exception {
        while (this.pausedInTryToRenewLeasePeriod) {
            PausableLeaseManager pausableLeaseManager = this;
            synchronized (pausableLeaseManager) {
                try {
                    LOG.info("{} paused in tryToRenewLeasePeriod()", (Object)this);
                    this.wait();
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted whilst paused");
                    Thread.currentThread().interrupt();
                }
            }
        }
        super.tryToRenewLeasePeriod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stillInLeasePeriod() {
        while (this.pausedInStillInLeasePeriod) {
            PausableLeaseManager pausableLeaseManager = this;
            synchronized (pausableLeaseManager) {
                try {
                    LOG.info("{} paused in stillInLeasePeriod()", (Object)this);
                    this.wait();
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted whilst paused");
                    Thread.currentThread().interrupt();
                }
            }
        }
        return super.stillInLeasePeriod();
    }

    public synchronized void pausedInTryToGetInitialLeasePeriod() {
        this.pausedInTryToGetInitialLeasePeriod = true;
        this.notifyAll();
    }

    public synchronized void pausedInTryToRenewLeasePeriod() {
        this.pausedInTryToRenewLeasePeriod = true;
        this.notifyAll();
    }

    public synchronized void pausedInStillInLeasePeriod() {
        this.pausedInStillInLeasePeriod = true;
        this.notifyAll();
    }

    public synchronized void resume() {
        this.pausedInTryToGetInitialLeasePeriod = false;
        this.pausedInTryToRenewLeasePeriod = false;
        this.pausedInStillInLeasePeriod = false;
        this.notifyAll();
    }
}

