/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.number;

import com.ibm.icu.impl.StandardPlural;
import com.ibm.icu.impl.number.AffixPatternProvider;
import com.ibm.icu.impl.number.AffixUtils;
import com.ibm.icu.impl.number.CustomSymbolCurrency;
import com.ibm.icu.impl.number.DecimalFormatProperties;
import com.ibm.icu.impl.number.MacroProps;
import com.ibm.icu.impl.number.MultiplierImpl;
import com.ibm.icu.impl.number.Padder;
import com.ibm.icu.impl.number.PatternStringParser;
import com.ibm.icu.impl.number.RoundingUtils;
import com.ibm.icu.number.CompactNotation;
import com.ibm.icu.number.CurrencyRounder;
import com.ibm.icu.number.FractionRounder;
import com.ibm.icu.number.Grouper;
import com.ibm.icu.number.IntegerWidth;
import com.ibm.icu.number.Notation;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.number.Rounder;
import com.ibm.icu.number.ScientificNotation;
import com.ibm.icu.number.UnlocalizedNumberFormatter;
import com.ibm.icu.text.CompactDecimalFormat;
import com.ibm.icu.text.CurrencyPluralInfo;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.math.MathContext;

final class NumberPropertyMapper {
    NumberPropertyMapper() {
    }

    public static UnlocalizedNumberFormatter create(DecimalFormatProperties properties, DecimalFormatSymbols symbols) {
        MacroProps macros = NumberPropertyMapper.oldToNew(properties, symbols, null);
        return (UnlocalizedNumberFormatter)NumberFormatter.with().macros(macros);
    }

    public static UnlocalizedNumberFormatter create(String pattern, DecimalFormatSymbols symbols) {
        DecimalFormatProperties properties = PatternStringParser.parseToProperties(pattern);
        return NumberPropertyMapper.create(properties, symbols);
    }

    public static MacroProps oldToNew(DecimalFormatProperties properties, DecimalFormatSymbols symbols, DecimalFormatProperties exportedProperties) {
        boolean explicitMinMaxSig;
        boolean explicitCurrencyUsage;
        MacroProps macros = new MacroProps();
        ULocale locale = symbols.getULocale();
        macros.symbols = symbols;
        macros.rules = properties.getPluralRules();
        AffixPatternProvider affixProvider = properties.getCurrencyPluralInfo() == null ? new PropertiesAffixPatternProvider(properties) : new CurrencyPluralInfoAffixProvider(properties.getCurrencyPluralInfo());
        macros.affixProvider = affixProvider;
        boolean useCurrency = properties.getCurrency() != null || properties.getCurrencyPluralInfo() != null || properties.getCurrencyUsage() != null || affixProvider.hasCurrencySign();
        Currency currency = CustomSymbolCurrency.resolve(properties.getCurrency(), locale, symbols);
        Currency.CurrencyUsage currencyUsage = properties.getCurrencyUsage();
        boolean bl = explicitCurrencyUsage = currencyUsage != null;
        if (!explicitCurrencyUsage) {
            currencyUsage = Currency.CurrencyUsage.STANDARD;
        }
        if (useCurrency) {
            macros.unit = currency;
        }
        int maxInt = properties.getMaximumIntegerDigits();
        int minInt = properties.getMinimumIntegerDigits();
        int maxFrac = properties.getMaximumFractionDigits();
        int minFrac = properties.getMinimumFractionDigits();
        int minSig = properties.getMinimumSignificantDigits();
        int maxSig = properties.getMaximumSignificantDigits();
        BigDecimal roundingIncrement = properties.getRoundingIncrement();
        MathContext mathContext = RoundingUtils.getMathContextOrUnlimited(properties);
        boolean explicitMinMaxFrac = minFrac != -1 || maxFrac != -1;
        boolean bl2 = explicitMinMaxSig = minSig != -1 || maxSig != -1;
        if (useCurrency) {
            if (minFrac == -1 && maxFrac == -1) {
                minFrac = currency.getDefaultFractionDigits(currencyUsage);
                maxFrac = currency.getDefaultFractionDigits(currencyUsage);
            } else if (minFrac == -1) {
                minFrac = Math.min(maxFrac, currency.getDefaultFractionDigits(currencyUsage));
            } else if (maxFrac == -1) {
                maxFrac = Math.max(minFrac, currency.getDefaultFractionDigits(currencyUsage));
            }
        }
        if (minInt == 0 && maxFrac != 0) {
            int n = minFrac = minFrac <= 0 ? 1 : minFrac;
            maxFrac = maxFrac < 0 ? Integer.MAX_VALUE : (maxFrac < minFrac ? minFrac : maxFrac);
            minInt = 0;
            maxInt = maxInt < 0 ? -1 : (maxInt > 100 ? -1 : maxInt);
        } else {
            int n = minFrac = minFrac < 0 ? 0 : minFrac;
            int n2 = maxFrac < 0 ? Integer.MAX_VALUE : (maxFrac = maxFrac < minFrac ? minFrac : maxFrac);
            int n3 = minInt <= 0 ? 1 : (minInt = minInt > 100 ? 1 : minInt);
            maxInt = maxInt < 0 ? -1 : (maxInt < minInt ? minInt : (maxInt > 100 ? -1 : maxInt));
        }
        Rounder rounding = null;
        if (explicitCurrencyUsage) {
            rounding = Rounder.constructCurrency(currencyUsage).withCurrency(currency);
        } else if (roundingIncrement != null) {
            rounding = Rounder.constructIncrement(roundingIncrement);
        } else if (explicitMinMaxSig) {
            int n = minSig < 1 ? 1 : (minSig = minSig > 100 ? 100 : minSig);
            maxSig = maxSig < 0 ? 100 : (maxSig < minSig ? minSig : (maxSig > 100 ? 100 : maxSig));
            rounding = Rounder.constructSignificant(minSig, maxSig);
        } else if (explicitMinMaxFrac) {
            rounding = Rounder.constructFraction(minFrac, maxFrac);
        } else if (useCurrency) {
            rounding = Rounder.constructCurrency(currencyUsage);
        }
        if (rounding != null) {
            macros.rounder = rounding = rounding.withMode(mathContext);
        }
        macros.integerWidth = IntegerWidth.zeroFillTo(minInt).truncateAt(maxInt);
        int grouping1 = properties.getGroupingSize();
        int grouping2 = properties.getSecondaryGroupingSize();
        int minGrouping = properties.getMinimumGroupingDigits();
        assert (grouping1 >= -2);
        grouping1 = grouping1 > 0 ? grouping1 : (grouping2 > 0 ? grouping2 : grouping1);
        grouping2 = grouping2 > 0 ? grouping2 : grouping1;
        macros.grouper = Grouper.getInstance((byte)grouping1, (byte)grouping2, minGrouping == 2);
        if (properties.getFormatWidth() != -1) {
            macros.padder = new Padder(properties.getPadString(), properties.getFormatWidth(), properties.getPadPosition());
        }
        macros.decimal = properties.getDecimalSeparatorAlwaysShown() ? NumberFormatter.DecimalSeparatorDisplay.ALWAYS : NumberFormatter.DecimalSeparatorDisplay.AUTO;
        NumberFormatter.SignDisplay signDisplay = macros.sign = properties.getSignAlwaysShown() ? NumberFormatter.SignDisplay.ALWAYS : NumberFormatter.SignDisplay.AUTO;
        if (properties.getMinimumExponentDigits() != -1) {
            if (maxInt > 8) {
                maxInt = minInt;
                macros.integerWidth = IntegerWidth.zeroFillTo(minInt).truncateAt(maxInt);
            } else if (maxInt > minInt && minInt > 1) {
                minInt = 1;
                macros.integerWidth = IntegerWidth.zeroFillTo(minInt).truncateAt(maxInt);
            }
            int engineering = maxInt < 0 ? -1 : maxInt;
            macros.notation = new ScientificNotation(engineering, engineering == minInt, properties.getMinimumExponentDigits(), properties.getExponentSignAlwaysShown() ? NumberFormatter.SignDisplay.ALWAYS : NumberFormatter.SignDisplay.AUTO);
            if (macros.rounder instanceof FractionRounder) {
                int minInt_ = properties.getMinimumIntegerDigits();
                int minFrac_ = properties.getMinimumFractionDigits();
                int maxFrac_ = properties.getMaximumFractionDigits();
                macros.rounder = minInt_ == 0 && maxFrac_ == 0 ? Rounder.constructInfinite().withMode(mathContext) : (minInt_ == 0 && minFrac_ == 0 ? Rounder.constructSignificant(1, maxFrac_ + 1).withMode(mathContext) : Rounder.constructSignificant(minInt_ + minFrac_, minInt_ + maxFrac_).withMode(mathContext));
            }
        }
        if (properties.getCompactStyle() != null) {
            macros.notation = properties.getCompactCustomData() != null ? new CompactNotation(properties.getCompactCustomData()) : (properties.getCompactStyle() == CompactDecimalFormat.CompactStyle.LONG ? Notation.compactLong() : Notation.compactShort());
            macros.affixProvider = null;
        }
        if (properties.getMagnitudeMultiplier() != 0) {
            macros.multiplier = new MultiplierImpl(properties.getMagnitudeMultiplier());
        } else if (properties.getMultiplier() != null) {
            macros.multiplier = new MultiplierImpl(properties.getMultiplier());
        }
        if (exportedProperties != null) {
            exportedProperties.setMathContext(mathContext);
            exportedProperties.setRoundingMode(mathContext.getRoundingMode());
            exportedProperties.setMinimumIntegerDigits(minInt);
            exportedProperties.setMaximumIntegerDigits(maxInt == -1 ? Integer.MAX_VALUE : maxInt);
            Rounder rounding_ = rounding instanceof CurrencyRounder ? ((CurrencyRounder)rounding).withCurrency(currency) : rounding;
            int minFrac_ = minFrac;
            int maxFrac_ = maxFrac;
            int minSig_ = minSig;
            int maxSig_ = maxSig;
            BigDecimal increment_ = null;
            if (rounding_ instanceof Rounder.FractionRounderImpl) {
                minFrac_ = ((Rounder.FractionRounderImpl)rounding_).minFrac;
                maxFrac_ = ((Rounder.FractionRounderImpl)rounding_).maxFrac;
            } else if (rounding_ instanceof Rounder.IncrementRounderImpl) {
                increment_ = ((Rounder.IncrementRounderImpl)rounding_).increment;
                minFrac_ = increment_.scale();
                maxFrac_ = increment_.scale();
            } else if (rounding_ instanceof Rounder.SignificantRounderImpl) {
                minSig_ = ((Rounder.SignificantRounderImpl)rounding_).minSig;
                maxSig_ = ((Rounder.SignificantRounderImpl)rounding_).maxSig;
            }
            exportedProperties.setMinimumFractionDigits(minFrac_);
            exportedProperties.setMaximumFractionDigits(maxFrac_);
            exportedProperties.setMinimumSignificantDigits(minSig_);
            exportedProperties.setMaximumSignificantDigits(maxSig_);
            exportedProperties.setRoundingIncrement(increment_);
        }
        return macros;
    }

    private static class CurrencyPluralInfoAffixProvider
    implements AffixPatternProvider {
        private final AffixPatternProvider[] affixesByPlural = new PatternStringParser.ParsedPatternInfo[StandardPlural.COUNT];

        public CurrencyPluralInfoAffixProvider(CurrencyPluralInfo cpi) {
            for (StandardPlural plural : StandardPlural.VALUES) {
                this.affixesByPlural[plural.ordinal()] = PatternStringParser.parseToPatternInfo(cpi.getCurrencyPluralPattern(plural.getKeyword()));
            }
        }

        @Override
        public char charAt(int flags, int i) {
            int pluralOrdinal = flags & 0xFF;
            return this.affixesByPlural[pluralOrdinal].charAt(flags, i);
        }

        @Override
        public int length(int flags) {
            int pluralOrdinal = flags & 0xFF;
            return this.affixesByPlural[pluralOrdinal].length(flags);
        }

        @Override
        public boolean positiveHasPlusSign() {
            return this.affixesByPlural[StandardPlural.OTHER.ordinal()].positiveHasPlusSign();
        }

        @Override
        public boolean hasNegativeSubpattern() {
            return this.affixesByPlural[StandardPlural.OTHER.ordinal()].hasNegativeSubpattern();
        }

        @Override
        public boolean negativeHasMinusSign() {
            return this.affixesByPlural[StandardPlural.OTHER.ordinal()].negativeHasMinusSign();
        }

        @Override
        public boolean hasCurrencySign() {
            return this.affixesByPlural[StandardPlural.OTHER.ordinal()].hasCurrencySign();
        }

        @Override
        public boolean containsSymbolType(int type) {
            return this.affixesByPlural[StandardPlural.OTHER.ordinal()].containsSymbolType(type);
        }
    }

    private static class PropertiesAffixPatternProvider
    implements AffixPatternProvider {
        private final String posPrefix;
        private final String posSuffix;
        private final String negPrefix;
        private final String negSuffix;

        public PropertiesAffixPatternProvider(DecimalFormatProperties properties) {
            String ppo = AffixUtils.escape(properties.getPositivePrefix());
            String pso = AffixUtils.escape(properties.getPositiveSuffix());
            String npo = AffixUtils.escape(properties.getNegativePrefix());
            String nso = AffixUtils.escape(properties.getNegativeSuffix());
            String ppp = properties.getPositivePrefixPattern();
            String psp = properties.getPositiveSuffixPattern();
            String npp = properties.getNegativePrefixPattern();
            String nsp = properties.getNegativeSuffixPattern();
            this.posPrefix = ppo != null ? ppo : (ppp != null ? ppp : "");
            this.posSuffix = pso != null ? pso : (psp != null ? psp : "");
            if (npo != null) {
                this.negPrefix = npo;
            } else if (npp != null) {
                this.negPrefix = npp;
            } else {
                String string = this.negPrefix = ppp == null ? "-" : "-" + ppp;
            }
            this.negSuffix = nso != null ? nso : (nsp != null ? nsp : (psp == null ? "" : psp));
        }

        @Override
        public char charAt(int flags, int i) {
            return this.getStringForFlags(flags).charAt(i);
        }

        @Override
        public int length(int flags) {
            return this.getStringForFlags(flags).length();
        }

        private String getStringForFlags(int flags) {
            boolean negative;
            boolean prefix = (flags & 0x100) != 0;
            boolean bl = negative = (flags & 0x200) != 0;
            if (prefix && negative) {
                return this.negPrefix;
            }
            if (prefix) {
                return this.posPrefix;
            }
            if (negative) {
                return this.negSuffix;
            }
            return this.posSuffix;
        }

        @Override
        public boolean positiveHasPlusSign() {
            return AffixUtils.containsType(this.posPrefix, -2) || AffixUtils.containsType(this.posSuffix, -2);
        }

        @Override
        public boolean hasNegativeSubpattern() {
            return true;
        }

        @Override
        public boolean negativeHasMinusSign() {
            return AffixUtils.containsType(this.negPrefix, -1) || AffixUtils.containsType(this.negSuffix, -1);
        }

        @Override
        public boolean hasCurrencySign() {
            return AffixUtils.hasCurrencySymbols(this.posPrefix) || AffixUtils.hasCurrencySymbols(this.posSuffix) || AffixUtils.hasCurrencySymbols(this.negPrefix) || AffixUtils.hasCurrencySymbols(this.negSuffix);
        }

        @Override
        public boolean containsSymbolType(int type) {
            return AffixUtils.containsType(this.posPrefix, type) || AffixUtils.containsType(this.posSuffix, type) || AffixUtils.containsType(this.negPrefix, type) || AffixUtils.containsType(this.negSuffix, type);
        }
    }
}

