/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.paimon.flink.sink;

import javax.annotation.Nullable;

import java.util.List;

/**
 * A {@link StoreSinkWriteState} which stores nothing. Currently only used for append only unaware
 * bucket table writers.
 */
public class NoopStoreSinkWriteState implements StoreSinkWriteState {

    private final StateValueFilter stateValueFilter;

    public NoopStoreSinkWriteState(StateValueFilter stateValueFilter) {
        this.stateValueFilter = stateValueFilter;
    }

    @Override
    public StateValueFilter stateValueFilter() {
        return stateValueFilter;
    }

    @Override
    public @Nullable List<StateValue> get(String tableName, String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(String tableName, String key, List<StateValue> stateValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void snapshotState() throws Exception {}
}
