/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.webbeans.test.interceptors.business.common;

import org.apache.webbeans.test.component.intercept.webbeans.bindings.Secure;

import javax.enterprise.context.RequestScoped;

/**
 * This class extends a bean with intercepted methods.
 */
@RequestScoped
public class TransactionalChildBean extends TransactionalBaseBean
{

    /**
     * calling this method from outside should also trigger the Secure interceptor
     */
    @Secure
    public String doHalf()
    {
        return "21";
    }

    public int methodWithVarAargs(String... strings)
    {
        return strings.length;
    }

}
