/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import opennlp.tools.ml.model.Event;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.AbstractEventStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.Span;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.AdditionalContextFeatureGenerator;
import opennlp.tools.util.featuregen.WindowFeatureGenerator;

public class NameFinderEventStream
extends AbstractEventStream<NameSample> {
    private final NameContextGenerator contextGenerator;
    private final AdditionalContextFeatureGenerator additionalContextFeatureGenerator = new AdditionalContextFeatureGenerator();
    private final SequenceCodec<String> codec;
    private final String defaultType;

    public NameFinderEventStream(ObjectStream<NameSample> dataStream, String type, NameContextGenerator contextGenerator, SequenceCodec<String> codec) {
        super(dataStream);
        this.codec = Objects.requireNonNullElseGet(codec, BioCodec::new);
        this.contextGenerator = contextGenerator;
        this.contextGenerator.addFeatureGenerator(new WindowFeatureGenerator((AdaptiveFeatureGenerator)this.additionalContextFeatureGenerator, 8, 8));
        this.defaultType = type;
    }

    @Deprecated(forRemoval=true)
    public static String[] generateOutcomes(Span[] names, String type, int length) {
        Object[] outcomes = new String[length];
        Arrays.fill(outcomes, "other");
        for (Span name : names) {
            outcomes[name.getStart()] = name.getType() == null ? type + "-start" : name.getType() + "-start";
            for (int i = name.getStart() + 1; i < name.getEnd(); ++i) {
                outcomes[i] = name.getType() == null ? type + "-cont" : name.getType() + "-cont";
            }
        }
        return outcomes;
    }

    public static List<Event> generateEvents(String[] sentence, String[] outcomes, NameContextGenerator cg) {
        ArrayList<Event> events = new ArrayList<Event>(outcomes.length);
        for (int i = 0; i < outcomes.length; ++i) {
            events.add(new Event(outcomes[i], cg.getContext(i, sentence, outcomes, null)));
        }
        cg.updateAdaptiveData(sentence, outcomes);
        return events;
    }

    @Override
    protected Iterator<Event> createEvents(NameSample sample) {
        if (sample.isClearAdaptiveDataSet()) {
            this.contextGenerator.clearAdaptiveData();
        }
        Span[] names = sample.getNames();
        if (!Objects.isNull(this.defaultType)) {
            this.overrideType(names);
        }
        String[] outcomes = this.codec.encode(names, sample.getSentence().length);
        this.additionalContextFeatureGenerator.setCurrentContext(sample.getAdditionalContext());
        String[] tokens = new String[sample.getSentence().length];
        for (int i = 0; i < sample.getSentence().length; ++i) {
            tokens[i] = sample.getSentence()[i];
        }
        return NameFinderEventStream.generateEvents(tokens, outcomes, this.contextGenerator).iterator();
    }

    private void overrideType(Span[] names) {
        for (int i = 0; i < names.length; ++i) {
            Span n = names[i];
            names[i] = new Span(n.getStart(), n.getEnd(), this.defaultType, n.getProb());
        }
    }

    public static String[][] additionalContext(String[] tokens, Map<String, String> prevMap) {
        String[][] ac = new String[tokens.length][1];
        for (int ti = 0; ti < tokens.length; ++ti) {
            String pt = prevMap.get(tokens[ti]);
            ac[ti][0] = "pd=" + pt;
        }
        return ac;
    }
}

