/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.IOException;
import opennlp.tools.commons.ThreadSafe;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.Probabilistic;
import opennlp.tools.models.ModelType;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.DownloadUtil;
import opennlp.tools.util.Span;

@ThreadSafe
public class ThreadSafeTokenizerME
implements Tokenizer,
Probabilistic,
AutoCloseable {
    private final TokenizerModel model;
    private final Dictionary abbDict;
    private final ThreadLocal<TokenizerME> threadLocal = new ThreadLocal();

    public ThreadSafeTokenizerME(String language) throws IOException {
        this(DownloadUtil.downloadModel(language, ModelType.TOKENIZER, TokenizerModel.class));
    }

    public ThreadSafeTokenizerME(TokenizerModel model) {
        this(model, model.getAbbreviations());
    }

    public ThreadSafeTokenizerME(TokenizerModel model, Dictionary abbDict) {
        this.model = model;
        this.abbDict = abbDict;
    }

    private TokenizerME getTokenizer() {
        TokenizerME tokenizer = this.threadLocal.get();
        if (tokenizer == null) {
            tokenizer = new TokenizerME(this.model, this.abbDict);
            this.threadLocal.set(tokenizer);
        }
        return tokenizer;
    }

    @Override
    public String[] tokenize(String s) {
        return this.getTokenizer().tokenize(s);
    }

    @Override
    public Span[] tokenizePos(String s) {
        return this.getTokenizer().tokenizePos(s);
    }

    @Override
    public double[] probs() {
        return this.getTokenizer().probs();
    }

    @Deprecated(forRemoval=true, since="2.5.5")
    public double[] getProbabilities() {
        return this.probs();
    }

    @Override
    public void close() {
        this.threadLocal.remove();
    }
}

