/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.ValidationException;
import org.apache.bval.jsr.ConstraintValidation;
import org.apache.bval.jsr.GroupValidationContext;
import org.apache.bval.jsr.NodeBuilderCustomizableContextImpl;
import org.apache.bval.jsr.util.LeafNodeBuilderCustomizableContextImpl;
import org.apache.bval.jsr.util.NodeBuilderDefinedContextImpl;
import org.apache.bval.jsr.util.NodeImpl;
import org.apache.bval.jsr.util.PathImpl;
import org.apache.bval.model.ValidationListener;

public class ConstraintValidatorContextImpl
implements ConstraintValidatorContext {
    private final List<ValidationListener.Error> errorMessages = new LinkedList<ValidationListener.Error>();
    private final ConstraintValidation<?> constraintDescriptor;
    private final GroupValidationContext<?> validationContext;
    private boolean defaultDisabled;

    public ConstraintValidatorContextImpl(GroupValidationContext<?> validationContext, ConstraintValidation<?> aConstraintValidation) {
        this.validationContext = validationContext;
        this.constraintDescriptor = aConstraintValidation;
    }

    @Override
    public void disableDefaultConstraintViolation() {
        this.defaultDisabled = true;
    }

    @Override
    public String getDefaultConstraintMessageTemplate() {
        return this.constraintDescriptor.getMessageTemplate();
    }

    @Override
    public ConstraintValidatorContext.ConstraintViolationBuilder buildConstraintViolationWithTemplate(String messageTemplate) {
        return new ConstraintViolationBuilderImpl(this, messageTemplate, this.validationContext.getPropertyPath());
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        throw new ValidationException("Type " + type + " not supported");
    }

    public List<ValidationListener.Error> getErrorMessages() {
        if (this.defaultDisabled && this.errorMessages.isEmpty()) {
            throw new ValidationException("At least one custom message must be created if the default error message gets disabled.");
        }
        ArrayList<ValidationListener.Error> returnedErrorMessages = new ArrayList<ValidationListener.Error>(this.errorMessages);
        if (!this.defaultDisabled) {
            returnedErrorMessages.add(new ValidationListener.Error(this.getDefaultConstraintMessageTemplate(), this.validationContext.getPropertyPath(), null));
        }
        return returnedErrorMessages;
    }

    public GroupValidationContext<?> getValidationContext() {
        return this.validationContext;
    }

    public void addError(String messageTemplate, Path propertyPath) {
        this.errorMessages.add(new ValidationListener.Error(messageTemplate, propertyPath, null));
    }

    private static final class ConstraintViolationBuilderImpl
    implements ConstraintValidatorContext.ConstraintViolationBuilder {
        private final ConstraintValidatorContextImpl parent;
        private final String messageTemplate;
        private final PathImpl propertyPath;

        ConstraintViolationBuilderImpl(ConstraintValidatorContextImpl contextImpl, String template, PathImpl path) {
            this.parent = contextImpl;
            this.messageTemplate = template;
            this.propertyPath = path;
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addNode(String name) {
            PathImpl path;
            if (this.propertyPath.isRootPath()) {
                path = PathImpl.create();
                path.getLeafNode().setName(name);
            } else {
                path = PathImpl.copy(this.propertyPath);
                path.addNode(new NodeImpl(name));
            }
            return new NodeBuilderDefinedContextImpl(this.parent, this.messageTemplate, path);
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(String name) {
            NodeImpl node;
            if (!this.propertyPath.isRootPath()) {
                if (this.propertyPath.getLeafNode().getKind() != null) {
                    node = new NodeImpl.PropertyNodeImpl(name);
                    this.propertyPath.addNode(node);
                } else {
                    node = this.propertyPath.getLeafNode();
                }
            } else {
                node = new NodeImpl.PropertyNodeImpl(name);
                this.propertyPath.addNode(node);
            }
            node.setName(name);
            node.setKind(ElementKind.PROPERTY);
            return new NodeBuilderCustomizableContextImpl(this.parent, this.messageTemplate, this.propertyPath);
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext addBeanNode() {
            NodeImpl.BeanNodeImpl node = new NodeImpl.BeanNodeImpl();
            node.setKind(ElementKind.BEAN);
            this.propertyPath.addNode(node);
            return new LeafNodeBuilderCustomizableContextImpl(this.parent, this.messageTemplate, this.propertyPath);
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addParameterNode(int index) {
            Method method = this.parent.validationContext.getMethod();
            List<String> parameters = this.parent.validationContext.getParameterNameProvider().getParameterNames(method);
            NodeImpl.ParameterNodeImpl node = new NodeImpl.ParameterNodeImpl(parameters.get(index), index);
            node.setParameterIndex(index);
            node.setKind(ElementKind.PARAMETER);
            if (!this.propertyPath.isRootPath()) {
                this.propertyPath.removeLeafNode();
            }
            this.propertyPath.addNode(node);
            return new NodeBuilderDefinedContextImpl(this.parent, this.messageTemplate, this.propertyPath);
        }

        @Override
        public ConstraintValidatorContext addConstraintViolation() {
            this.parent.addError(this.messageTemplate, this.propertyPath);
            return this.parent;
        }
    }
}

