/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.domain;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.domain.AbstractClientPayload;
import org.apache.olingo.client.api.domain.ClientAnnotation;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientLink;
import org.apache.olingo.client.api.domain.ClientOperation;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.domain.ClientSingleton;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public class ClientEntityImpl
extends AbstractClientPayload
implements ClientEntity,
ClientSingleton {
    private URI id;
    private String eTag;
    private boolean mediaEntity = false;
    private String mediaContentType;
    private URI mediaContentSource;
    private String mediaETag;
    private URI editLink;
    private final List<ClientProperty> properties = new ArrayList<ClientProperty>();
    private final List<ClientAnnotation> annotations = new ArrayList<ClientAnnotation>();
    private final FullQualifiedName typeName;
    private final List<ClientLink> navigationLinks = new ArrayList<ClientLink>();
    private final List<ClientLink> associationLinks = new ArrayList<ClientLink>();
    private final List<ClientLink> mediaEditLinks = new ArrayList<ClientLink>();
    private final List<ClientOperation> operations = new ArrayList<ClientOperation>();

    public ClientEntityImpl(FullQualifiedName typeName) {
        super(typeName == null ? null : typeName.toString());
        this.typeName = typeName;
    }

    public FullQualifiedName getTypeName() {
        return this.typeName;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public ClientOperation getOperation(String title) {
        ClientOperation result = null;
        for (ClientOperation operation : this.operations) {
            if (!title.equals(operation.getTitle())) continue;
            result = operation;
            break;
        }
        return result;
    }

    public List<ClientOperation> getOperations() {
        return this.operations;
    }

    public ClientProperty getProperty(String name) {
        ClientProperty result = null;
        if (StringUtils.isNotBlank((CharSequence)name)) {
            for (ClientProperty property : this.getProperties()) {
                if (!name.equals(property.getName())) continue;
                result = property;
                break;
            }
        }
        return result;
    }

    public boolean addLink(ClientLink link) {
        boolean result = false;
        switch (link.getType()) {
            case ASSOCIATION: {
                result = this.associationLinks.contains(link) ? false : this.associationLinks.add(link);
                break;
            }
            case ENTITY_NAVIGATION: 
            case ENTITY_SET_NAVIGATION: {
                result = this.navigationLinks.contains(link) ? false : this.navigationLinks.add(link);
                break;
            }
            case MEDIA_EDIT: 
            case MEDIA_READ: {
                result = this.mediaEditLinks.contains(link) ? false : this.mediaEditLinks.add(link);
                break;
            }
        }
        return result;
    }

    public boolean removeLink(ClientLink link) {
        return this.associationLinks.remove(link) || this.navigationLinks.remove(link);
    }

    private ClientLink getLink(List<ClientLink> links, String name) {
        ClientLink result = null;
        for (ClientLink link : links) {
            if (!name.equals(link.getName())) continue;
            result = link;
            break;
        }
        return result;
    }

    public ClientLink getNavigationLink(String name) {
        return this.getLink(this.navigationLinks, name);
    }

    public List<ClientLink> getNavigationLinks() {
        return this.navigationLinks;
    }

    public ClientLink getAssociationLink(String name) {
        return this.getLink(this.associationLinks, name);
    }

    public List<ClientLink> getAssociationLinks() {
        return this.associationLinks;
    }

    public ClientLink getMediaEditLink(String name) {
        return this.getLink(this.mediaEditLinks, name);
    }

    public List<ClientLink> getMediaEditLinks() {
        return this.mediaEditLinks;
    }

    public URI getEditLink() {
        return this.editLink;
    }

    public void setEditLink(URI editLink) {
        this.editLink = editLink;
    }

    public URI getLink() {
        return super.getLink() == null ? this.getEditLink() : super.getLink();
    }

    public boolean isReadOnly() {
        return super.getLink() != null;
    }

    public boolean isMediaEntity() {
        return this.mediaEntity;
    }

    public void setMediaEntity(boolean isMediaEntity) {
        this.mediaEntity = isMediaEntity;
    }

    public String getMediaContentType() {
        return this.mediaContentType;
    }

    public void setMediaContentType(String mediaContentType) {
        this.mediaContentType = mediaContentType;
    }

    public URI getMediaContentSource() {
        return this.mediaContentSource;
    }

    public void setMediaContentSource(URI mediaContentSource) {
        this.mediaContentSource = mediaContentSource;
    }

    public String getMediaETag() {
        return this.mediaETag;
    }

    public void setMediaETag(String eTag) {
        this.mediaETag = eTag;
    }

    public URI getId() {
        return this.id;
    }

    public void setId(URI id) {
        this.id = id;
    }

    public List<ClientProperty> getProperties() {
        return this.properties;
    }

    public List<ClientAnnotation> getAnnotations() {
        return this.annotations;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        result = 31 * result + (this.associationLinks == null ? 0 : this.associationLinks.hashCode());
        result = 31 * result + (this.eTag == null ? 0 : this.eTag.hashCode());
        result = 31 * result + (this.editLink == null ? 0 : this.editLink.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.mediaContentSource == null ? 0 : this.mediaContentSource.hashCode());
        result = 31 * result + (this.mediaContentType == null ? 0 : this.mediaContentType.hashCode());
        result = 31 * result + (this.mediaETag == null ? 0 : this.mediaETag.hashCode());
        result = 31 * result + (this.mediaEditLinks == null ? 0 : this.mediaEditLinks.hashCode());
        result = 31 * result + (this.mediaEntity ? 1231 : 1237);
        result = 31 * result + (this.navigationLinks == null ? 0 : this.navigationLinks.hashCode());
        result = 31 * result + (this.operations == null ? 0 : this.operations.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ClientEntityImpl)) {
            return false;
        }
        ClientEntityImpl other = (ClientEntityImpl)((Object)obj);
        if (this.annotations == null ? other.annotations != null : !this.annotations.equals(other.annotations)) {
            return false;
        }
        if (this.associationLinks == null ? other.associationLinks != null : !this.associationLinks.equals(other.associationLinks)) {
            return false;
        }
        if (this.eTag == null ? other.eTag != null : !this.eTag.equals(other.eTag)) {
            return false;
        }
        if (this.editLink == null ? other.editLink != null : !this.editLink.equals(other.editLink)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.mediaContentSource == null ? other.mediaContentSource != null : !this.mediaContentSource.equals(other.mediaContentSource)) {
            return false;
        }
        if (this.mediaContentType == null ? other.mediaContentType != null : !this.mediaContentType.equals(other.mediaContentType)) {
            return false;
        }
        if (this.mediaETag == null ? other.mediaETag != null : !this.mediaETag.equals(other.mediaETag)) {
            return false;
        }
        if (this.mediaEditLinks == null ? other.mediaEditLinks != null : !this.mediaEditLinks.equals(other.mediaEditLinks)) {
            return false;
        }
        if (this.mediaEntity != other.mediaEntity) {
            return false;
        }
        if (this.navigationLinks == null ? other.navigationLinks != null : !this.navigationLinks.equals(other.navigationLinks)) {
            return false;
        }
        if (this.operations == null ? other.operations != null : !this.operations.equals(other.operations)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return !(this.typeName == null ? other.typeName != null : !this.typeName.equals((Object)other.typeName));
    }

    public String toString() {
        return "ClientEntityImpl [id=" + this.id + ", eTag=" + this.eTag + ", mediaEntity=" + this.mediaEntity + ", mediaContentType=" + this.mediaContentType + ", mediaContentSource=" + this.mediaContentSource + ", mediaETag=" + this.mediaETag + ", editLink=" + this.editLink + ", properties=" + this.properties + ", annotations=" + this.annotations + ", typeName=" + this.typeName + ", navigationLinks=" + this.navigationLinks + ", associationLinks=" + this.associationLinks + ", mediaEditLinks=" + this.mediaEditLinks + ", operations=" + this.operations + "super[" + super.toString() + "]]";
    }
}

