/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.core.serialization.ContextURLParser;
import org.apache.olingo.client.core.serialization.JsonDeserializer;
import org.apache.olingo.client.core.serialization.JsonEntityDeserializer;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.DeletedEntity;
import org.apache.olingo.commons.api.data.Delta;
import org.apache.olingo.commons.api.data.DeltaLink;
import org.apache.olingo.commons.api.data.Entity;

public class JsonDeltaDeserializer
extends JsonDeserializer {
    public JsonDeltaDeserializer(boolean serverMode) {
        super(serverMode);
    }

    protected ResWrap<Delta> doDeserialize(JsonParser parser) throws IOException {
        URI contextURL;
        ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
        Delta delta = new Delta();
        URI uRI = contextURL = tree.hasNonNull("@odata.context") ? URI.create(tree.get("@odata.context").textValue()) : null;
        if (contextURL != null) {
            delta.setBaseURI(URI.create(StringUtils.substringBefore((String)contextURL.toASCIIString(), (String)"$metadata")));
        }
        if (tree.hasNonNull("@odata.count")) {
            delta.setCount(Integer.valueOf(tree.get("@odata.count").asInt()));
        }
        if (tree.hasNonNull("@odata.nextLink")) {
            delta.setNext(URI.create(tree.get("@odata.nextLink").textValue()));
        }
        if (tree.hasNonNull("@odata.deltaLink")) {
            delta.setDeltaLink(URI.create(tree.get("@odata.deltaLink").textValue()));
        }
        if (tree.hasNonNull("value")) {
            JsonEntityDeserializer entityDeserializer = new JsonEntityDeserializer(this.serverMode);
            for (JsonNode jsonNode : tree.get("value")) {
                ObjectNode item = (ObjectNode)jsonNode;
                ContextURL itemContextURL = item.hasNonNull("@odata.context") ? ContextURLParser.parse(URI.create(item.get("@odata.context").textValue())) : null;
                item.remove("@odata.context");
                if (itemContextURL == null || itemContextURL.isEntity()) {
                    delta.getEntities().add((Entity)entityDeserializer.doDeserialize(item.traverse(parser.getCodec())).getPayload());
                    continue;
                }
                if (itemContextURL.isDeltaDeletedEntity()) {
                    delta.getDeletedEntities().add((DeletedEntity)parser.getCodec().treeToValue((TreeNode)item, DeletedEntity.class));
                    continue;
                }
                if (itemContextURL.isDeltaLink()) {
                    delta.getAddedLinks().add((DeltaLink)parser.getCodec().treeToValue((TreeNode)item, DeltaLink.class));
                    continue;
                }
                if (!itemContextURL.isDeltaDeletedLink()) continue;
                delta.getDeletedLinks().add((DeltaLink)parser.getCodec().treeToValue((TreeNode)item, DeltaLink.class));
            }
        }
        return new ResWrap(contextURL, null, (Object)delta);
    }

    public ResWrap<Delta> toDelta(InputStream input) throws ODataDeserializerException {
        try {
            JsonParser parser = new JsonFactory((ObjectCodec)new ObjectMapper()).createParser(input);
            return this.doDeserialize(parser);
        }
        catch (IOException e) {
            throw new ODataDeserializerException((Throwable)e);
        }
    }
}

