/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataProcessor;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATransaction;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAPaging;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmExtension;
import org.apache.olingo.odata2.jpa.processor.core.ODataJPATransactionContainerManaged;
import org.apache.olingo.odata2.jpa.processor.core.ODataJPATransactionLocalDefault;

public class ODataJPAContextImpl
implements ODataJPAContext {
    private String pUnitName;
    private EntityManagerFactory emf;
    private static final ThreadLocal<EntityManager> emThreadLocal = new ThreadLocal();
    private ODataContext odataContext;
    private ODataProcessor processor;
    private EdmProvider edmProvider;
    private String jpaEdmMappingModelName;
    private JPAEdmExtension jpaEdmExtension;
    private int pageSize = 0;
    private JPAPaging jpaPaging;
    private static final ThreadLocal<ODataContext> oDataContextThreadLocal = new ThreadLocal();
    private boolean defaultNaming = true;
    private ODataJPATransaction transaction = null;
    private boolean containerManaged = false;

    public String getPersistenceUnitName() {
        return this.pUnitName;
    }

    public void setPersistenceUnitName(String pUnitName) {
        this.pUnitName = pUnitName;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public void setODataContext(ODataContext ctx) {
        this.odataContext = ctx;
        ODataJPAContextImpl.setContextInThreadLocal(this.odataContext);
    }

    public ODataContext getODataContext() {
        return this.odataContext;
    }

    public void setODataProcessor(ODataProcessor processor) {
        this.processor = processor;
    }

    public ODataProcessor getODataProcessor() {
        return this.processor;
    }

    public void setEdmProvider(EdmProvider edmProvider) {
        this.edmProvider = edmProvider;
    }

    public EdmProvider getEdmProvider() {
        return this.edmProvider;
    }

    public void setJPAEdmMappingModel(String name) {
        this.jpaEdmMappingModelName = name;
    }

    public String getJPAEdmMappingModel() {
        return this.jpaEdmMappingModelName;
    }

    public static void setContextInThreadLocal(ODataContext ctx) {
        oDataContextThreadLocal.set(ctx);
    }

    public static void unsetContextInThreadLocal() {
        oDataContextThreadLocal.remove();
    }

    public static ODataContext getContextInThreadLocal() {
        return oDataContextThreadLocal.get();
    }

    public EntityManager getEntityManager() {
        EntityManager em = emThreadLocal.get();
        if (em == null || !em.isOpen()) {
            em = this.emf.createEntityManager();
            this.setEntityManager(em);
        }
        return em;
    }

    public void setJPAEdmExtension(JPAEdmExtension jpaEdmExtension) {
        this.jpaEdmExtension = jpaEdmExtension;
    }

    public JPAEdmExtension getJPAEdmExtension() {
        return this.jpaEdmExtension;
    }

    public void setDefaultNaming(boolean defaultNaming) {
        this.defaultNaming = defaultNaming;
    }

    public boolean getDefaultNaming() {
        return this.defaultNaming;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int size) {
        this.pageSize = size;
    }

    public void setPaging(JPAPaging paging) {
        this.jpaPaging = paging;
    }

    public JPAPaging getPaging() {
        return this.jpaPaging;
    }

    public ODataJPATransaction getODataJPATransaction() {
        if (this.transaction == null) {
            this.transaction = (ODataJPATransaction)this.odataContext.getServiceFactory().getCallback(ODataJPATransaction.class);
            if (this.transaction == null) {
                this.transaction = this.isContainerManaged() ? new ODataJPATransactionContainerManaged() : new ODataJPATransactionLocalDefault(this.getEntityManager());
            }
        }
        return this.transaction;
    }

    public boolean isContainerManaged() {
        return this.containerManaged;
    }

    public void setContainerManaged(boolean containerManaged) {
        this.containerManaged = containerManaged;
    }

    public void setEntityManager(EntityManager em) {
        emThreadLocal.set(em);
    }
}

