/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionKind;
import org.apache.olingo.odata2.api.uri.expression.ExpressionVisitor;
import org.apache.olingo.odata2.api.uri.expression.PropertyExpression;

public class PropertyExpressionImpl
implements PropertyExpression {
    private String uriLiteral;
    private EdmType edmType;
    private EdmTyped edmProperty;
    private EdmLiteral edmLiteral;

    public PropertyExpressionImpl(String uriLiteral, EdmLiteral edmLiteral) {
        this.uriLiteral = uriLiteral;
        this.edmLiteral = edmLiteral;
        if (edmLiteral != null) {
            this.edmType = edmLiteral.getType();
        }
    }

    public CommonExpression setEdmProperty(EdmTyped edmProperty) {
        this.edmProperty = edmProperty;
        return this;
    }

    public CommonExpression setEdmType(EdmType edmType) {
        this.edmType = edmType;
        return this;
    }

    public String getPropertyName() {
        if (this.edmProperty == null) {
            return "";
        }
        try {
            return this.edmProperty.getName();
        }
        catch (EdmException e) {
            return "";
        }
    }

    public EdmLiteral getEdmLiteral() {
        return this.edmLiteral;
    }

    public EdmTyped getEdmProperty() {
        return this.edmProperty;
    }

    public ExpressionKind getKind() {
        return ExpressionKind.PROPERTY;
    }

    public String getUriLiteral() {
        return this.uriLiteral;
    }

    public EdmType getEdmType() {
        return this.edmType;
    }

    public Object accept(ExpressionVisitor visitor) {
        Object ret = visitor.visitProperty((PropertyExpression)this, this.uriLiteral, this.edmProperty);
        return ret;
    }
}

