/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm.provider;

import org.apache.olingo.odata2.api.edm.EdmAnnotatable;
import org.apache.olingo.odata2.api.edm.EdmAnnotations;
import org.apache.olingo.odata2.api.edm.EdmAssociation;
import org.apache.olingo.odata2.api.edm.EdmAssociationEnd;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmReferentialConstraint;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.edm.provider.Association;
import org.apache.olingo.odata2.api.edm.provider.AssociationEnd;
import org.apache.olingo.odata2.api.edm.provider.ReferentialConstraint;
import org.apache.olingo.odata2.core.edm.provider.EdmAnnotationsImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmAssociationEndImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmNamedImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmReferentialConstraintImplProv;

public class EdmAssociationImplProv
extends EdmNamedImplProv
implements EdmAssociation,
EdmAnnotatable {
    private Association association;
    private String namespace;
    private EdmAnnotations annotations;
    private EdmReferentialConstraintImplProv referentialConstraint;

    public EdmAssociationImplProv(EdmImplProv edm, Association association, String namespace) throws EdmException {
        super(edm, association.getName());
        this.association = association;
        this.namespace = namespace;
    }

    public String getNamespace() throws EdmException {
        return this.namespace;
    }

    public EdmTypeKind getKind() {
        return EdmTypeKind.ASSOCIATION;
    }

    public EdmAssociationEnd getEnd(String role) throws EdmException {
        AssociationEnd end = this.association.getEnd1();
        if (end.getRole().equals(role)) {
            return new EdmAssociationEndImplProv(this.edm, end);
        }
        end = this.association.getEnd2();
        if (end.getRole().equals(role)) {
            return new EdmAssociationEndImplProv(this.edm, end);
        }
        return null;
    }

    public EdmAnnotations getAnnotations() throws EdmException {
        if (this.annotations == null) {
            this.annotations = new EdmAnnotationsImplProv(this.association.getAnnotationAttributes(), this.association.getAnnotationElements());
        }
        return this.annotations;
    }

    public EdmMultiplicity getEndMultiplicity(String role) {
        if (this.association.getEnd1().getRole().equals(role)) {
            return this.association.getEnd1().getMultiplicity();
        }
        if (this.association.getEnd2().getRole().equals(role)) {
            return this.association.getEnd2().getMultiplicity();
        }
        return null;
    }

    public EdmAssociationEnd getEnd1() throws EdmException {
        AssociationEnd end = this.association.getEnd1();
        return new EdmAssociationEndImplProv(this.edm, end);
    }

    public EdmAssociationEnd getEnd2() throws EdmException {
        AssociationEnd end = this.association.getEnd2();
        return new EdmAssociationEndImplProv(this.edm, end);
    }

    public EdmReferentialConstraint getReferentialConstraint() throws EdmException {
        ReferentialConstraint refConstraint;
        if (this.referentialConstraint == null && (refConstraint = this.association.getReferentialConstraint()) != null) {
            this.referentialConstraint = new EdmReferentialConstraintImplProv(refConstraint);
        }
        return this.referentialConstraint;
    }
}

