/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.provider.DataServices;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.Property;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.core.commons.XmlHelper;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.producer.XmlMetadataProducer;
import org.apache.olingo.odata2.core.ep.util.CircleStreamBuffer;

public class BasicEntityProvider {
    private static final String DEFAULT_CHARSET = "utf-8";

    public byte[] readBinary(InputStream content) throws EntityProviderException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] value = new byte[Short.MAX_VALUE];
        try {
            int count;
            while ((count = content.read(value)) > 0) {
                buffer.write(value, 0, count);
            }
            content.close();
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }

    public String readText(InputStream content) throws EntityProviderException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(content, Charset.forName(DEFAULT_CHARSET)));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
        return stringBuilder.toString();
    }

    public Object readPropertyValue(EdmProperty edmProperty, InputStream content, Class<?> typeMapping) throws EntityProviderException {
        EdmSimpleType type;
        try {
            type = (EdmSimpleType)edmProperty.getType();
        }
        catch (EdmException e) {
            throw new EntityProviderException(e.getMessageReference(), (Throwable)e);
        }
        if (type == EdmSimpleTypeKind.Binary.getEdmSimpleTypeInstance()) {
            return this.readBinary(content);
        }
        try {
            if (typeMapping == null) {
                return type.valueOfString(this.readText(content), EdmLiteralKind.DEFAULT, edmProperty.getFacets(), type.getDefaultType());
            }
            return type.valueOfString(this.readText(content), EdmLiteralKind.DEFAULT, edmProperty.getFacets(), typeMapping);
        }
        catch (EdmException e) {
            throw new EntityProviderException(e.getMessageReference(), (Throwable)e);
        }
    }

    public ODataResponse writePropertyValue(EdmProperty edmProperty, Object value) throws EntityProviderException {
        try {
            EdmSimpleType type = (EdmSimpleType)edmProperty.getType();
            if (type == EdmSimpleTypeKind.Binary.getEdmSimpleTypeInstance()) {
                String contentType = "application/octet-stream";
                Object binary = value;
                if (edmProperty.getMimeType() != null) {
                    contentType = edmProperty.getMimeType();
                } else if (edmProperty.getMapping() != null && edmProperty.getMapping().getMediaResourceMimeTypeKey() != null) {
                    String mimeTypeMapping = edmProperty.getMapping().getMediaResourceMimeTypeKey();
                    if (value instanceof Map) {
                        Map mappedData = (Map)value;
                        binary = mappedData.get(edmProperty.getName());
                        contentType = (String)mappedData.get(mimeTypeMapping);
                    } else {
                        throw new EntityProviderException(EntityProviderException.COMMON);
                    }
                }
                return this.writeBinary(contentType, (byte[])binary);
            }
            try {
                return this.writeText(type.valueToString(value, EdmLiteralKind.DEFAULT, edmProperty.getFacets()));
            }
            catch (EdmSimpleTypeException e) {
                throw new EntityProviderProducerException(EdmSimpleTypeException.getMessageReference((MessageReference)e.getMessageReference()).updateContent(e.getMessageReference().getContent(), new Object[]{edmProperty.getName()}), e);
            }
        }
        catch (EdmException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), e);
        }
    }

    public ODataResponse writeText(String value) throws EntityProviderException {
        ODataResponse.ODataResponseBuilder builder = ODataResponse.newBuilder();
        if (value != null) {
            ByteArrayInputStream stream;
            try {
                stream = new ByteArrayInputStream(value.getBytes(DEFAULT_CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), e);
            }
            builder.entity((Object)stream);
        }
        return builder.build();
    }

    public ODataResponse writeBinary(String mimeType, byte[] data) throws EntityProviderException {
        ODataResponse.ODataResponseBuilder builder = ODataResponse.newBuilder();
        if (data != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            builder.contentHeader(mimeType);
            builder.entity((Object)bais);
        } else {
            builder.status(HttpStatusCodes.NO_CONTENT);
        }
        return builder.build();
    }

    public ODataResponse writeMetadata(List<Schema> schemas, Map<String, String> predefinedNamespaces) throws EntityProviderException {
        String dataServiceVersion = "1.0";
        if (schemas != null) {
            dataServiceVersion = this.calculateDataServiceVersion(schemas);
        }
        DataServices metadata = new DataServices().setSchemas(schemas).setDataServiceVersion(dataServiceVersion);
        return this.writeMetadataInternal(predefinedNamespaces, dataServiceVersion, metadata);
    }

    private ODataResponse writeMetadataInternal(Map<String, String> predefinedNamespaces, String dataServiceVersion, DataServices metadata) throws EntityProviderException, EntityProviderProducerException {
        ODataResponse.ODataResponseBuilder builder = ODataResponse.newBuilder();
        OutputStreamWriter writer = null;
        CircleStreamBuffer csb = new CircleStreamBuffer();
        try {
            writer = new OutputStreamWriter(csb.getOutputStream(), DEFAULT_CHARSET);
            XMLStreamWriter xmlStreamWriter = XmlHelper.getXMLOutputFactory().createXMLStreamWriter(writer);
            XmlMetadataProducer.writeMetadata(metadata, xmlStreamWriter, predefinedNamespaces);
        }
        catch (UnsupportedEncodingException e) {
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), e);
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), e);
        }
        catch (FactoryConfigurationError e) {
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), e);
        }
        builder.entity((Object)csb.getInputStream());
        builder.header("DataServiceVersion", dataServiceVersion);
        return builder.build();
    }

    public ODataResponse writeMetadata(DataServices serviceMetadata, Map<String, String> predefinedNamespaces) throws EntityProviderException {
        String dataServiceVersion = serviceMetadata.getDataServiceVersion() == null ? "2.0" : serviceMetadata.getDataServiceVersion();
        return this.writeMetadataInternal(predefinedNamespaces, dataServiceVersion, serviceMetadata);
    }

    private String calculateDataServiceVersion(List<Schema> schemas) {
        String dataServiceVersion = "1.0";
        if (schemas != null) {
            for (Schema schema : schemas) {
                List entityTypes = schema.getEntityTypes();
                if (entityTypes == null) continue;
                for (EntityType entityType : entityTypes) {
                    List properties = entityType.getProperties();
                    if (properties == null) continue;
                    for (Property property : properties) {
                        if (property.getCustomizableFeedMappings() == null || property.getCustomizableFeedMappings().getFcKeepInContent() == null || property.getCustomizableFeedMappings().getFcKeepInContent().booleanValue()) continue;
                        dataServiceVersion = "2.0";
                        return dataServiceVersion;
                    }
                    if (entityType.getCustomizableFeedMappings() == null || entityType.getCustomizableFeedMappings().getFcKeepInContent() == null || !entityType.getCustomizableFeedMappings().getFcKeepInContent().booleanValue()) continue;
                    dataServiceVersion = "2.0";
                    return dataServiceVersion;
                }
            }
        }
        return dataServiceVersion;
    }
}

