/****************************************************************************
 * arch/risc-v/src/rv32m1/hardware/rv32m1_pinmap.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_RISCV_SRC_RV32M1_HARDWARE_RV32M1_PINMAP_H
#define __ARCH_RISCV_SRC_RV32M1_HARDWARE_RV32M1_PINMAP_H

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/* LPUARTs */

#define GPIO_LPUART0_RX_1    (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTC|GPIO_PIN7)
#define GPIO_LPUART0_RX_2    (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN25)
#define GPIO_LPUART0_RX_3    (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTA|GPIO_PIN2)
#define GPIO_LPUART0_TX_1    (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTC|GPIO_PIN8)
#define GPIO_LPUART0_TX_2    (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN26)
#define GPIO_LPUART0_TX_3    (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTA|GPIO_PIN3)
#define GPIO_LPUART0_RTS_1   (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTC|GPIO_PIN10)
#define GPIO_LPUART0_RTS_2   (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN24)
#define GPIO_LPUART0_RTS_3   (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTA|GPIO_PIN4)
#define GPIO_LPUART0_CTS_1   (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTC|GPIO_PIN9)
#define GPIO_LPUART0_CTS_2   (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN22)
#define GPIO_LPUART0_CTS_3   (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTA|GPIO_PIN1)

#define GPIO_LPUART1_RX_1    (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN2)
#define GPIO_LPUART1_RX_2    (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTC|GPIO_PIN29)
#define GPIO_LPUART1_RX_3    (GPIO_ALT|GPIO_AF4|GPIO_PULLUP|GPIO_PORTA|GPIO_PIN2)
#define GPIO_LPUART1_RX_4    (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTA|GPIO_PIN25)
#define GPIO_LPUART1_TX_1    (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN3)
#define GPIO_LPUART1_TX_2    (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTC|GPIO_PIN30)
#define GPIO_LPUART1_TX_3    (GPIO_ALT|GPIO_AF4|GPIO_PULLUP|GPIO_PORTA|GPIO_PIN3)
#define GPIO_LPUART1_TX_4    (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTA|GPIO_PIN26)
#define GPIO_LPUART1_RTS_1   (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN5)
#define GPIO_LPUART1_RTS_2   (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTD|GPIO_PIN1)
#define GPIO_LPUART1_RTS_3   (GPIO_ALT|GPIO_AF4|GPIO_PULLUP|GPIO_PORTA|GPIO_PIN4)
#define GPIO_LPUART1_RTS_4   (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTA|GPIO_PIN28)
#define GPIO_LPUART1_CTS_1   (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN4)
#define GPIO_LPUART1_CTS_2   (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTD|GPIO_PIN0)
#define GPIO_LPUART1_CTS_3   (GPIO_ALT|GPIO_AF4|GPIO_PULLUP|GPIO_PORTA|GPIO_PIN1)
#define GPIO_LPUART1_CTS_4   (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTA|GPIO_PIN27)

#define GPIO_LPUART2_RX_1    (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN11)
#define GPIO_LPUART2_RX_2    (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN18)
#define GPIO_LPUART2_RX_3    (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN1)
#define GPIO_LPUART2_TX_1    (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN12)
#define GPIO_LPUART2_TX_2    (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN19)
#define GPIO_LPUART2_TX_3    (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN0)
#define GPIO_LPUART2_RTS_1   (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN14)
#define GPIO_LPUART2_RTS_2   (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN21)
#define GPIO_LPUART2_RTS_3   (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTA|GPIO_PIN31)
#define GPIO_LPUART2_CTS_1   (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN13)
#define GPIO_LPUART2_CTS_2   (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN20)
#define GPIO_LPUART2_CTS_3   (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTA|GPIO_PIN30)

#define GPIO_LPUART3_RX_1    (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN28)
#define GPIO_LPUART3_RX_2    (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTE|GPIO_PIN8)
#define GPIO_LPUART3_RX_3    (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTE|GPIO_PIN29)
#define GPIO_LPUART3_TX_1    (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN29)
#define GPIO_LPUART3_TX_2    (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTE|GPIO_PIN9)
#define GPIO_LPUART3_TX_3    (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTE|GPIO_PIN30)
#define GPIO_LPUART3_RTS_1   (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN17)
#define GPIO_LPUART3_RTS_2   (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTE|GPIO_PIN11)
#define GPIO_LPUART3_RTS_3   (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTE|GPIO_PIN28)
#define GPIO_LPUART3_CTS_1   (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTB|GPIO_PIN16)
#define GPIO_LPUART3_CTS_2   (GPIO_ALT|GPIO_AF3|GPIO_PULLUP|GPIO_PORTE|GPIO_PIN10)
#define GPIO_LPUART3_CTS_3   (GPIO_ALT|GPIO_AF2|GPIO_PULLUP|GPIO_PORTE|GPIO_PIN27)

#endif /* __ARCH_RISCV_SRC_RV32M1_HARDWARE_RV32M1_PINMAP_H */
