/****************************************************************************
 * arch/risc-v/src/hpm6000/hardware/hpm6300/hpm6300_gpio.h
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_RISCV_SRC_HPM6000_HARDWARE_HPM6300_HPM6300_GPIO_H
#define __ARCH_RISCV_SRC_HPM6000_HARDWARE_HPM6300_HPM6300_GPIO_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>
#include "hardware/hpm_memorymap.h"

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/* Register offsets *********************************************************/

#define HPM_GPIOA_OFFSET             0x0000 /* GPIOA Register Offset */
#define HPM_GPIOB_OFFSET             0x0010 /* GPIOB Register Offset */
#define HPM_GPIOC_OFFSET             0x0020 /* GPIOC Register Offset */
#define HPM_GPIOX_OFFSET             0x00d0 /* GPIOX Register Offset */
#define HPM_GPIOY_OFFSET             0x00e0 /* GPIOY Register Offset */
#define HPM_GPIOZ_OFFSET             0x00f0 /* GPIOZ Register Offset */

#define HPM_GPIO_VAL_OFFSET          0x0000 /* GPIO Value Register Offset */
#define HPM_GPIO_SET_OFFSET          0x0004 /* GPIO Set Register Offset */
#define HPM_GPIO_CLR_OFFSET          0x0008 /* GPIO Clear Register Offset */
#define HPM_GPIO_TGL_OFFSET          0x000c /* GPIO Toggle Register Offset */

#define HPM_GPIO_DI_OFFSET           0x0000 /* GPIO Data Input Register Offset */
#define HPM_GPIO_DO_OFFSET           0x0100 /* GPIO Data Output Register Offset */
#define HPM_GPIO_OE_OFFSET           0x0200 /* GPIO Output Enable Register Offset */
#define HPM_GPIO_IF_OFFSET           0x0300 /* GPIO Interrupt Flag Register Offset  */
#define HPM_GPIO_IE_OFFSET           0x0400 /* GPIO Interrupt Enable Register Offset */
#define HPM_GPIO_PL_OFFSET           0x0500 /* GPIO Interrupt Edge Register Offset */
#define HPM_GPIO_TP_OFFSET           0x0600 /* GPIO Interrupt Type Offset */
#define HPM_GPIO_AS_OFFSET           0x0700 /* GPIO Async Interrupt Offset */

#define HPM_GPIO_DI_VAL_OFFSET       (HPM_GPIO_DI_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIO_DI_SET_OFFSET       (HPM_GPIO_DI_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIO_DI_CLR_OFFSET       (HPM_GPIO_DI_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIO_DI_TGL_OFFSET       (HPM_GPIO_DI_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIO_DO_VAL_OFFSET       (HPM_GPIO_DO_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIO_DO_SET_OFFSET       (HPM_GPIO_DO_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIO_DO_CLR_OFFSET       (HPM_GPIO_DO_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIO_DO_TGL_OFFSET       (HPM_GPIO_DO_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIO_OE_VAL_OFFSET       (HPM_GPIO_OE_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIO_OE_SET_OFFSET       (HPM_GPIO_OE_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIO_OE_CLR_OFFSET       (HPM_GPIO_OE_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIO_OE_TGL_OFFSET       (HPM_GPIO_OE_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIO_IF_VAL_OFFSET       (HPM_GPIO_IF_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIO_IF_SET_OFFSET       (HPM_GPIO_IF_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIO_IF_CLR_OFFSET       (HPM_GPIO_IF_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIO_IF_TGL_OFFSET       (HPM_GPIO_IF_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIO_IE_VAL_OFFSET       (HPM_GPIO_IE_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIO_IE_SET_OFFSET       (HPM_GPIO_IE_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIO_IE_CLR_OFFSET       (HPM_GPIO_IE_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIO_IE_TGL_OFFSET       (HPM_GPIO_IE_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIO_PL_VAL_OFFSET       (HPM_GPIO_PL_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIO_PL_SET_OFFSET       (HPM_GPIO_PL_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIO_PL_CLR_OFFSET       (HPM_GPIO_PL_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIO_PL_TGL_OFFSET       (HPM_GPIO_PL_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIO_TP_VAL_OFFSET       (HPM_GPIO_TP_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIO_TP_SET_OFFSET       (HPM_GPIO_TP_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIO_TP_CLR_OFFSET       (HPM_GPIO_TP_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIO_TP_TGL_OFFSET       (HPM_GPIO_TP_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIO_AS_VAL_OFFSET       (HPM_GPIO_AS_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIO_AS_SET_OFFSET       (HPM_GPIO_AS_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIO_AS_CLR_OFFSET       (HPM_GPIO_AS_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIO_AS_TGL_OFFSET       (HPM_GPIO_AS_OFFSET + HPM_GPIO_TGL_OFFSET)

#define HPM_GPIOA_DI_VAL_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOA_DI_SET_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOA_DI_CLR_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOA_DI_TGL_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOA_DO_VAL_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOA_DO_SET_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOA_DO_CLR_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOA_DO_TGL_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOA_OE_VAL_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOA_OE_SET_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOA_OE_CLR_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOA_OE_TGL_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOA_IF_VAL_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOA_IF_SET_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOA_IF_CLR_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOA_IF_TGL_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOA_IE_VAL_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOA_IE_SET_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOA_IE_CLR_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOA_IE_TGL_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOA_PL_VAL_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOA_PL_SET_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOA_PL_CLR_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOA_PL_TGL_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOA_TP_VAL_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOA_TP_SET_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOA_TP_CLR_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOA_TP_TGL_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOA_AS_VAL_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOA_AS_SET_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOA_AS_CLR_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOA_AS_TGL_OFFSET      (HPM_GPIOA_OFFSET + HPM_GPIO_TGL_OFFSET)

#define HPM_GPIOB_DI_VAL_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOB_DI_SET_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOB_DI_CLR_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOB_DI_TGL_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOB_DO_VAL_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOB_DO_SET_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOB_DO_CLR_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOB_DO_TGL_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOB_OE_VAL_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOB_OE_SET_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOB_OE_CLR_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOB_OE_TGL_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOB_IF_VAL_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOB_IF_SET_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOB_IF_CLR_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOB_IF_TGL_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOB_IE_VAL_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOB_IE_SET_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOB_IE_CLR_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOB_IE_TGL_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOB_PL_VAL_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOB_PL_SET_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOB_PL_CLR_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOB_PL_TGL_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOB_TP_VAL_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOB_TP_SET_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOB_TP_CLR_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOB_TP_TGL_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOB_AS_VAL_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOB_AS_SET_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOB_AS_CLR_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOB_AS_TGL_OFFSET      (HPM_GPIOB_OFFSET + HPM_GPIO_TGL_OFFSET)

#define HPM_GPIOC_DI_VAL_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOC_DI_SET_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOC_DI_CLR_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOC_DI_TGL_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOC_DO_VAL_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOC_DO_SET_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOC_DO_CLR_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOC_DO_TGL_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOC_OE_VAL_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOC_OE_SET_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOC_OE_CLR_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOC_OE_TGL_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOC_IF_VAL_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOC_IF_SET_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOC_IF_CLR_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOC_IF_TGL_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOC_IE_VAL_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOC_IE_SET_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOC_IE_CLR_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOC_IE_TGL_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOC_PL_VAL_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOC_PL_SET_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOC_PL_CLR_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOC_PL_TGL_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOC_TP_VAL_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOC_TP_SET_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOC_TP_CLR_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOC_TP_TGL_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOC_AS_VAL_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOC_AS_SET_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOC_AS_CLR_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOC_AS_TGL_OFFSET      (HPM_GPIOC_OFFSET + HPM_GPIO_TGL_OFFSET)

#define HPM_GPIOX_DI_VAL_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOX_DI_SET_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOX_DI_CLR_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOX_DI_TGL_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOX_DO_VAL_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOX_DO_SET_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOX_DO_CLR_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOX_DO_TGL_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOX_OE_VAL_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOX_OE_SET_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOX_OE_CLR_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOX_OE_TGL_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOX_IF_VAL_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOX_IF_SET_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOX_IF_CLR_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOX_IF_TGL_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOX_IE_VAL_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOX_IE_SET_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOX_IE_CLR_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOX_IE_TGL_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOX_PL_VAL_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOX_PL_SET_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOX_PL_CLR_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOX_PL_TGL_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOX_TP_VAL_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOX_TP_SET_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOX_TP_CLR_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOX_TP_TGL_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOX_AS_VAL_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOX_AS_SET_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOX_AS_CLR_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOX_AS_TGL_OFFSET      (HPM_GPIOX_OFFSET + HPM_GPIO_TGL_OFFSET)

#define HPM_GPIOY_DI_VAL_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOY_DI_SET_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOY_DI_CLR_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOY_DI_TGL_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOY_DO_VAL_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOY_DO_SET_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOY_DO_CLR_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOY_DO_TGL_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOY_OE_VAL_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOY_OE_SET_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOY_OE_CLR_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOY_OE_TGL_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOY_IF_VAL_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOY_IF_SET_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOY_IF_CLR_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOY_IF_TGL_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOY_IE_VAL_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOY_IE_SET_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOY_IE_CLR_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOY_IE_TGL_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOY_PL_VAL_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOY_PL_SET_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOY_PL_CLR_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOY_PL_TGL_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOY_TP_VAL_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOY_TP_SET_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOY_TP_CLR_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOY_TP_TGL_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOY_AS_VAL_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOY_AS_SET_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOY_AS_CLR_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOY_AS_TGL_OFFSET      (HPM_GPIOY_OFFSET + HPM_GPIO_TGL_OFFSET)

#define HPM_GPIOZ_DI_VAL_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOZ_DI_SET_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOZ_DI_CLR_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOZ_DI_TGL_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOZ_DO_VAL_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOZ_DO_SET_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOZ_DO_CLR_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOZ_DO_TGL_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOZ_OE_VAL_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOZ_OE_SET_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOZ_OE_CLR_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOZ_OE_TGL_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOZ_IF_VAL_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOZ_IF_SET_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOZ_IF_CLR_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOZ_IF_TGL_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOZ_IE_VAL_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOZ_IE_SET_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOZ_IE_CLR_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOZ_IE_TGL_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOZ_PL_VAL_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOZ_PL_SET_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOZ_PL_CLR_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOZ_PL_TGL_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOZ_TP_VAL_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOZ_TP_SET_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOZ_TP_CLR_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOZ_TP_TGL_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_TGL_OFFSET)
#define HPM_GPIOZ_AS_VAL_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_VAL_OFFSET)
#define HPM_GPIOZ_AS_SET_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_SET_OFFSET)
#define HPM_GPIOZ_AS_CLR_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_CLR_OFFSET)
#define HPM_GPIOZ_AS_TGL_OFFSET      (HPM_GPIOZ_OFFSET + HPM_GPIO_TGL_OFFSET)

/* Register addresses *******************************************************/

#define HPM_GPIOA_DI_VAL           (HPM_GPIO0_BASE + HPM_GPIOA_DI_VAL_OFFSET)
#define HPM_GPIOA_DI_SET           (HPM_GPIO0_BASE + HPM_GPIOA_DI_SET_OFFSET)
#define HPM_GPIOA_DI_CLR           (HPM_GPIO0_BASE + HPM_GPIOA_DI_CLR_OFFSET)
#define HPM_GPIOA_DI_TGL           (HPM_GPIO0_BASE + HPM_GPIOA_DI_TGL_OFFSET)
#define HPM_GPIOA_DO_VAL           (HPM_GPIO0_BASE + HPM_GPIOA_DO_VAL_OFFSET)
#define HPM_GPIOA_DO_SET           (HPM_GPIO0_BASE + HPM_GPIOA_DO_SET_OFFSET)
#define HPM_GPIOA_DO_CLR           (HPM_GPIO0_BASE + HPM_GPIOA_DO_CLR_OFFSET)
#define HPM_GPIOA_DO_TGL           (HPM_GPIO0_BASE + HPM_GPIOA_DO_TGL_OFFSET)
#define HPM_GPIOA_OE_VAL           (HPM_GPIO0_BASE + HPM_GPIOA_OE_VAL_OFFSET)
#define HPM_GPIOA_OE_SET           (HPM_GPIO0_BASE + HPM_GPIOA_OE_SET_OFFSET)
#define HPM_GPIOA_OE_CLR           (HPM_GPIO0_BASE + HPM_GPIOA_OE_CLR_OFFSET)
#define HPM_GPIOA_OE_TGL           (HPM_GPIO0_BASE + HPM_GPIOA_OE_TGL_OFFSET)
#define HPM_GPIOA_IF_VAL           (HPM_GPIO0_BASE + HPM_GPIOA_IF_VAL_OFFSET)
#define HPM_GPIOA_IF_SET           (HPM_GPIO0_BASE + HPM_GPIOA_IF_SET_OFFSET)
#define HPM_GPIOA_IF_CLR           (HPM_GPIO0_BASE + HPM_GPIOA_IF_CLR_OFFSET)
#define HPM_GPIOA_IF_TGL           (HPM_GPIO0_BASE + HPM_GPIOA_IF_TGL_OFFSET)
#define HPM_GPIOA_IE_VAL           (HPM_GPIO0_BASE + HPM_GPIOA_IE_VAL_OFFSET)
#define HPM_GPIOA_IE_SET           (HPM_GPIO0_BASE + HPM_GPIOA_IE_SET_OFFSET)
#define HPM_GPIOA_IE_CLR           (HPM_GPIO0_BASE + HPM_GPIOA_IE_CLR_OFFSET)
#define HPM_GPIOA_IE_TGL           (HPM_GPIO0_BASE + HPM_GPIOA_IE_TGL_OFFSET)
#define HPM_GPIOA_PL_VAL           (HPM_GPIO0_BASE + HPM_GPIOA_PL_VAL_OFFSET)
#define HPM_GPIOA_PL_SET           (HPM_GPIO0_BASE + HPM_GPIOA_PL_SET_OFFSET)
#define HPM_GPIOA_PL_CLR           (HPM_GPIO0_BASE + HPM_GPIOA_PL_CLR_OFFSET)
#define HPM_GPIOA_PL_TGL           (HPM_GPIO0_BASE + HPM_GPIOA_PL_TGL_OFFSET)
#define HPM_GPIOA_TP_VAL           (HPM_GPIO0_BASE + HPM_GPIOA_TP_VAL_OFFSET)
#define HPM_GPIOA_TP_SET           (HPM_GPIO0_BASE + HPM_GPIOA_TP_SET_OFFSET)
#define HPM_GPIOA_TP_CLR           (HPM_GPIO0_BASE + HPM_GPIOA_TP_CLR_OFFSET)
#define HPM_GPIOA_TP_TGL           (HPM_GPIO0_BASE + HPM_GPIOA_TP_TGL_OFFSET)
#define HPM_GPIOA_AS_VAL           (HPM_GPIO0_BASE + HPM_GPIOA_AS_VAL_OFFSET)
#define HPM_GPIOA_AS_SET           (HPM_GPIO0_BASE + HPM_GPIOA_AS_SET_OFFSET)
#define HPM_GPIOA_AS_CLR           (HPM_GPIO0_BASE + HPM_GPIOA_AS_CLR_OFFSET)
#define HPM_GPIOA_AS_TGL           (HPM_GPIO0_BASE + HPM_GPIOA_AS_TGL_OFFSET)

#define HPM_GPIOB_DI_VAL           (HPM_GPIO0_BASE + HPM_GPIOB_DI_VAL_OFFSET)
#define HPM_GPIOB_DI_SET           (HPM_GPIO0_BASE + HPM_GPIOB_DI_SET_OFFSET)
#define HPM_GPIOB_DI_CLR           (HPM_GPIO0_BASE + HPM_GPIOB_DI_CLR_OFFSET)
#define HPM_GPIOB_DI_TGL           (HPM_GPIO0_BASE + HPM_GPIOB_DI_TGL_OFFSET)
#define HPM_GPIOB_DO_VAL           (HPM_GPIO0_BASE + HPM_GPIOB_DO_VAL_OFFSET)
#define HPM_GPIOB_DO_SET           (HPM_GPIO0_BASE + HPM_GPIOB_DO_SET_OFFSET)
#define HPM_GPIOB_DO_CLR           (HPM_GPIO0_BASE + HPM_GPIOB_DO_CLR_OFFSET)
#define HPM_GPIOB_DO_TGL           (HPM_GPIO0_BASE + HPM_GPIOB_DO_TGL_OFFSET)
#define HPM_GPIOB_OE_VAL           (HPM_GPIO0_BASE + HPM_GPIOB_OE_VAL_OFFSET)
#define HPM_GPIOB_OE_SET           (HPM_GPIO0_BASE + HPM_GPIOB_OE_SET_OFFSET)
#define HPM_GPIOB_OE_CLR           (HPM_GPIO0_BASE + HPM_GPIOB_OE_CLR_OFFSET)
#define HPM_GPIOB_OE_TGL           (HPM_GPIO0_BASE + HPM_GPIOB_OE_TGL_OFFSET)
#define HPM_GPIOB_IF_VAL           (HPM_GPIO0_BASE + HPM_GPIOB_IF_VAL_OFFSET)
#define HPM_GPIOB_IF_SET           (HPM_GPIO0_BASE + HPM_GPIOB_IF_SET_OFFSET)
#define HPM_GPIOB_IF_CLR           (HPM_GPIO0_BASE + HPM_GPIOB_IF_CLR_OFFSET)
#define HPM_GPIOB_IF_TGL           (HPM_GPIO0_BASE + HPM_GPIOB_IF_TGL_OFFSET)
#define HPM_GPIOB_IE_VAL           (HPM_GPIO0_BASE + HPM_GPIOB_IE_VAL_OFFSET)
#define HPM_GPIOB_IE_SET           (HPM_GPIO0_BASE + HPM_GPIOB_IE_SET_OFFSET)
#define HPM_GPIOB_IE_CLR           (HPM_GPIO0_BASE + HPM_GPIOB_IE_CLR_OFFSET)
#define HPM_GPIOB_IE_TGL           (HPM_GPIO0_BASE + HPM_GPIOB_IE_TGL_OFFSET)
#define HPM_GPIOB_PL_VAL           (HPM_GPIO0_BASE + HPM_GPIOB_PL_VAL_OFFSET)
#define HPM_GPIOB_PL_SET           (HPM_GPIO0_BASE + HPM_GPIOB_PL_SET_OFFSET)
#define HPM_GPIOB_PL_CLR           (HPM_GPIO0_BASE + HPM_GPIOB_PL_CLR_OFFSET)
#define HPM_GPIOB_PL_TGL           (HPM_GPIO0_BASE + HPM_GPIOB_PL_TGL_OFFSET)
#define HPM_GPIOB_TP_VAL           (HPM_GPIO0_BASE + HPM_GPIOB_TP_VAL_OFFSET)
#define HPM_GPIOB_TP_SET           (HPM_GPIO0_BASE + HPM_GPIOB_TP_SET_OFFSET)
#define HPM_GPIOB_TP_CLR           (HPM_GPIO0_BASE + HPM_GPIOB_TP_CLR_OFFSET)
#define HPM_GPIOB_TP_TGL           (HPM_GPIO0_BASE + HPM_GPIOB_TP_TGL_OFFSET)
#define HPM_GPIOB_AS_VAL           (HPM_GPIO0_BASE + HPM_GPIOB_AS_VAL_OFFSET)
#define HPM_GPIOB_AS_SET           (HPM_GPIO0_BASE + HPM_GPIOB_AS_SET_OFFSET)
#define HPM_GPIOB_AS_CLR           (HPM_GPIO0_BASE + HPM_GPIOB_AS_CLR_OFFSET)
#define HPM_GPIOB_AS_TGL           (HPM_GPIO0_BASE + HPM_GPIOB_AS_TGL_OFFSET)

#define HPM_GPIOC_DI_VAL           (HPM_GPIO0_BASE + HPM_GPIOC_DI_VAL_OFFSET)
#define HPM_GPIOC_DI_SET           (HPM_GPIO0_BASE + HPM_GPIOC_DI_SET_OFFSET)
#define HPM_GPIOC_DI_CLR           (HPM_GPIO0_BASE + HPM_GPIOC_DI_CLR_OFFSET)
#define HPM_GPIOC_DI_TGL           (HPM_GPIO0_BASE + HPM_GPIOC_DI_TGL_OFFSET)
#define HPM_GPIOC_DO_VAL           (HPM_GPIO0_BASE + HPM_GPIOC_DO_VAL_OFFSET)
#define HPM_GPIOC_DO_SET           (HPM_GPIO0_BASE + HPM_GPIOC_DO_SET_OFFSET)
#define HPM_GPIOC_DO_CLR           (HPM_GPIO0_BASE + HPM_GPIOC_DO_CLR_OFFSET)
#define HPM_GPIOC_DO_TGL           (HPM_GPIO0_BASE + HPM_GPIOC_DO_TGL_OFFSET)
#define HPM_GPIOC_OE_VAL           (HPM_GPIO0_BASE + HPM_GPIOC_OE_VAL_OFFSET)
#define HPM_GPIOC_OE_SET           (HPM_GPIO0_BASE + HPM_GPIOC_OE_SET_OFFSET)
#define HPM_GPIOC_OE_CLR           (HPM_GPIO0_BASE + HPM_GPIOC_OE_CLR_OFFSET)
#define HPM_GPIOC_OE_TGL           (HPM_GPIO0_BASE + HPM_GPIOC_OE_TGL_OFFSET)
#define HPM_GPIOC_IF_VAL           (HPM_GPIO0_BASE + HPM_GPIOC_IF_VAL_OFFSET)
#define HPM_GPIOC_IF_SET           (HPM_GPIO0_BASE + HPM_GPIOC_IF_SET_OFFSET)
#define HPM_GPIOC_IF_CLR           (HPM_GPIO0_BASE + HPM_GPIOC_IF_CLR_OFFSET)
#define HPM_GPIOC_IF_TGL           (HPM_GPIO0_BASE + HPM_GPIOC_IF_TGL_OFFSET)
#define HPM_GPIOC_IE_VAL           (HPM_GPIO0_BASE + HPM_GPIOC_IE_VAL_OFFSET)
#define HPM_GPIOC_IE_SET           (HPM_GPIO0_BASE + HPM_GPIOC_IE_SET_OFFSET)
#define HPM_GPIOC_IE_CLR           (HPM_GPIO0_BASE + HPM_GPIOC_IE_CLR_OFFSET)
#define HPM_GPIOC_IE_TGL           (HPM_GPIO0_BASE + HPM_GPIOC_IE_TGL_OFFSET)
#define HPM_GPIOC_PL_VAL           (HPM_GPIO0_BASE + HPM_GPIOC_PL_VAL_OFFSET)
#define HPM_GPIOC_PL_SET           (HPM_GPIO0_BASE + HPM_GPIOC_PL_SET_OFFSET)
#define HPM_GPIOC_PL_CLR           (HPM_GPIO0_BASE + HPM_GPIOC_PL_CLR_OFFSET)
#define HPM_GPIOC_PL_TGL           (HPM_GPIO0_BASE + HPM_GPIOC_PL_TGL_OFFSET)
#define HPM_GPIOC_TP_VAL           (HPM_GPIO0_BASE + HPM_GPIOC_TP_VAL_OFFSET)
#define HPM_GPIOC_TP_SET           (HPM_GPIO0_BASE + HPM_GPIOC_TP_SET_OFFSET)
#define HPM_GPIOC_TP_CLR           (HPM_GPIO0_BASE + HPM_GPIOC_TP_CLR_OFFSET)
#define HPM_GPIOC_TP_TGL           (HPM_GPIO0_BASE + HPM_GPIOC_TP_TGL_OFFSET)
#define HPM_GPIOC_AS_VAL           (HPM_GPIO0_BASE + HPM_GPIOC_AS_VAL_OFFSET)
#define HPM_GPIOC_AS_SET           (HPM_GPIO0_BASE + HPM_GPIOC_AS_SET_OFFSET)
#define HPM_GPIOC_AS_CLR           (HPM_GPIO0_BASE + HPM_GPIOC_AS_CLR_OFFSET)
#define HPM_GPIOC_AS_TGL           (HPM_GPIO0_BASE + HPM_GPIOC_AS_TGL_OFFSET)

#define HPM_GPIOX_DI_VAL           (HPM_GPIO0_BASE + HPM_GPIOX_DI_VAL_OFFSET)
#define HPM_GPIOX_DI_SET           (HPM_GPIO0_BASE + HPM_GPIOX_DI_SET_OFFSET)
#define HPM_GPIOX_DI_CLR           (HPM_GPIO0_BASE + HPM_GPIOX_DI_CLR_OFFSET)
#define HPM_GPIOX_DI_TGL           (HPM_GPIO0_BASE + HPM_GPIOX_DI_TGL_OFFSET)
#define HPM_GPIOX_DO_VAL           (HPM_GPIO0_BASE + HPM_GPIOX_DO_VAL_OFFSET)
#define HPM_GPIOX_DO_SET           (HPM_GPIO0_BASE + HPM_GPIOX_DO_SET_OFFSET)
#define HPM_GPIOX_DO_CLR           (HPM_GPIO0_BASE + HPM_GPIOX_DO_CLR_OFFSET)
#define HPM_GPIOX_DO_TGL           (HPM_GPIO0_BASE + HPM_GPIOX_DO_TGL_OFFSET)
#define HPM_GPIOX_OE_VAL           (HPM_GPIO0_BASE + HPM_GPIOX_OE_VAL_OFFSET)
#define HPM_GPIOX_OE_SET           (HPM_GPIO0_BASE + HPM_GPIOX_OE_SET_OFFSET)
#define HPM_GPIOX_OE_CLR           (HPM_GPIO0_BASE + HPM_GPIOX_OE_CLR_OFFSET)
#define HPM_GPIOX_OE_TGL           (HPM_GPIO0_BASE + HPM_GPIOX_OE_TGL_OFFSET)
#define HPM_GPIOX_IF_VAL           (HPM_GPIO0_BASE + HPM_GPIOX_IF_VAL_OFFSET)
#define HPM_GPIOX_IF_SET           (HPM_GPIO0_BASE + HPM_GPIOX_IF_SET_OFFSET)
#define HPM_GPIOX_IF_CLR           (HPM_GPIO0_BASE + HPM_GPIOX_IF_CLR_OFFSET)
#define HPM_GPIOX_IF_TGL           (HPM_GPIO0_BASE + HPM_GPIOX_IF_TGL_OFFSET)
#define HPM_GPIOX_IE_VAL           (HPM_GPIO0_BASE + HPM_GPIOX_IE_VAL_OFFSET)
#define HPM_GPIOX_IE_SET           (HPM_GPIO0_BASE + HPM_GPIOX_IE_SET_OFFSET)
#define HPM_GPIOX_IE_CLR           (HPM_GPIO0_BASE + HPM_GPIOX_IE_CLR_OFFSET)
#define HPM_GPIOX_IE_TGL           (HPM_GPIO0_BASE + HPM_GPIOX_IE_TGL_OFFSET)
#define HPM_GPIOX_PL_VAL           (HPM_GPIO0_BASE + HPM_GPIOX_PL_VAL_OFFSET)
#define HPM_GPIOX_PL_SET           (HPM_GPIO0_BASE + HPM_GPIOX_PL_SET_OFFSET)
#define HPM_GPIOX_PL_CLR           (HPM_GPIO0_BASE + HPM_GPIOX_PL_CLR_OFFSET)
#define HPM_GPIOX_PL_TGL           (HPM_GPIO0_BASE + HPM_GPIOX_PL_TGL_OFFSET)
#define HPM_GPIOX_TP_VAL           (HPM_GPIO0_BASE + HPM_GPIOX_TP_VAL_OFFSET)
#define HPM_GPIOX_TP_SET           (HPM_GPIO0_BASE + HPM_GPIOX_TP_SET_OFFSET)
#define HPM_GPIOX_TP_CLR           (HPM_GPIO0_BASE + HPM_GPIOX_TP_CLR_OFFSET)
#define HPM_GPIOX_TP_TGL           (HPM_GPIO0_BASE + HPM_GPIOX_TP_TGL_OFFSET)
#define HPM_GPIOX_AS_VAL           (HPM_GPIO0_BASE + HPM_GPIOX_AS_VAL_OFFSET)
#define HPM_GPIOX_AS_SET           (HPM_GPIO0_BASE + HPM_GPIOX_AS_SET_OFFSET)
#define HPM_GPIOX_AS_CLR           (HPM_GPIO0_BASE + HPM_GPIOX_AS_CLR_OFFSET)
#define HPM_GPIOX_AS_TGL           (HPM_GPIO0_BASE + HPM_GPIOX_AS_TGL_OFFSET)

#define HPM_GPIOY_DI_VAL           (HPM_GPIO0_BASE + HPM_GPIOY_DI_VAL_OFFSET)
#define HPM_GPIOY_DI_SET           (HPM_GPIO0_BASE + HPM_GPIOY_DI_SET_OFFSET)
#define HPM_GPIOY_DI_CLR           (HPM_GPIO0_BASE + HPM_GPIOY_DI_CLR_OFFSET)
#define HPM_GPIOY_DI_TGL           (HPM_GPIO0_BASE + HPM_GPIOY_DI_TGL_OFFSET)
#define HPM_GPIOY_DO_VAL           (HPM_GPIO0_BASE + HPM_GPIOY_DO_VAL_OFFSET)
#define HPM_GPIOY_DO_SET           (HPM_GPIO0_BASE + HPM_GPIOY_DO_SET_OFFSET)
#define HPM_GPIOY_DO_CLR           (HPM_GPIO0_BASE + HPM_GPIOY_DO_CLR_OFFSET)
#define HPM_GPIOY_DO_TGL           (HPM_GPIO0_BASE + HPM_GPIOY_DO_TGL_OFFSET)
#define HPM_GPIOY_OE_VAL           (HPM_GPIO0_BASE + HPM_GPIOY_OE_VAL_OFFSET)
#define HPM_GPIOY_OE_SET           (HPM_GPIO0_BASE + HPM_GPIOY_OE_SET_OFFSET)
#define HPM_GPIOY_OE_CLR           (HPM_GPIO0_BASE + HPM_GPIOY_OE_CLR_OFFSET)
#define HPM_GPIOY_OE_TGL           (HPM_GPIO0_BASE + HPM_GPIOY_OE_TGL_OFFSET)
#define HPM_GPIOY_IF_VAL           (HPM_GPIO0_BASE + HPM_GPIOY_IF_VAL_OFFSET)
#define HPM_GPIOY_IF_SET           (HPM_GPIO0_BASE + HPM_GPIOY_IF_SET_OFFSET)
#define HPM_GPIOY_IF_CLR           (HPM_GPIO0_BASE + HPM_GPIOY_IF_CLR_OFFSET)
#define HPM_GPIOY_IF_TGL           (HPM_GPIO0_BASE + HPM_GPIOY_IF_TGL_OFFSET)
#define HPM_GPIOY_IE_VAL           (HPM_GPIO0_BASE + HPM_GPIOY_IE_VAL_OFFSET)
#define HPM_GPIOY_IE_SET           (HPM_GPIO0_BASE + HPM_GPIOY_IE_SET_OFFSET)
#define HPM_GPIOY_IE_CLR           (HPM_GPIO0_BASE + HPM_GPIOY_IE_CLR_OFFSET)
#define HPM_GPIOY_IE_TGL           (HPM_GPIO0_BASE + HPM_GPIOY_IE_TGL_OFFSET)
#define HPM_GPIOY_PL_VAL           (HPM_GPIO0_BASE + HPM_GPIOY_PL_VAL_OFFSET)
#define HPM_GPIOY_PL_SET           (HPM_GPIO0_BASE + HPM_GPIOY_PL_SET_OFFSET)
#define HPM_GPIOY_PL_CLR           (HPM_GPIO0_BASE + HPM_GPIOY_PL_CLR_OFFSET)
#define HPM_GPIOY_PL_TGL           (HPM_GPIO0_BASE + HPM_GPIOY_PL_TGL_OFFSET)
#define HPM_GPIOY_TP_VAL           (HPM_GPIO0_BASE + HPM_GPIOY_TP_VAL_OFFSET)
#define HPM_GPIOY_TP_SET           (HPM_GPIO0_BASE + HPM_GPIOY_TP_SET_OFFSET)
#define HPM_GPIOY_TP_CLR           (HPM_GPIO0_BASE + HPM_GPIOY_TP_CLR_OFFSET)
#define HPM_GPIOY_TP_TGL           (HPM_GPIO0_BASE + HPM_GPIOY_TP_TGL_OFFSET)
#define HPM_GPIOY_AS_VAL           (HPM_GPIO0_BASE + HPM_GPIOY_AS_VAL_OFFSET)
#define HPM_GPIOY_AS_SET           (HPM_GPIO0_BASE + HPM_GPIOY_AS_SET_OFFSET)
#define HPM_GPIOY_AS_CLR           (HPM_GPIO0_BASE + HPM_GPIOY_AS_CLR_OFFSET)
#define HPM_GPIOY_AS_TGL           (HPM_GPIO0_BASE + HPM_GPIOY_AS_TGL_OFFSET)

#define HPM_GPIOZ_DI_VAL           (HPM_GPIO0_BASE + HPM_GPIOZ_DI_VAL_OFFSET)
#define HPM_GPIOZ_DI_SET           (HPM_GPIO0_BASE + HPM_GPIOZ_DI_SET_OFFSET)
#define HPM_GPIOZ_DI_CLR           (HPM_GPIO0_BASE + HPM_GPIOZ_DI_CLR_OFFSET)
#define HPM_GPIOZ_DI_TGL           (HPM_GPIO0_BASE + HPM_GPIOZ_DI_TGL_OFFSET)
#define HPM_GPIOZ_DO_VAL           (HPM_GPIO0_BASE + HPM_GPIOZ_DO_VAL_OFFSET)
#define HPM_GPIOZ_DO_SET           (HPM_GPIO0_BASE + HPM_GPIOZ_DO_SET_OFFSET)
#define HPM_GPIOZ_DO_CLR           (HPM_GPIO0_BASE + HPM_GPIOZ_DO_CLR_OFFSET)
#define HPM_GPIOZ_DO_TGL           (HPM_GPIO0_BASE + HPM_GPIOZ_DO_TGL_OFFSET)
#define HPM_GPIOZ_OE_VAL           (HPM_GPIO0_BASE + HPM_GPIOZ_OE_VAL_OFFSET)
#define HPM_GPIOZ_OE_SET           (HPM_GPIO0_BASE + HPM_GPIOZ_OE_SET_OFFSET)
#define HPM_GPIOZ_OE_CLR           (HPM_GPIO0_BASE + HPM_GPIOZ_OE_CLR_OFFSET)
#define HPM_GPIOZ_OE_TGL           (HPM_GPIO0_BASE + HPM_GPIOZ_OE_TGL_OFFSET)
#define HPM_GPIOZ_IF_VAL           (HPM_GPIO0_BASE + HPM_GPIOZ_IF_VAL_OFFSET)
#define HPM_GPIOZ_IF_SET           (HPM_GPIO0_BASE + HPM_GPIOZ_IF_SET_OFFSET)
#define HPM_GPIOZ_IF_CLR           (HPM_GPIO0_BASE + HPM_GPIOZ_IF_CLR_OFFSET)
#define HPM_GPIOZ_IF_TGL           (HPM_GPIO0_BASE + HPM_GPIOZ_IF_TGL_OFFSET)
#define HPM_GPIOZ_IE_VAL           (HPM_GPIO0_BASE + HPM_GPIOZ_IE_VAL_OFFSET)
#define HPM_GPIOZ_IE_SET           (HPM_GPIO0_BASE + HPM_GPIOZ_IE_SET_OFFSET)
#define HPM_GPIOZ_IE_CLR           (HPM_GPIO0_BASE + HPM_GPIOZ_IE_CLR_OFFSET)
#define HPM_GPIOZ_IE_TGL           (HPM_GPIO0_BASE + HPM_GPIOZ_IE_TGL_OFFSET)
#define HPM_GPIOZ_PL_VAL           (HPM_GPIO0_BASE + HPM_GPIOZ_PL_VAL_OFFSET)
#define HPM_GPIOZ_PL_SET           (HPM_GPIO0_BASE + HPM_GPIOZ_PL_SET_OFFSET)
#define HPM_GPIOZ_PL_CLR           (HPM_GPIO0_BASE + HPM_GPIOZ_PL_CLR_OFFSET)
#define HPM_GPIOZ_PL_TGL           (HPM_GPIO0_BASE + HPM_GPIOZ_PL_TGL_OFFSET)
#define HPM_GPIOZ_TP_VAL           (HPM_GPIO0_BASE + HPM_GPIOZ_TP_VAL_OFFSET)
#define HPM_GPIOZ_TP_SET           (HPM_GPIO0_BASE + HPM_GPIOZ_TP_SET_OFFSET)
#define HPM_GPIOZ_TP_CLR           (HPM_GPIO0_BASE + HPM_GPIOZ_TP_CLR_OFFSET)
#define HPM_GPIOZ_TP_TGL           (HPM_GPIO0_BASE + HPM_GPIOZ_TP_TGL_OFFSET)
#define HPM_GPIOZ_AS_VAL           (HPM_GPIO0_BASE + HPM_GPIOZ_AS_VAL_OFFSET)
#define HPM_GPIOZ_AS_SET           (HPM_GPIO0_BASE + HPM_GPIOZ_AS_SET_OFFSET)
#define HPM_GPIOZ_AS_CLR           (HPM_GPIO0_BASE + HPM_GPIOZ_AS_CLR_OFFSET)
#define HPM_GPIOZ_AS_TGL           (HPM_GPIO0_BASE + HPM_GPIOZ_AS_TGL_OFFSET)

#endif /* __ARCH_RISCV_SRC_HPM6000_HARDWARE_HPM6300_HPM6300_GPIO_H */