/****************************************************************************
 * arch/misoc/include/syscall.h
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

/* This file should never be included directly but, rather, only indirectly
 * through include/syscall.h or include/sys/sycall.h
 */

#ifndef __ARCH_MISOC_INCLUDE_SYSCALL_H
#define __ARCH_MISOC_INCLUDE_SYSCALL_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

/* Include LM32 architecture-specific syscall macros */

#ifdef CONFIG_ARCH_CHIP_LM32
# include <arch/lm32/syscall.h>
#endif

#ifdef CONFIG_ARCH_CHIP_MINERVA
# include <arch/minerva/syscall.h>
#endif

#endif /* __ARCH_MISOC_INCLUDE_SYSCALL_H */
