/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "core/flow/Node.h"

namespace org::apache::nifi::minifi::core::flow {

Node::Iterator::Value Node::Iterator::operator*() const {
  Value value = impl_->operator*();
  if (value) {
    // sequence iterator
    value.path_ = utils::StringUtils::join_pack(path_, "/", std::to_string(idx_));
  } else if (value.second) {
    // map iterator
    value.second.path_ = utils::StringUtils::join_pack(path_, "/", value.first.getString().value());
  }
  return value;
}

}  // namespace org::apache::nifi::minifi::core::flow
