/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import org.apache.nifi.flow.VersionedReportingTaskSnapshot;
import org.apache.nifi.toolkit.cli.api.WritableResult;
import org.apache.nifi.toolkit.cli.impl.util.JacksonUtils;

public class VersionedReportingTaskSnapshotResult
implements WritableResult<VersionedReportingTaskSnapshot> {
    private final VersionedReportingTaskSnapshot versionedReportingTaskSnapshot;
    private final String exportFileName;

    public VersionedReportingTaskSnapshotResult(VersionedReportingTaskSnapshot versionedReportingTaskSnapshot, String exportFileName) {
        this.versionedReportingTaskSnapshot = Objects.requireNonNull(versionedReportingTaskSnapshot);
        this.exportFileName = exportFileName;
    }

    @Override
    public VersionedReportingTaskSnapshot getResult() {
        return this.versionedReportingTaskSnapshot;
    }

    @Override
    public void write(PrintStream output) throws IOException {
        if (this.exportFileName != null) {
            try (FileOutputStream resultOut = new FileOutputStream(this.exportFileName);){
                JacksonUtils.write(this.versionedReportingTaskSnapshot, resultOut);
            }
        } else {
            JacksonUtils.write(this.versionedReportingTaskSnapshot, output);
        }
    }
}

