/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.init;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.nifi.logging.ComponentLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionUtils.class);

    public static boolean quietlyInvokeMethodsWithAnnotation(Class<? extends Annotation> annotation, Object instance, ComponentLog logger, Object ... args) {
        for (Method method : instance.getClass().getMethods()) {
            if (!method.isAnnotationPresent(annotation)) continue;
            method.setAccessible(true);
            Class<?>[] argumentTypes = method.getParameterTypes();
            if (argumentTypes.length > args.length) {
                if (logger == null) {
                    LOG.error("Unable to invoke method {} on {} because method expects {} parameters but only {} were given", new Object[]{method.getName(), instance, argumentTypes.length, args.length});
                } else {
                    logger.error("Unable to invoke method {} on {} because method expects {} parameters but only {} were given", new Object[]{method.getName(), instance, argumentTypes.length, args.length});
                }
                return false;
            }
            for (int i = 0; i < argumentTypes.length; ++i) {
                Class<?> argType = argumentTypes[i];
                if (argType.isAssignableFrom(args[i].getClass())) continue;
                if (logger == null) {
                    LOG.error("Unable to invoke method {} on {} because method parameter {} is expected to be of type {} but argument passed was of type {}", new Object[]{method.getName(), instance, i, argType, args[i].getClass()});
                } else {
                    logger.error("Unable to invoke method {} on {} because method parameter {} is expected to be of type {} but argument passed was of type {}", new Object[]{method.getName(), instance, i, argType, args[i].getClass()});
                }
                return false;
            }
            try {
                if (argumentTypes.length == args.length) {
                    method.invoke(instance, args);
                    continue;
                }
                Object[] argsToPass = new Object[argumentTypes.length];
                System.arraycopy(args, 0, argsToPass, 0, argsToPass.length);
                method.invoke(instance, argsToPass);
            }
            catch (InvocationTargetException ite) {
                if (logger == null) {
                    LOG.error("Unable to invoke method {} on {}", new Object[]{method.getName(), instance, ite.getCause()});
                    LOG.error("", ite.getCause());
                    continue;
                }
                logger.error("Unable to invoke method {} on {}", new Object[]{method.getName(), instance, ite.getCause()});
            }
            catch (IllegalAccessException | IllegalArgumentException t) {
                if (logger == null) {
                    LOG.error("Unable to invoke method {} on {}", new Object[]{method.getName(), instance, t});
                    LOG.error("", (Throwable)t);
                } else {
                    logger.error("Unable to invoke method {} on {}", new Object[]{method.getName(), instance, t});
                }
                return false;
            }
        }
        return true;
    }
}

