/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.io.File;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.kerberos.KerberosConfig;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessorInitializationContext;

public class StandardProcessorInitializationContext
implements ProcessorInitializationContext {
    private final String identifier;
    private final ComponentLog logger;
    private final ControllerServiceProvider serviceProvider;
    private final NodeTypeProvider nodeTypeProvider;
    private final KerberosConfig kerberosConfig;

    public StandardProcessorInitializationContext(String identifier, ComponentLog componentLog, ControllerServiceProvider serviceProvider, NodeTypeProvider nodeTypeProvider, KerberosConfig kerberosConfig) {
        this.identifier = identifier;
        this.logger = componentLog;
        this.serviceProvider = serviceProvider;
        this.nodeTypeProvider = nodeTypeProvider;
        this.kerberosConfig = kerberosConfig;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ComponentLog getLogger() {
        return this.logger;
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this.serviceProvider;
    }

    public NodeTypeProvider getNodeTypeProvider() {
        return this.nodeTypeProvider;
    }

    public String getKerberosServicePrincipal() {
        return this.kerberosConfig.getPrincipal();
    }

    public File getKerberosServiceKeytab() {
        return this.kerberosConfig.getKeytabLocation();
    }

    public File getKerberosConfigurationFile() {
        return this.kerberosConfig.getConfigFile();
    }
}

