/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.vault.hashicorp.config.lookup;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.vault.hashicorp.HashiCorpVaultConfigurationException;
import org.apache.nifi.vault.hashicorp.config.HashiCorpVaultProperty;
import org.apache.nifi.vault.hashicorp.config.lookup.PropertyLookup;
import org.apache.nifi.vault.hashicorp.config.lookup.ValuePropertyLookup;
import org.springframework.beans.BeanUtils;

public class BeanPropertyLookup
extends PropertyLookup {
    private static final String SEPARATOR = ".";
    private final Map<String, PropertyLookup> propertyLookupMap;

    public BeanPropertyLookup(String prefix, Class<?> beanClass) {
        this(prefix, beanClass, null);
    }

    private BeanPropertyLookup(String prefix, Class<?> beanClass, PropertyDescriptor propertyDescriptor) {
        super(propertyDescriptor);
        this.propertyLookupMap = Arrays.stream(BeanUtils.getPropertyDescriptors(beanClass)).filter(pd -> pd.getReadMethod().getAnnotation(HashiCorpVaultProperty.class) != null).collect(Collectors.toMap(pd -> BeanPropertyLookup.getPropertyKey(prefix, pd), pd -> this.isValueProperty((PropertyDescriptor)pd) ? new ValuePropertyLookup((PropertyDescriptor)pd) : new BeanPropertyLookup(BeanPropertyLookup.getPropertyKey(prefix, pd), pd.getReadMethod().getReturnType(), (PropertyDescriptor)pd)));
    }

    private boolean isValueProperty(PropertyDescriptor propertyDescriptor) {
        Class<?> returnType = propertyDescriptor.getReadMethod().getReturnType();
        return returnType.equals(String.class) || returnType.isPrimitive();
    }

    private static String getPropertyKey(String prefix, PropertyDescriptor propertyDescriptor) {
        HashiCorpVaultProperty propertyAnnotation = propertyDescriptor.getReadMethod().getAnnotation(HashiCorpVaultProperty.class);
        String unqualifiedPropertyKey = !propertyAnnotation.key().isEmpty() ? propertyAnnotation.key() : propertyDescriptor.getDisplayName();
        return prefix == null ? unqualifiedPropertyKey : String.join((CharSequence)SEPARATOR, prefix, unqualifiedPropertyKey);
    }

    @Override
    public Object getPropertyValue(String propertyKey, Object obj) {
        if (this.propertyLookupMap.containsKey(propertyKey)) {
            PropertyLookup propertyLookup = this.propertyLookupMap.get(propertyKey);
            return propertyLookup.getPropertyValue(propertyKey, propertyLookup.getEnclosingObject(obj));
        }
        for (Map.Entry<String, PropertyLookup> entry : this.propertyLookupMap.entrySet()) {
            String key = entry.getKey();
            if (!propertyKey.startsWith(key + SEPARATOR)) continue;
            PropertyLookup propertyLookup = entry.getValue();
            return propertyLookup.getPropertyValue(propertyKey, propertyLookup.getEnclosingObject(obj));
        }
        return null;
    }

    @Override
    public Object getEnclosingObject(Object obj) {
        try {
            return this.getPropertyDescriptor().getReadMethod().invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new HashiCorpVaultConfigurationException("Could not invoke " + this.getPropertyDescriptor().getDisplayName());
        }
    }
}

