/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import java.io.IOException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.RequestConfig;
import org.apache.nifi.registry.client.impl.AbstractJerseyClient;
import org.apache.nifi.registry.revision.entity.RevisionInfo;

public class AbstractCRUDJerseyClient
extends AbstractJerseyClient {
    protected final WebTarget baseTarget;

    public AbstractCRUDJerseyClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.baseTarget = baseTarget;
    }

    protected <T> T get(String id, Class<T> entityType, String entityTypeName, String entityPath) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException(entityTypeName + " id cannot be blank");
        }
        return (T)this.executeAction("Error retrieving " + entityTypeName.toLowerCase(), () -> {
            WebTarget target = this.baseTarget.path(entityPath).path(id);
            return this.getRequestBuilder(target).get(entityType);
        });
    }

    protected <T> T create(T entity, Class<T> entityType, String entityTypeName, String entityPath) throws NiFiRegistryException, IOException {
        if (entity == null) {
            throw new IllegalArgumentException(entityTypeName + " cannot be null");
        }
        return (T)this.executeAction("Error creating " + entityTypeName.toLowerCase(), () -> {
            WebTarget target = this.baseTarget.path(entityPath);
            return this.getRequestBuilder(target).post(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE), entityType);
        });
    }

    protected <T> T update(T entity, String id, Class<T> entityType, String entityTypeName, String entityPath) throws NiFiRegistryException, IOException {
        if (entity == null) {
            throw new IllegalArgumentException(entityTypeName + " cannot be null");
        }
        return (T)this.executeAction("Error updating " + entityTypeName.toLowerCase(), () -> {
            WebTarget target = this.baseTarget.path(entityPath).path(id);
            return this.getRequestBuilder(target).put(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE), entityType);
        });
    }

    protected <T> T delete(String id, RevisionInfo revisionInfo, Class<T> entityType, String entityTypeName, String entityPath) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException(entityTypeName + " id cannot be blank");
        }
        return (T)this.executeAction("Error deleting " + entityTypeName.toLowerCase(), () -> {
            WebTarget target = this.baseTarget.path(entityPath).path(id);
            target = this.addRevisionQueryParams(target, revisionInfo);
            return this.getRequestBuilder(target).delete(entityType);
        });
    }
}

