/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.mp.EagerThreadSetup;
import io.questdb.network.IOContextFactory;
import io.questdb.network.IODispatcher;
import io.questdb.network.MutableIOContext;
import io.questdb.std.Misc;
import io.questdb.std.ObjectFactory;
import io.questdb.std.ThreadLocal;
import io.questdb.std.WeakMutableObjectPool;
import java.io.Closeable;

public class MutableIOContextFactory<C extends MutableIOContext<C>>
implements IOContextFactory<C>,
Closeable,
EagerThreadSetup {
    private final ThreadLocal<WeakMutableObjectPool<C>> contextPool = new ThreadLocal<WeakMutableObjectPool>(() -> new WeakMutableObjectPool(factory, poolSize));
    private volatile boolean closed = false;

    public MutableIOContextFactory(ObjectFactory<C> factory, int poolSize) {
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void done(C context) {
        if (this.closed) {
            Misc.free(context);
        } else {
            context.of(-1, null);
            this.contextPool.get().push(context);
        }
    }

    public void freeThreadLocal() {
        Misc.free(this.contextPool);
    }

    @Override
    public C newInstance(int fd, IODispatcher<C> dispatcher) {
        return ((MutableIOContext)this.contextPool.get().pop()).of(fd, dispatcher);
    }

    @Override
    public void setup() {
        this.contextPool.get();
    }
}

