/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.ObjList;

public class GroupByFunctionsUpdaterFactory {
    private static final int FIELD_POOL_OFFSET = 3;

    private GroupByFunctionsUpdaterFactory() {
    }

    public static GroupByFunctionsUpdater getInstance(BytecodeAssembler asm, ObjList<GroupByFunction> groupByFunctions) {
        asm.init(GroupByFunctionsUpdater.class);
        asm.setupPool();
        int thisClassIndex = asm.poolClass(asm.poolUtf8("io/questdb/griffin/engine/groupby/GroupByFunctionsUpdaterAsm"));
        int superclassIndex = asm.poolClass(Object.class);
        int interfaceClassIndex = asm.poolClass(GroupByFunctionsUpdater.class);
        int superIndex = asm.poolMethod(superclassIndex, (CharSequence)"<init>", (CharSequence)"()V");
        int typeIndex = asm.poolUtf8("Lio/questdb/griffin/engine/functions/GroupByFunction;");
        int functionSize = groupByFunctions.size();
        int firstFieldNameIndex = 0;
        int firstFieldIndex = 0;
        for (int i = 0; i < functionSize; ++i) {
            int fieldNameIndex = asm.poolUtf8().put("f").put(i).$();
            int nameAndType = asm.poolNameAndType(fieldNameIndex, typeIndex);
            int fieldIndex = asm.poolField(thisClassIndex, nameAndType);
            if (i != 0) continue;
            firstFieldNameIndex = fieldNameIndex;
            firstFieldIndex = fieldIndex;
        }
        int computeFirstIndex = asm.poolInterfaceMethod(GroupByFunction.class, "computeFirst", "(Lio/questdb/cairo/map/MapValue;Lio/questdb/cairo/sql/Record;)V");
        int computeNextIndex = asm.poolInterfaceMethod(GroupByFunction.class, "computeNext", "(Lio/questdb/cairo/map/MapValue;Lio/questdb/cairo/sql/Record;)V");
        int setEmptyIndex = asm.poolInterfaceMethod(GroupByFunction.class, "setEmpty", "(Lio/questdb/cairo/map/MapValue;)V");
        int updateNewIndex = asm.poolUtf8("updateNew");
        int updateNewSigIndex = asm.poolUtf8("(Lio/questdb/cairo/map/MapValue;Lio/questdb/cairo/sql/Record;)V");
        int updateExistingIndex = asm.poolUtf8("updateExisting");
        int updateExistingSigIndex = asm.poolUtf8("(Lio/questdb/cairo/map/MapValue;Lio/questdb/cairo/sql/Record;)V");
        int updateEmptyIndex = asm.poolUtf8("updateEmpty");
        int updateEmptySigIndex = asm.poolUtf8("(Lio/questdb/cairo/map/MapValue;)V");
        int setFunctionsIndex = asm.poolUtf8("setFunctions");
        int setFunctionsSigIndex = asm.poolUtf8("(Lio/questdb/std/ObjList;)V");
        int getIndex = asm.poolMethod(ObjList.class, (CharSequence)"get", (CharSequence)"(I)Ljava/lang/Object;");
        asm.finishPool();
        asm.defineClass(thisClassIndex, superclassIndex);
        asm.interfaceCount(1);
        asm.putShort(interfaceClassIndex);
        asm.fieldCount(functionSize);
        for (int i = 0; i < functionSize; ++i) {
            asm.defineField(firstFieldNameIndex + i * 3, typeIndex);
        }
        asm.methodCount(5);
        asm.defineDefaultConstructor(superIndex);
        GroupByFunctionsUpdaterFactory.generateUpdateNew(asm, functionSize, firstFieldIndex, computeFirstIndex, updateNewIndex, updateNewSigIndex);
        GroupByFunctionsUpdaterFactory.generateUpdateExisting(asm, functionSize, firstFieldIndex, computeNextIndex, updateExistingIndex, updateExistingSigIndex);
        GroupByFunctionsUpdaterFactory.generateUpdateEmpty(asm, functionSize, firstFieldIndex, setEmptyIndex, updateEmptyIndex, updateEmptySigIndex);
        GroupByFunctionsUpdaterFactory.generateSetFunction(asm, functionSize, firstFieldIndex, setFunctionsIndex, setFunctionsSigIndex, getIndex);
        asm.putShort(0);
        GroupByFunctionsUpdater updater = (GroupByFunctionsUpdater)asm.newInstance();
        updater.setFunctions(groupByFunctions);
        return updater;
    }

    private static void generateSetFunction(BytecodeAssembler asm, int functionSize, int firstFieldIndex, int setFunctionsIndex, int setFunctionsSigIndex, int getIndex) {
        asm.startMethod(setFunctionsIndex, setFunctionsSigIndex, 3, 3);
        for (int i = 0; i < functionSize; ++i) {
            asm.aload(0);
            asm.aload(1);
            asm.iconst(i);
            asm.invokeVirtual(getIndex);
            asm.putfield(firstFieldIndex + i * 3);
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
    }

    private static void generateUpdateEmpty(BytecodeAssembler asm, int fieldCount, int firstFieldIndex, int setEmptyIndex, int updateNameIndex, int updateSigIndex) {
        asm.startMethod(updateNameIndex, updateSigIndex, 3, 3);
        for (int i = 0; i < fieldCount; ++i) {
            asm.aload(0);
            asm.getfield(firstFieldIndex + i * 3);
            asm.aload(1);
            asm.invokeInterface(setEmptyIndex, 1);
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
    }

    private static void generateUpdateExisting(BytecodeAssembler asm, int fieldCount, int firstFieldIndex, int computeNextIndex, int updateNameIndex, int updateSigIndex) {
        asm.startMethod(updateNameIndex, updateSigIndex, 3, 3);
        for (int i = 0; i < fieldCount; ++i) {
            asm.aload(0);
            asm.getfield(firstFieldIndex + i * 3);
            asm.aload(1);
            asm.aload(2);
            asm.invokeInterface(computeNextIndex, 2);
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
    }

    private static void generateUpdateNew(BytecodeAssembler asm, int fieldCount, int firstFieldIndex, int computeFirstIndex, int updateNameIndex, int updateSigIndex) {
        asm.startMethod(updateNameIndex, updateSigIndex, 3, 3);
        for (int i = 0; i < fieldCount; ++i) {
            asm.aload(0);
            asm.getfield(firstFieldIndex + i * 3);
            asm.aload(1);
            asm.aload(2);
            asm.invokeInterface(computeFirstIndex, 2);
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
    }
}

