/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.AbstractRecordMetadata;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.cairo.wal.seq.TableRecordMetadataSink;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.str.Path;

public class WalWriterMetadata
extends AbstractRecordMetadata
implements TableRecordMetadata,
TableRecordMetadataSink {
    private final FilesFacade ff;
    private final MemoryMARW metaMem;
    private final MemoryMR roMetaMem;
    private long structureVersion = -1L;
    private boolean suspended;
    private int tableId;
    private TableToken tableToken;

    public WalWriterMetadata(FilesFacade ff) {
        this(ff, false);
    }

    public WalWriterMetadata(FilesFacade ff, boolean readonly) {
        this.ff = ff;
        if (!readonly) {
            this.metaMem = Vm.getMARWInstance();
            this.roMetaMem = this.metaMem;
        } else {
            this.metaMem = null;
            this.roMetaMem = Vm.getMRInstance();
        }
    }

    @Override
    public void addColumn(String columnName, int columnType, boolean columnIndexed, int indexValueBlockCapacity, boolean symbolTableStatic, int writerIndex) {
        this.addColumn0(columnName, columnType);
    }

    public void addColumn(CharSequence columnName, int columnType) {
        this.addColumn0(columnName, columnType);
        ++this.structureVersion;
    }

    @Override
    public void close() {
        this.clear((byte)0);
    }

    public void close(byte truncateMode) {
        this.clear(truncateMode);
    }

    @Override
    public long getStructureVersion() {
        return this.structureVersion;
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    @Override
    public TableToken getTableToken() {
        return this.tableToken;
    }

    @Override
    public boolean isWalEnabled() {
        return true;
    }

    @Override
    public void of(TableToken tableToken, int tableId, int timestampIndex, int compressedTimestampIndex, boolean suspended, long structureVersion, int columnCount) {
        this.tableToken = tableToken;
        this.tableId = tableId;
        this.timestampIndex = timestampIndex;
        this.suspended = suspended;
        this.structureVersion = structureVersion;
    }

    public void removeColumn(CharSequence columnName) {
        int columnIndex = this.columnNameIndexMap.get(columnName);
        if (columnIndex < 0) {
            throw CairoException.critical(0).put("Column not found: ").put(columnName);
        }
        this.columnNameIndexMap.remove(columnName);
        TableColumnMetadata deletedMeta = (TableColumnMetadata)this.columnMetadata.getQuick(columnIndex);
        deletedMeta.markDeleted();
        ++this.structureVersion;
    }

    public void renameColumn(CharSequence columnName, CharSequence newName) {
        int columnIndex = this.columnNameIndexMap.get(columnName);
        if (columnIndex < 0) {
            throw CairoException.critical(0).put("Column not found: ").put(columnName);
        }
        String newNameStr = newName.toString();
        ((TableColumnMetadata)this.columnMetadata.getQuick(columnIndex)).setName(newNameStr);
        this.columnNameIndexMap.removeEntry(columnName);
        this.columnNameIndexMap.put(newNameStr, columnIndex);
        ++this.structureVersion;
    }

    public void switchTo(Path path, int pathLen) {
        if (this.metaMem.getFd() > -1) {
            this.metaMem.close(true, (byte)1);
        }
        TableUtils.openSmallFile(this.ff, path, pathLen, this.metaMem, "_meta", 38);
        this.syncToMetaFile();
    }

    private void addColumn0(CharSequence columnName, int columnType) {
        String name = columnName.toString();
        if (columnType > 0) {
            this.columnNameIndexMap.put(name, this.columnMetadata.size());
        }
        this.columnMetadata.add(new TableColumnMetadata(name, columnType, false, 0, false, null, this.columnMetadata.size()));
        ++this.columnCount;
    }

    private void reset() {
        this.columnMetadata.clear();
        this.columnNameIndexMap.clear();
        this.columnCount = 0;
        this.timestampIndex = -1;
        this.tableToken = null;
        this.tableId = -1;
        this.suspended = false;
    }

    protected void clear(byte truncateMode) {
        this.reset();
        if (this.metaMem != null) {
            this.metaMem.close(true, truncateMode);
        }
        Misc.free(this.roMetaMem);
    }

    void syncToMetaFile() {
        this.metaMem.jumpTo(0L);
        this.metaMem.putInt(0);
        this.metaMem.putInt(0);
        this.metaMem.putLong(this.structureVersion);
        this.metaMem.putInt(this.columnCount);
        this.metaMem.putInt(this.timestampIndex);
        this.metaMem.putInt(this.tableId);
        this.metaMem.putBool(this.suspended);
        for (int i = 0; i < this.columnCount; ++i) {
            int columnType = this.getColumnType(i);
            this.metaMem.putInt(columnType);
            this.metaMem.putStr(this.getColumnName(i));
        }
        this.metaMem.putInt(0L, (int)this.metaMem.getAppendOffset());
    }
}

