/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.web.authentication.logout;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.cookie.ApplicationCookieService;
import org.apache.nifi.web.security.cookie.StandardApplicationCookieService;
import org.apache.nifi.web.util.RequestUriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequest;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestRepository;

public class StandardSaml2LogoutRequestRepository
implements Saml2LogoutRequestRepository {
    private static final Logger logger = LoggerFactory.getLogger(StandardSaml2LogoutRequestRepository.class);
    private static final ApplicationCookieService applicationCookieService = new StandardApplicationCookieService();
    private final Cache cache;

    public StandardSaml2LogoutRequestRepository(Cache cache) {
        this.cache = Objects.requireNonNull(cache, "Cache required");
    }

    public Saml2LogoutRequest loadLogoutRequest(HttpServletRequest request) {
        Saml2LogoutRequest logoutRequest;
        Objects.requireNonNull(request, "Request required");
        Optional<String> requestIdentifier = applicationCookieService.getCookieValue(request, ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER);
        if (requestIdentifier.isPresent()) {
            String identifier = requestIdentifier.get();
            logoutRequest = (Saml2LogoutRequest)this.cache.get((Object)identifier, Saml2LogoutRequest.class);
            if (logoutRequest == null) {
                logger.warn("SAML Logout Request [{}] not found", (Object)identifier);
            }
        } else {
            logger.warn("SAML Logout Request Identifier cookie not found");
            logoutRequest = null;
        }
        return logoutRequest;
    }

    public void saveLogoutRequest(Saml2LogoutRequest logoutRequest, HttpServletRequest request, HttpServletResponse response) {
        Objects.requireNonNull(request, "Request required");
        Objects.requireNonNull(response, "Response required");
        if (logoutRequest == null) {
            this.removeLogoutRequest(request, response);
        } else {
            Objects.requireNonNull(logoutRequest.getRelayState(), "Relay State required");
            Optional<String> requestIdentifier = applicationCookieService.getCookieValue(request, ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER);
            String identifier = requestIdentifier.orElse(UUID.randomUUID().toString());
            this.cache.put((Object)identifier, (Object)logoutRequest);
            URI resourceUri = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)request).build();
            applicationCookieService.addCookie(resourceUri, response, ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER, identifier);
            logger.debug("SAML Logout Request [{}] saved", (Object)identifier);
        }
    }

    public Saml2LogoutRequest removeLogoutRequest(HttpServletRequest request, HttpServletResponse response) {
        Objects.requireNonNull(request, "Request required");
        Objects.requireNonNull(response, "Response required");
        Saml2LogoutRequest logoutRequest = this.loadLogoutRequest(request);
        if (logoutRequest == null) {
            logger.warn("SAML Logout Request not found");
        } else {
            URI resourceUri = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)request).build();
            applicationCookieService.removeCookie(resourceUri, response, ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER);
            Optional<String> requestIdentifier = applicationCookieService.getCookieValue(request, ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER);
            requestIdentifier.ifPresent(arg_0 -> ((Cache)this.cache).evict(arg_0));
        }
        return logoutRequest;
    }
}

