/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.configuration;

import org.apache.nifi.deprecation.log.DeprecationLogger;
import org.apache.nifi.deprecation.log.DeprecationLoggerFactory;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.kerberos.KerberosService;
import org.apache.nifi.web.security.spring.KerberosServiceFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class KerberosAuthenticationSecurityConfiguration {
    private static final DeprecationLogger deprecationLogger = DeprecationLoggerFactory.getLogger(KerberosAuthenticationSecurityConfiguration.class);
    private final NiFiProperties niFiProperties;

    @Autowired
    public KerberosAuthenticationSecurityConfiguration(NiFiProperties niFiProperties) {
        this.niFiProperties = niFiProperties;
        if (niFiProperties.isKerberosSpnegoSupportEnabled()) {
            deprecationLogger.warn("Support for Kerberos SPNEGO authentication is deprecated for removal in NiFi 2", new Object[0]);
        }
    }

    @Bean
    public KerberosService kerberosService() throws Exception {
        KerberosServiceFactoryBean kerberosServiceFactoryBean = new KerberosServiceFactoryBean();
        kerberosServiceFactoryBean.setProperties(this.niFiProperties);
        return kerberosServiceFactoryBean.getObject();
    }
}

