/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.ldap.tenants;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.User;

public class TenantHolder {
    private final Set<User> allUsers;
    private final Map<String, User> usersById;
    private final Map<String, User> usersByIdentity;
    private final Set<Group> allGroups;
    private final Map<String, Group> groupsById;
    private final Map<String, Set<Group>> groupsByUserIdentity;

    public TenantHolder(Set<User> allUsers, Set<Group> allGroups) {
        Map<String, User> userByIdMap = Collections.unmodifiableMap(this.createUserByIdMap(allUsers));
        Map<String, User> userByIdentityMap = Collections.unmodifiableMap(this.createUserByIdentityMap(allUsers));
        Map<String, Group> groupByIdMap = Collections.unmodifiableMap(this.createGroupByIdMap(allGroups));
        Map<String, Set<Group>> groupsByUserIdentityMap = Collections.unmodifiableMap(this.createGroupsByUserIdentityMap(allGroups, allUsers));
        this.allUsers = allUsers;
        this.allGroups = allGroups;
        this.usersById = userByIdMap;
        this.usersByIdentity = userByIdentityMap;
        this.groupsById = groupByIdMap;
        this.groupsByUserIdentity = groupsByUserIdentityMap;
    }

    private Map<String, User> createUserByIdMap(Set<User> users) {
        HashMap<String, User> usersMap = new HashMap<String, User>();
        for (User user : users) {
            usersMap.put(user.getIdentifier(), user);
        }
        return usersMap;
    }

    private Map<String, User> createUserByIdentityMap(Set<User> users) {
        HashMap<String, User> usersMap = new HashMap<String, User>();
        for (User user : users) {
            usersMap.put(user.getIdentity(), user);
        }
        return usersMap;
    }

    private Map<String, Group> createGroupByIdMap(Set<Group> groups) {
        HashMap<String, Group> groupsMap = new HashMap<String, Group>();
        for (Group group : groups) {
            groupsMap.put(group.getIdentifier(), group);
        }
        return groupsMap;
    }

    private Map<String, Set<Group>> createGroupsByUserIdentityMap(Set<Group> groups, Set<User> users) {
        HashMap<String, Set<Group>> groupsByUserIdentity = new HashMap<String, Set<Group>>();
        for (User user : users) {
            HashSet<Group> userGroups = new HashSet<Group>();
            for (Group group : groups) {
                for (String groupUser : group.getUsers()) {
                    if (!groupUser.equals(user.getIdentifier())) continue;
                    userGroups.add(group);
                }
            }
            groupsByUserIdentity.put(user.getIdentity(), userGroups);
        }
        return groupsByUserIdentity;
    }

    Set<User> getAllUsers() {
        return this.allUsers;
    }

    Map<String, User> getUsersById() {
        return this.usersById;
    }

    Set<Group> getAllGroups() {
        return this.allGroups;
    }

    Map<String, Group> getGroupsById() {
        return this.groupsById;
    }

    public User getUser(String identity) {
        if (identity == null) {
            throw new IllegalArgumentException("Identity cannot be null");
        }
        return this.usersByIdentity.get(identity);
    }

    public Set<Group> getGroups(String userIdentity) {
        if (userIdentity == null) {
            throw new IllegalArgumentException("User Identity cannot be null");
        }
        return this.groupsByUserIdentity.get(userIdentity);
    }
}

