/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.shell;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.User;
import org.apache.nifi.registry.security.authorization.UserAndGroups;
import org.apache.nifi.registry.security.authorization.UserGroupProvider;
import org.apache.nifi.registry.security.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.registry.security.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.registry.security.authorization.shell.NssShellCommands;
import org.apache.nifi.registry.security.authorization.shell.OsxShellCommands;
import org.apache.nifi.registry.security.authorization.shell.ShellCommandsProvider;
import org.apache.nifi.registry.security.authorization.shell.ShellRunner;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.exception.SecurityProviderDestructionException;
import org.apache.nifi.registry.util.FormatUtils;
import org.apache.nifi.registry.util.PropertyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellUserGroupProvider
implements UserGroupProvider {
    private static final Logger logger = LoggerFactory.getLogger(ShellUserGroupProvider.class);
    private static final String OS_TYPE_ERROR = "Unsupported operating system.";
    private static final String SYS_CHECK_ERROR = "System check failed - cannot provide users and groups.";
    private static final Map<String, User> usersById = new HashMap<String, User>();
    private static final Map<String, User> usersByName = new HashMap<String, User>();
    private static final Map<String, Group> groupsById = new HashMap<String, Group>();
    public static final String REFRESH_DELAY_PROPERTY = "Refresh Delay";
    private static final long MINIMUM_SYNC_INTERVAL_MILLISECONDS = 10000L;
    public static final String EXCLUDE_USER_PROPERTY = "Exclude Users";
    public static final String EXCLUDE_GROUP_PROPERTY = "Exclude Groups";
    public static final String COMMAND_TIMEOUT_PROPERTY = "Command Timeout";
    private static final String DEFAULT_COMMAND_TIMEOUT = "60 seconds";
    private long fixedDelay;
    private Pattern excludeUsers;
    private Pattern excludeGroups;
    private int timeoutSeconds;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
    private ShellCommandsProvider selectedShellCommands;
    private ShellRunner shellRunner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<User> getUsers() throws AuthorizationAccessException {
        Map<String, User> map = usersById;
        synchronized (map) {
            logger.debug("getUsers has user set of size: " + usersById.size());
            return new HashSet<User>(usersById.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String identifier) throws AuthorizationAccessException {
        User user;
        Map<String, User> map = usersById;
        synchronized (map) {
            user = usersById.get(identifier);
        }
        if (user == null) {
            logger.debug("getUser (by id) user not found: " + identifier);
        } else {
            logger.debug("getUser (by id) found user: " + user + " for id: " + identifier);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserByIdentity(String identity) throws AuthorizationAccessException {
        User user;
        Map<String, User> map = usersByName;
        synchronized (map) {
            user = usersByName.get(identity);
        }
        if (user == null) {
            logger.debug("getUser (by name) user not found: " + identity);
        } else {
            logger.debug("getUser (by name) found user: " + user.getIdentity() + " for name: " + identity);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Group> getGroups() throws AuthorizationAccessException {
        Map<String, Group> map = groupsById;
        synchronized (map) {
            logger.debug("getGroups has group set of size: " + groupsById.size());
            return new HashSet<Group>(groupsById.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroup(String identifier) throws AuthorizationAccessException {
        Group group;
        Map<String, Group> map = groupsById;
        synchronized (map) {
            group = groupsById.get(identifier);
        }
        if (group == null) {
            logger.debug("getGroup (by id) group not found: " + identifier);
        } else {
            logger.debug("getGroup (by id) found group: " + group.getName() + " for id: " + identifier);
        }
        return group;
    }

    public UserAndGroups getUserAndGroups(String identity) throws AuthorizationAccessException {
        final User user = this.getUserByIdentity(identity);
        logger.debug("Retrieved user {} for identity {}", (Object)user, (Object)identity);
        final HashSet<Group> groups = new HashSet<Group>();
        if (user != null) {
            for (Group g : this.getGroups()) {
                if (!g.getUsers().contains(user.getIdentifier())) continue;
                logger.debug("User {} belongs to group {}", (Object)user.getIdentity(), (Object)g.getName());
                groups.add(g);
            }
        }
        if (groups.isEmpty()) {
            logger.debug("User {} belongs to no groups", (Object)user);
        }
        return new UserAndGroups(){

            public User getUser() {
                return user;
            }

            public Set<Group> getGroups() {
                return groups;
            }
        };
    }

    public void initialize(UserGroupProviderInitializationContext initializationContext) throws SecurityProviderCreationException {
    }

    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
        logger.info("Configuring ShellUserGroupProvider");
        this.fixedDelay = this.getDelayProperty(configurationContext, REFRESH_DELAY_PROPERTY, "5 mins");
        this.timeoutSeconds = this.getTimeoutProperty(configurationContext, COMMAND_TIMEOUT_PROPERTY, DEFAULT_COMMAND_TIMEOUT);
        this.shellRunner = new ShellRunner(this.timeoutSeconds);
        logger.debug("Configured ShellRunner with command timeout of '{}' seconds", (Object)this.timeoutSeconds);
        ShellCommandsProvider commands = this.getCommandsProvider();
        if (commands == null) {
            commands = ShellUserGroupProvider.getCommandsProviderFromName(null);
            this.setCommandsProvider(commands);
        }
        try {
            this.shellRunner.runShell(commands.getSystemCheck(), "Supported System Check");
        }
        catch (Exception e) {
            logger.error("initialize exception: " + e + " system check command: " + commands.getSystemCheck());
            throw new SecurityProviderCreationException(SYS_CHECK_ERROR, (Throwable)e);
        }
        try {
            this.excludeGroups = Pattern.compile(this.getProperty(configurationContext, EXCLUDE_GROUP_PROPERTY, ""));
            this.excludeUsers = Pattern.compile(this.getProperty(configurationContext, EXCLUDE_USER_PROPERTY, ""));
        }
        catch (PatternSyntaxException e) {
            throw new SecurityProviderCreationException((Throwable)e);
        }
        this.refreshUsersAndGroups();
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.refreshUsersAndGroups();
            }
            catch (Throwable t) {
                logger.error("", t);
            }
        }, this.fixedDelay, this.fixedDelay, TimeUnit.MILLISECONDS);
        logger.info("Completed configuration of ShellUserGroupProvider");
    }

    private static ShellCommandsProvider getCommandsProviderFromName(String osName) {
        ShellCommandsProvider commands;
        if (osName == null) {
            osName = System.getProperty("os.name");
        }
        if (osName.startsWith("Linux")) {
            logger.debug("Selected Linux command set.");
            commands = new NssShellCommands();
        } else if (osName.startsWith("Mac OS X")) {
            logger.debug("Selected OSX command set.");
            commands = new OsxShellCommands();
        } else {
            throw new SecurityProviderCreationException(OS_TYPE_ERROR);
        }
        return commands;
    }

    private String getProperty(AuthorizerConfigurationContext authContext, String propertyName, String defaultValue) {
        PropertyValue property = authContext.getProperty(propertyName);
        String value = property != null && property.isSet() ? property.getValue() : defaultValue;
        return value;
    }

    private long getDelayProperty(AuthorizerConfigurationContext authContext, String propertyName, String defaultValue) {
        long syncInterval;
        PropertyValue intervalProperty = authContext.getProperty(propertyName);
        String propertyValue = intervalProperty.isSet() ? intervalProperty.getValue() : defaultValue;
        try {
            syncInterval = Math.round(FormatUtils.getPreciseTimeDuration((String)propertyValue, (TimeUnit)TimeUnit.MILLISECONDS));
        }
        catch (IllegalArgumentException ignored) {
            throw new SecurityProviderCreationException(String.format("The %s '%s' is not a valid time interval.", propertyName, propertyValue));
        }
        if (syncInterval < 10000L) {
            throw new SecurityProviderCreationException(String.format("The %s '%s' is below the minimum value of '%d ms'", propertyName, propertyValue, 10000L));
        }
        return syncInterval;
    }

    private int getTimeoutProperty(AuthorizerConfigurationContext authContext, String propertyName, String defaultValue) {
        long timeoutValue;
        PropertyValue timeoutProperty = authContext.getProperty(propertyName);
        String propertyValue = timeoutProperty.isSet() ? timeoutProperty.getValue() : defaultValue;
        try {
            timeoutValue = Math.round(FormatUtils.getPreciseTimeDuration((String)propertyValue, (TimeUnit)TimeUnit.SECONDS));
        }
        catch (IllegalArgumentException ignored) {
            throw new SecurityProviderCreationException(String.format("The %s '%s' is not a valid time interval.", propertyName, propertyValue));
        }
        return Math.toIntExact(timeoutValue);
    }

    public void preDestruction() throws SecurityProviderDestructionException {
        try {
            this.scheduler.shutdownNow();
        }
        catch (Exception e) {
            logger.warn("Error shutting down refresh scheduler: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.shellRunner.shutdown();
        }
        catch (Exception e) {
            logger.warn("Error shutting down ShellRunner: " + e.getMessage(), (Throwable)e);
        }
    }

    public ShellCommandsProvider getCommandsProvider() {
        return this.selectedShellCommands;
    }

    public void setCommandsProvider(ShellCommandsProvider commandsProvider) {
        this.selectedShellCommands = commandsProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshUsersAndGroups() {
        List<String> groupLines;
        List<String> userLines;
        long startTime = System.currentTimeMillis();
        HashMap<String, User> uidToUser = new HashMap<String, User>();
        HashMap<String, User> usernameToUser = new HashMap<String, User>();
        HashMap<String, User> gidToUser = new HashMap<String, User>();
        HashMap<String, Group> gidToGroup = new HashMap<String, Group>();
        try {
            userLines = this.shellRunner.runShell(this.selectedShellCommands.getUsersList(), "Get Users List");
            groupLines = this.shellRunner.runShell(this.selectedShellCommands.getGroupsList(), "Get Groups List");
        }
        catch (IOException ioexc) {
            logger.error("refreshUsersAndGroups shell exception: " + ioexc);
            return;
        }
        this.rebuildUsers(userLines, uidToUser, usernameToUser, gidToUser);
        this.rebuildGroups(groupLines, gidToGroup);
        this.reconcilePrimaryGroups(gidToUser, gidToGroup);
        Map<String, User> ioexc = usersById;
        synchronized (ioexc) {
            usersById.clear();
            usersById.putAll(uidToUser);
            if (logger.isTraceEnabled()) {
                logger.trace("=== Users by id...");
                TreeSet<User> sortedUsers = new TreeSet<User>(Comparator.comparing(User::getIdentity));
                sortedUsers.addAll(usersById.values());
                sortedUsers.forEach(u -> logger.trace("=== " + u.toString()));
            }
        }
        ioexc = usersByName;
        synchronized (ioexc) {
            usersByName.clear();
            usersByName.putAll(usernameToUser);
            logger.debug("users now size: " + usersByName.size());
        }
        ioexc = groupsById;
        synchronized (ioexc) {
            groupsById.clear();
            groupsById.putAll(gidToGroup);
            logger.debug("groups now size: " + groupsById.size());
            if (logger.isTraceEnabled()) {
                logger.trace("=== Groups by id...");
                TreeSet<Group> sortedGroups = new TreeSet<Group>(Comparator.comparing(Group::getName));
                sortedGroups.addAll(groupsById.values());
                sortedGroups.forEach(g -> logger.trace("=== " + g.toString()));
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info("Refreshed users and groups, took {} seconds", (Object)((endTime - startTime) / 1000L));
    }

    private void rebuildUsers(List<String> userLines, Map<String, User> idToUser, Map<String, User> usernameToUser, Map<String, User> gidToUser) {
        userLines.forEach(line -> {
            logger.trace("Processing user: {}", line);
            String[] record = line.split(":");
            if (record.length > 2) {
                String userIdentity = record[0];
                String userIdentifier = record[1];
                String primaryGroupIdentifier = record[2];
                if (!(StringUtils.isBlank((CharSequence)userIdentifier) || StringUtils.isBlank((CharSequence)userIdentity) || this.excludeUsers.matcher(userIdentity).matches())) {
                    User user = new User.Builder().identity(userIdentity).identifierGenerateFromSeed(this.getUserIdentifierSeed(userIdentity)).build();
                    idToUser.put(user.getIdentifier(), user);
                    usernameToUser.put(userIdentity, user);
                    logger.debug("Refreshed user {}", (Object)user);
                    if (!StringUtils.isBlank((CharSequence)primaryGroupIdentifier)) {
                        Group group = new Group.Builder().name(primaryGroupIdentifier).identifierGenerateFromSeed(this.getGroupIdentifierSeed(primaryGroupIdentifier)).build();
                        gidToUser.put(group.getIdentifier(), user);
                        logger.debug("Associated primary group {} with user {}", (Object)group.getIdentifier(), (Object)userIdentity);
                    } else {
                        logger.warn("Null or empty primary group id for: " + userIdentity);
                    }
                } else {
                    logger.warn("Null, empty, or skipped user name: " + userIdentity + " or id: " + userIdentifier);
                }
            } else {
                logger.warn("Unexpected record format.  Expected 3 or more colon separated values per line.");
            }
        });
    }

    private void rebuildGroups(List<String> groupLines, Map<String, Group> groupsById) {
        groupLines.forEach(line -> {
            logger.trace("Processing group: {}", line);
            String[] record = line.split(":");
            if (record.length > 1) {
                HashSet<String> users = new HashSet<String>();
                String groupName = record[0];
                String groupIdentifier = record[1];
                try {
                    String groupMembersCommand = this.selectedShellCommands.getGroupMembers(groupName);
                    List<String> memberLines = this.shellRunner.runShell(groupMembersCommand, "Get Group Members");
                    if (!memberLines.isEmpty()) {
                        String memberLine = memberLines.get(0);
                        if (!StringUtils.isBlank((CharSequence)memberLine)) {
                            String[] members;
                            for (String userIdentity : members = memberLine.split(",")) {
                                if (StringUtils.isBlank((CharSequence)userIdentity)) continue;
                                User tempUser = new User.Builder().identity(userIdentity).identifierGenerateFromSeed(this.getUserIdentifierSeed(userIdentity)).build();
                                users.add(tempUser.getIdentifier());
                                logger.debug("Added temp user {} for group {}", (Object)tempUser, (Object)groupName);
                            }
                        } else {
                            logger.debug("list membership returned no members");
                        }
                    } else {
                        logger.debug("list membership returned zero lines.");
                    }
                    if (memberLines.size() > 1) {
                        logger.error("list membership returned too many lines, only used the first.");
                    }
                }
                catch (IOException ioexc) {
                    logger.error("list membership shell exception: " + ioexc);
                }
                if (!(StringUtils.isBlank((CharSequence)groupIdentifier) || StringUtils.isBlank((CharSequence)groupName) || this.excludeGroups.matcher(groupName).matches())) {
                    Group group = new Group.Builder().name(groupName).identifierGenerateFromSeed(this.getGroupIdentifierSeed(groupIdentifier)).addUsers(users).build();
                    groupsById.put(group.getIdentifier(), group);
                    logger.debug("Refreshed group {}", (Object)group);
                } else {
                    logger.warn("Null, empty, or skipped group name: " + groupName + " or id: " + groupIdentifier);
                }
            } else {
                logger.warn("Unexpected record format.  Expected 1 or more comma separated values.");
            }
        });
    }

    private void reconcilePrimaryGroups(Map<String, User> uidToUser, Map<String, Group> gidToGroup) {
        uidToUser.forEach((primaryGid, primaryUser) -> {
            Group primaryGroup = (Group)gidToGroup.get(primaryGid);
            if (primaryGroup == null) {
                logger.warn("Primary group {} not found for {}", primaryGid, (Object)primaryUser.getIdentity());
            } else if (!this.excludeGroups.matcher(primaryGroup.getName()).matches()) {
                Set groupUsers = primaryGroup.getUsers();
                if (!groupUsers.contains(primaryUser.getIdentifier())) {
                    HashSet<String> updatedUserIdentifiers = new HashSet<String>(groupUsers);
                    updatedUserIdentifiers.add(primaryUser.getIdentifier());
                    Group updatedGroup = new Group.Builder().identifier(primaryGroup.getIdentifier()).name(primaryGroup.getName()).addUsers(updatedUserIdentifiers).build();
                    gidToGroup.put(updatedGroup.getIdentifier(), updatedGroup);
                    logger.debug("Added user {} to primary group {}", primaryUser, (Object)updatedGroup);
                } else {
                    logger.debug("Primary group {} already contains user {}", (Object)primaryGroup, primaryUser);
                }
            } else {
                logger.debug("Primary group {} excluded from matcher for {}", (Object)primaryGroup.getName(), (Object)primaryUser.getIdentity());
            }
        });
    }

    private String getUserIdentifierSeed(String userIdentifier) {
        return userIdentifier + "-user";
    }

    private String getGroupIdentifierSeed(String groupIdentifier) {
        return groupIdentifier + "-group";
    }

    public long getRefreshDelay() {
        return this.fixedDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCaches() {
        Map<String, User> map = usersById;
        synchronized (map) {
            usersById.clear();
        }
        map = usersByName;
        synchronized (map) {
            usersByName.clear();
        }
        map = groupsById;
        synchronized (map) {
            groupsById.clear();
        }
    }

    public int userCacheSize() {
        return usersById.size();
    }

    public int groupCacheSize() {
        return groupsById.size();
    }
}

